/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.AbstractVarPattern;
import ai.grakn.graql.internal.pattern.property.HasAttributeProperty;
import ai.grakn.graql.internal.pattern.property.LabelProperty;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class VarPatternImpl
extends AbstractVarPattern {
    protected final Logger LOG = LoggerFactory.getLogger(VarPatternImpl.class);

    VarPatternImpl() {
    }

    @Override
    public abstract Var var();

    @Override
    protected abstract Set<VarProperty> properties();

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractVarPattern var = (AbstractVarPattern)o;
        if (this.var().isUserDefinedName() != var.var().isUserDefinedName()) {
            return false;
        }
        if (!this.properties().equals(var.properties())) {
            return false;
        }
        return !this.var().isUserDefinedName() || this.var().equals((Object)var.var());
    }

    public final int hashCode() {
        int result = this.properties().hashCode();
        if (this.var().isUserDefinedName()) {
            result = 31 * result + this.var().hashCode();
        }
        result = 31 * result + (this.var().isUserDefinedName() ? 1 : 0);
        return result;
    }

    public final String toString() {
        Collection<VarPatternAdmin> innerVars = this.innerVarPatterns();
        innerVars.remove(this);
        this.getProperties(HasAttributeProperty.class).map(HasAttributeProperty::attribute).flatMap(r -> r.innerVarPatterns().stream()).forEach(innerVars::remove);
        if (innerVars.stream().anyMatch(VarPatternImpl::invalidInnerVariable)) {
            this.LOG.warn("printing a query with inner variables, which is not supported in native Graql");
        }
        StringBuilder builder = new StringBuilder();
        String name = this.var().isUserDefinedName() ? this.var().toString() : "";
        builder.append(name);
        if (this.var().isUserDefinedName() && !this.properties().isEmpty()) {
            builder.append(" ");
        }
        boolean first = true;
        for (VarProperty property : this.properties()) {
            if (!first) {
                builder.append(" ");
            }
            first = false;
            property.buildString(builder);
        }
        return builder.toString();
    }

    private static boolean invalidInnerVariable(VarPatternAdmin var) {
        return var.getProperties().anyMatch(p -> !(p instanceof LabelProperty));
    }
}

