/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.AutoValue_HasAttributeTypeProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.NeqProperty;
import ai.grakn.graql.internal.pattern.property.PlaysProperty;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.reasoner.atom.binary.type.HasAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public abstract class HasAttributeTypeProperty
extends AbstractVarProperty
implements NamedProperty {
    abstract VarPatternAdmin resourceType();

    abstract VarPatternAdmin ownerRole();

    abstract VarPatternAdmin valueRole();

    abstract VarPatternAdmin relationOwner();

    abstract VarPatternAdmin relationValue();

    abstract boolean required();

    public static HasAttributeTypeProperty of(VarPatternAdmin resourceType, boolean required) {
        Label resourceLabel = (Label)resourceType.getTypeLabel().orElseThrow(() -> GraqlQueryException.noLabelSpecifiedForHas((VarPattern)resourceType));
        VarPattern role = Graql.label(Schema.MetaSchema.ROLE.getLabel());
        VarPatternAdmin ownerRole = Graql.var().sub(role).admin();
        VarPatternAdmin valueRole = Graql.var().sub(role).admin();
        VarPattern relationType = Graql.var().sub(Graql.label(Schema.MetaSchema.RELATIONSHIP.getLabel()));
        if (required) {
            ownerRole = ownerRole.label(Schema.ImplicitType.KEY_OWNER.getLabel(resourceLabel)).admin();
            valueRole = valueRole.label(Schema.ImplicitType.KEY_VALUE.getLabel(resourceLabel)).admin();
            relationType = relationType.label(Schema.ImplicitType.KEY.getLabel(resourceLabel));
        }
        VarPatternAdmin relationOwner = relationType.relates((VarPattern)ownerRole).admin();
        VarPatternAdmin relationValue = relationType.admin().var().relates((VarPattern)valueRole).admin();
        return new AutoValue_HasAttributeTypeProperty(resourceType, ownerRole, valueRole, relationOwner, relationValue, required);
    }

    @Override
    public String getName() {
        return this.required() ? "key" : "has";
    }

    @Override
    public String getProperty() {
        return this.resourceType().getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        HashSet<EquivalentFragmentSet> traversals = new HashSet<EquivalentFragmentSet>();
        traversals.addAll(PlaysProperty.of(this.ownerRole(), this.required()).match(start));
        traversals.addAll(PlaysProperty.of(this.valueRole(), false).match(this.resourceType().var()));
        traversals.addAll(NeqProperty.of(this.ownerRole()).match(this.valueRole().var()));
        return traversals;
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.resourceType());
    }

    @Override
    public Stream<VarPatternAdmin> innerVarPatterns() {
        return Stream.of(this.resourceType());
    }

    @Override
    public Stream<VarPatternAdmin> implicitInnerVarPatterns() {
        return Stream.of(this.resourceType(), this.ownerRole(), this.valueRole(), this.relationOwner(), this.relationValue());
    }

    @Override
    public Collection<PropertyExecutor> define(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Type entityTypeConcept = executor.get(var).asType();
            AttributeType attributeTypeConcept = executor.get(this.resourceType().var()).asAttributeType();
            if (this.required()) {
                entityTypeConcept.key(attributeTypeConcept);
            } else {
                entityTypeConcept.attribute(attributeTypeConcept);
            }
        };
        return ImmutableSet.of((Object)PropertyExecutor.builder(method).requires(var, this.resourceType().var()).build());
    }

    @Override
    public Collection<PropertyExecutor> undefine(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Type type = executor.get(var).asType();
            AttributeType attributeType = executor.get(this.resourceType().var()).asAttributeType();
            if (!type.isDeleted() && !attributeType.isDeleted()) {
                if (this.required()) {
                    type.deleteKey(attributeType);
                } else {
                    type.deleteAttribute(attributeType);
                }
            }
        };
        return ImmutableSet.of((Object)PropertyExecutor.builder(method).requires(var, this.resourceType().var()).build());
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.var().asUserDefined();
        Label label = this.resourceType().getTypeLabel().orElse(null);
        Var predicateVar = Graql.var().asUserDefined();
        SchemaConcept schemaConcept = parent.tx().getSchemaConcept(label);
        IdPredicate predicate = new IdPredicate(predicateVar, (Concept)schemaConcept, parent);
        VarPatternAdmin resVar = varName.has(Graql.label(label)).admin();
        return new HasAtom((VarPattern)resVar, predicateVar, predicate, parent);
    }
}

