/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.AutoValue_RelationshipProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.query.QueryOperationExecutor;
import ai.grakn.graql.internal.reasoner.atom.binary.RelationshipAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.util.CommonUtil;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class RelationshipProperty
extends AbstractVarProperty
implements UniqueVarProperty {
    public static RelationshipProperty of(ImmutableMultiset<RelationPlayer> relationPlayers) {
        return new AutoValue_RelationshipProperty(relationPlayers);
    }

    public abstract ImmutableMultiset<RelationPlayer> relationPlayers();

    @Override
    String getName() {
        return "relationship";
    }

    public void buildString(StringBuilder builder) {
        builder.append("(").append(this.relationPlayers().stream().map(Object::toString).collect(Collectors.joining(", "))).append(")");
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        HashSet castingNames = new HashSet();
        ImmutableSet traversals = (ImmutableSet)this.relationPlayers().stream().flatMap(relationPlayer -> {
            Var castingName = Graql.var();
            castingNames.add(castingName);
            return this.equivalentFragmentSetFromCasting(start, castingName, (RelationPlayer)relationPlayer);
        }).collect(CommonUtil.toImmutableSet());
        ImmutableSet distinctCastingTraversals = (ImmutableSet)castingNames.stream().flatMap(castingName -> castingNames.stream().filter(otherName -> !otherName.equals(castingName)).map(otherName -> EquivalentFragmentSets.neq(this, castingName, otherName))).collect(CommonUtil.toImmutableSet());
        return Sets.union((Set)traversals, (Set)distinctCastingTraversals);
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return this.relationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream);
    }

    @Override
    public Stream<VarPatternAdmin> innerVarPatterns() {
        return this.relationPlayers().stream().flatMap(relationPlayer -> {
            Stream.Builder<VarPatternAdmin> builder = Stream.builder();
            builder.add(relationPlayer.getRolePlayer());
            relationPlayer.getRole().ifPresent(builder::add);
            return builder.build();
        });
    }

    private Stream<EquivalentFragmentSet> equivalentFragmentSetFromCasting(Var start, Var castingName, RelationPlayer relationPlayer) {
        Optional roleType = relationPlayer.getRole();
        if (roleType.isPresent()) {
            return this.addRelatesPattern(start, castingName, (VarPatternAdmin)roleType.get(), relationPlayer.getRolePlayer());
        }
        return this.addRelatesPattern(start, castingName, relationPlayer.getRolePlayer());
    }

    private Stream<EquivalentFragmentSet> addRelatesPattern(Var start, Var casting, VarPatternAdmin rolePlayer) {
        return Stream.of(EquivalentFragmentSets.rolePlayer(this, start, casting, rolePlayer.var(), null));
    }

    private Stream<EquivalentFragmentSet> addRelatesPattern(Var start, Var casting, VarPatternAdmin roleType, VarPatternAdmin rolePlayer) {
        return Stream.of(EquivalentFragmentSets.rolePlayer(this, start, casting, rolePlayer.var(), roleType.var()));
    }

    @Override
    public void checkValidProperty(GraknTx graph, VarPatternAdmin var) throws GraqlQueryException {
        Set<Label> roleTypes = this.relationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).collect(Collectors.toSet());
        Optional maybeLabel = var.getProperty(IsaProperty.class).map(IsaProperty::type).flatMap(VarPatternAdmin::getTypeLabel);
        maybeLabel.ifPresent(label -> {
            SchemaConcept schemaConcept = graph.getSchemaConcept(label);
            if (schemaConcept == null || !schemaConcept.isRelationshipType()) {
                throw GraqlQueryException.notARelationType((Label)label);
            }
        });
        roleTypes.forEach(roleId -> {
            SchemaConcept schemaConcept = graph.getSchemaConcept(roleId);
            if (schemaConcept == null || !schemaConcept.isRole()) {
                throw GraqlQueryException.notARoleType((Label)roleId);
            }
        });
    }

    @Override
    public void checkInsertable(VarPatternAdmin var) throws GraqlQueryException {
        if (!var.hasProperty(IsaProperty.class)) {
            throw GraqlQueryException.insertRelationWithoutType();
        }
    }

    @Override
    public Collection<PropertyExecutor> insert(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            Relationship relationship = executor.get(var).asRelationship();
            this.relationPlayers().forEach(relationPlayer -> this.addRoleplayer(executor, relationship, (RelationPlayer)relationPlayer));
        };
        return ImmutableSet.of((Object)PropertyExecutor.builder(method).requires(this.requiredVars(var)).build());
    }

    private void addRoleplayer(QueryOperationExecutor executor, Relationship relationship, RelationPlayer relationPlayer) {
        VarPatternAdmin roleVar = this.getRole(relationPlayer);
        Role role = executor.get(roleVar.var()).asRole();
        Thing roleplayer = executor.get(relationPlayer.getRolePlayer().var()).asThing();
        relationship.addRolePlayer(role, roleplayer);
    }

    private Set<Var> requiredVars(Var var) {
        Stream<Var> relationPlayers = this.relationPlayers().stream().flatMap(relationPlayer -> Stream.of(relationPlayer.getRolePlayer(), this.getRole((RelationPlayer)relationPlayer))).map(VarPatternAdmin::var);
        return (Set)Stream.concat(relationPlayers, Stream.of(var)).collect(CommonUtil.toImmutableSet());
    }

    private VarPatternAdmin getRole(RelationPlayer relationPlayer) {
        return (VarPatternAdmin)relationPlayer.getRole().orElseThrow(GraqlQueryException::insertRolePlayerWithoutRoleType);
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var typeVariable;
        boolean isReified = var.getProperties().filter(prop -> !RelationshipProperty.class.isInstance(prop)).filter(prop -> !IsaProperty.class.isInstance(prop)).findFirst().isPresent();
        Var relVar = isReified ? var.var().asUserDefined() : var.var();
        for (RelationPlayer rp : this.relationPlayers()) {
            VarPattern rolePattern = rp.getRole().orElse(null);
            VarPatternAdmin rolePlayer = rp.getRolePlayer();
            if (rolePattern != null) {
                Concept concept;
                Var roleVar = rolePattern.admin().var();
                IdPredicate roleId = ReasonerUtils.getUserDefinedIdPredicate(roleVar, vars, parent);
                if (roleId != null && (concept = parent.tx().getConcept((ConceptId)roleId.getPredicate())) != null) {
                    if (concept.isRole()) {
                        Label roleLabel = concept.asSchemaConcept().getLabel();
                        rolePattern = roleVar.label(roleLabel);
                    } else {
                        throw GraqlQueryException.nonRoleIdAssignedToRoleVariable((VarPatternAdmin)var);
                    }
                }
                relVar = relVar.rel(rolePattern, (VarPattern)rolePlayer);
                continue;
            }
            relVar = relVar.rel((VarPattern)rolePlayer);
        }
        IsaProperty isaProp = var.getProperty(IsaProperty.class).orElse(null);
        IdPredicate predicate = null;
        Var var2 = typeVariable = isaProp != null ? isaProp.type().var() : Graql.var();
        if (isaProp != null) {
            VarPatternAdmin isaVar = isaProp.type();
            Label label = isaVar.getTypeLabel().orElse(null);
            if (label != null) {
                predicate = new IdPredicate(typeVariable, label, parent);
            } else {
                typeVariable = isaVar.var();
                predicate = ReasonerUtils.getUserDefinedIdPredicate(typeVariable, vars, parent);
            }
        }
        relVar = relVar.isa((VarPattern)typeVariable.asUserDefined());
        return new RelationshipAtom((VarPattern)relVar.admin(), typeVariable, predicate, parent);
    }
}

