/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.AutoValue_SubProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.PropertyExecutor;
import ai.grakn.graql.internal.query.ConceptBuilder;
import ai.grakn.graql.internal.reasoner.atom.binary.type.SubAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public abstract class SubProperty
extends AbstractVarProperty
implements NamedProperty,
UniqueVarProperty {
    public static final String NAME = "sub";

    public static SubProperty of(VarPatternAdmin superType) {
        return new AutoValue_SubProperty(superType);
    }

    public abstract VarPatternAdmin superType();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getProperty() {
        return this.superType().getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.sub(this, start, this.superType().var()));
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.superType());
    }

    @Override
    public Stream<VarPatternAdmin> innerVarPatterns() {
        return Stream.of(this.superType());
    }

    @Override
    public Collection<PropertyExecutor> define(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            SchemaConcept superConcept = executor.get(this.superType().var()).asSchemaConcept();
            Optional<ConceptBuilder> builder = executor.tryBuilder(var);
            if (builder.isPresent()) {
                builder.get().sub(superConcept);
            } else {
                ConceptBuilder.setSuper(executor.get(var).asSchemaConcept(), superConcept);
            }
        };
        return ImmutableSet.of((Object)PropertyExecutor.builder(method).requires(this.superType().var()).produces(var).build());
    }

    @Override
    public Collection<PropertyExecutor> undefine(Var var) throws GraqlQueryException {
        PropertyExecutor.Method method = executor -> {
            SchemaConcept concept = executor.get(var).asSchemaConcept();
            SchemaConcept expectedSuperConcept = executor.get(this.superType().var()).asSchemaConcept();
            SchemaConcept actualSuperConcept = concept.sup();
            if (!concept.isDeleted() && expectedSuperConcept.equals(actualSuperConcept)) {
                concept.delete();
            }
        };
        return ImmutableSet.of((Object)PropertyExecutor.builder(method).requires(var, this.superType().var()).build());
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.var().asUserDefined();
        VarPatternAdmin typeVar = this.superType();
        Var typeVariable = typeVar.var().asUserDefined();
        IdPredicate predicate = ReasonerUtils.getIdPredicate(typeVariable, typeVar, vars, parent);
        VarPatternAdmin resVar = varName.sub((VarPattern)typeVariable).admin();
        return new SubAtom((VarPattern)resVar, typeVariable, predicate, parent);
    }
}

