/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.printer;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.util.ANSI;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.StringUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class GraqlPrinter
implements Printer<Function<StringBuilder, StringBuilder>> {
    private final AttributeType[] attributeTypes;
    private final boolean colorize;

    GraqlPrinter(boolean colorize, AttributeType ... attributeTypes) {
        this.colorize = colorize;
        this.attributeTypes = attributeTypes;
    }

    public String complete(Function<StringBuilder, StringBuilder> builder) {
        return builder.apply(new StringBuilder()).toString();
    }

    public Function<StringBuilder, StringBuilder> build(Concept concept) {
        return sb -> {
            if (concept.isAttribute()) {
                sb.append(this.colorKeyword("val ")).append(StringUtil.valueToString((Object)concept.asAttribute().getValue()));
            } else if (concept.isSchemaConcept()) {
                SchemaConcept ontoConcept = concept.asSchemaConcept();
                sb.append(this.colorKeyword("label ")).append(this.colorType(ontoConcept));
                SchemaConcept superConcept = ontoConcept.sup();
                if (superConcept != null) {
                    sb.append(this.colorKeyword(" sub ")).append(this.colorType(superConcept));
                }
            } else {
                sb.append(this.colorKeyword("id ")).append(StringConverter.idToString(concept.getId()));
            }
            if (concept.isRelationship()) {
                String relationString = concept.asRelationship().allRolePlayers().entrySet().stream().flatMap(entry -> {
                    Role role = (Role)entry.getKey();
                    Set things = (Set)entry.getValue();
                    return things.stream().map(instance -> Optional.of(this.colorType((SchemaConcept)role) + ": id " + StringConverter.idToString(instance.getId())));
                }).flatMap(CommonUtil::optionalToStream).collect(Collectors.joining(", "));
                sb.append(" (").append(relationString).append(")");
            }
            if (concept.isThing()) {
                Type type = concept.asThing().type();
                sb.append(this.colorKeyword(" isa ")).append(this.colorType((SchemaConcept)type));
            }
            if (concept.isRule()) {
                sb.append(this.colorKeyword(" when ")).append("{ ").append(concept.asRule().getWhen()).append(" }");
                sb.append(this.colorKeyword(" then ")).append("{ ").append(concept.asRule().getThen()).append(" }");
            }
            if (concept.isThing() && this.attributeTypes.length > 0) {
                concept.asThing().attributes(this.attributeTypes).forEach(resource -> {
                    String resourceType = this.colorType((SchemaConcept)resource.type());
                    String value = StringUtil.valueToString((Object)resource.getValue());
                    sb.append(this.colorKeyword(" has ")).append(resourceType).append(" ").append(value);
                });
            }
            return sb;
        };
    }

    public Function<StringBuilder, StringBuilder> build(boolean bool) {
        if (bool) {
            return sb -> sb.append(ANSI.color("True", "\u001b[32m"));
        }
        return sb -> sb.append(ANSI.color("False", "\u001b[31m"));
    }

    public Function<StringBuilder, StringBuilder> build(Optional<?> optional) {
        if (optional.isPresent()) {
            return (Function)this.build(optional.get());
        }
        return sb -> sb.append("Nothing");
    }

    public Function<StringBuilder, StringBuilder> build(Collection<?> collection) {
        return sb -> {
            sb.append("{");
            collection.stream().findFirst().ifPresent(item -> {
                StringBuilder cfr_ignored_0 = (StringBuilder)((Function)this.build(item)).apply(sb);
            });
            collection.stream().skip(1L).forEach(item -> {
                StringBuilder cfr_ignored_0 = (StringBuilder)((Function)this.build(item)).apply(sb.append(", "));
            });
            sb.append("}");
            return sb;
        };
    }

    public Function<StringBuilder, StringBuilder> build(Map<?, ?> map) {
        return this.build(map.entrySet());
    }

    public Function<StringBuilder, StringBuilder> build(Answer answer) {
        return sb -> {
            if (answer.isEmpty()) {
                sb.append("{}");
            } else {
                answer.forEach((name, concept) -> ((StringBuilder)this.build((Concept)concept).apply(sb.append(name).append(" "))).append("; "));
            }
            return sb;
        };
    }

    public Function<StringBuilder, StringBuilder> buildDefault(Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return ((Function)this.build(entry.getKey())).andThen(sb -> sb.append(": ")).andThen((Function)this.build(entry.getValue()));
        }
        return sb -> sb.append(Objects.toString(object));
    }

    private String colorKeyword(String keyword) {
        if (this.colorize) {
            return ANSI.color(keyword, "\u001b[34m");
        }
        return keyword;
    }

    private String colorType(SchemaConcept schemaConcept) {
        if (this.colorize) {
            return ANSI.color(StringConverter.typeLabelToString(schemaConcept.getLabel()), "\u001b[35m");
        }
        return StringConverter.typeLabelToString(schemaConcept.getLabel());
    }
}

