/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.QueryOperationExecutor;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ConceptBuilder {
    private final QueryOperationExecutor executor;
    private final Var var;
    private final Map<BuilderParam<?>, Object> preProvidedParams = new HashMap();
    private final Set<BuilderParam<?>> usedParams = new HashSet();
    private static final BuilderParam<Type> TYPE = BuilderParam.of("isa");
    private static final BuilderParam<SchemaConcept> SUPER_CONCEPT = BuilderParam.of("sub");
    private static final BuilderParam<Label> LABEL = BuilderParam.of("label");
    private static final BuilderParam<ConceptId> ID = BuilderParam.of("id");
    private static final BuilderParam<Object> VALUE = BuilderParam.of("val");
    private static final BuilderParam<AttributeType.DataType<?>> DATA_TYPE = BuilderParam.of("datatype");
    private static final BuilderParam<Pattern> WHEN = BuilderParam.of("when");
    private static final BuilderParam<Pattern> THEN = BuilderParam.of("then");
    private static final BuilderParam<Unit> IS_ROLE = BuilderParam.of("role");

    public ConceptBuilder isa(Type type) {
        return this.set(TYPE, type);
    }

    public ConceptBuilder sub(SchemaConcept superConcept) {
        return this.set(SUPER_CONCEPT, superConcept);
    }

    public ConceptBuilder isRole() {
        return this.set(IS_ROLE, Unit.INSTANCE);
    }

    public ConceptBuilder label(Label label) {
        return this.set(LABEL, label);
    }

    public ConceptBuilder id(ConceptId id) {
        return this.set(ID, id);
    }

    public ConceptBuilder value(Object value) {
        return this.set(VALUE, value);
    }

    public ConceptBuilder dataType(AttributeType.DataType<?> dataType) {
        return this.set(DATA_TYPE, dataType);
    }

    public ConceptBuilder when(Pattern when) {
        return this.set(WHEN, when);
    }

    public ConceptBuilder then(Pattern then) {
        return this.set(THEN, then);
    }

    static ConceptBuilder of(QueryOperationExecutor executor, Var var) {
        return new ConceptBuilder(executor, var);
    }

    Concept build() {
        Concept concept = this.tryGetConcept();
        if (concept != null) {
            return concept;
        }
        return this.tryPutConcept();
    }

    @Nullable
    private Concept tryGetConcept() {
        Concept concept = null;
        if (this.has(ID)) {
            concept = this.executor.tx().getConcept(this.use(ID));
            if (this.has(LABEL)) {
                concept.asSchemaConcept().setLabel(this.use(LABEL));
            }
        } else if (this.has(LABEL)) {
            concept = this.executor.tx().getSchemaConcept(this.use(LABEL));
        }
        if (concept != null) {
            if (this.has(SUPER_CONCEPT)) {
                SchemaConcept superConcept = this.use(SUPER_CONCEPT);
                ConceptBuilder.setSuper(concept.asSchemaConcept(), superConcept);
            }
            this.validate(concept);
        }
        return concept;
    }

    private Concept tryPutConcept() {
        SchemaConcept concept;
        this.usedParams.clear();
        if (this.has(IS_ROLE)) {
            this.use(IS_ROLE);
            Label label = this.use(LABEL);
            Role role = this.executor.tx().putRole(label);
            if (this.has(SUPER_CONCEPT)) {
                ConceptBuilder.setSuper((SchemaConcept)role, this.use(SUPER_CONCEPT));
            }
            concept = role;
        } else if (this.has(SUPER_CONCEPT)) {
            concept = this.putSchemaConcept();
        } else if (this.has(TYPE)) {
            concept = this.putInstance();
        } else {
            throw GraqlQueryException.insertUndefinedVariable((VarPatternAdmin)this.executor.printableRepresentation(this.var));
        }
        this.preProvidedParams.forEach((arg_0, arg_1) -> this.lambda$tryPutConcept$0((Concept)concept, arg_0, arg_1));
        return concept;
    }

    private ConceptBuilder(QueryOperationExecutor executor, Var var) {
        this.executor = executor;
        this.var = var;
    }

    private <T> T useOrDefault(BuilderParam<T> param, @Nullable T defaultValue) {
        this.usedParams.add(param);
        Object value = this.preProvidedParams.get(param);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            throw GraqlQueryException.insertNoExpectedProperty((String)param.name(), (VarPatternAdmin)this.executor.printableRepresentation(this.var));
        }
        return (T)value;
    }

    private <T> T use(BuilderParam<T> param) {
        return this.useOrDefault(param, null);
    }

    private boolean has(BuilderParam<?> param) {
        return this.preProvidedParams.containsKey(param);
    }

    private <T> ConceptBuilder set(BuilderParam<T> param, T value) {
        if (this.preProvidedParams.containsKey(param) && !this.preProvidedParams.get(param).equals(value)) {
            VarPatternAdmin varPattern = this.executor.printableRepresentation(this.var);
            Object otherValue = this.preProvidedParams.get(param);
            throw GraqlQueryException.insertMultipleProperties((VarPattern)varPattern, (String)param.name(), value, (Object)otherValue);
        }
        this.preProvidedParams.put(param, Preconditions.checkNotNull(value));
        return this;
    }

    private void validate(Concept concept) {
        this.validateParam(concept, TYPE, Thing.class, Thing::type);
        this.validateParam(concept, SUPER_CONCEPT, SchemaConcept.class, SchemaConcept::sup);
        this.validateParam(concept, LABEL, SchemaConcept.class, SchemaConcept::getLabel);
        this.validateParam(concept, ID, Concept.class, Concept::getId);
        this.validateParam(concept, VALUE, Attribute.class, Attribute::getValue);
        this.validateParam(concept, DATA_TYPE, AttributeType.class, AttributeType::getDataType);
        this.validateParam(concept, WHEN, Rule.class, Rule::getWhen);
        this.validateParam(concept, THEN, Rule.class, Rule::getThen);
    }

    private <S extends Concept, T> void validateParam(Concept concept, BuilderParam<T> param, Class<S> conceptType, Function<S, T> getter) {
        if (this.has(param)) {
            T value = this.use(param);
            boolean isInstance = conceptType.isInstance(concept);
            if (!isInstance || !Objects.equals(getter.apply(conceptType.cast(concept)), value)) {
                throw GraqlQueryException.insertPropertyOnExistingConcept((String)param.name(), value, (Concept)concept);
            }
        }
    }

    private Thing putInstance() {
        Type type = this.use(TYPE);
        if (type.isEntityType()) {
            return type.asEntityType().addEntity();
        }
        if (type.isRelationshipType()) {
            return type.asRelationshipType().addRelationship();
        }
        if (type.isAttributeType()) {
            return type.asAttributeType().putAttribute(this.use(VALUE));
        }
        if (type.getLabel().equals(Schema.MetaSchema.THING.getLabel())) {
            throw GraqlQueryException.createInstanceOfMetaConcept((Var)this.var, (Type)type);
        }
        throw CommonUtil.unreachableStatement((String)("Can't recognize type " + type));
    }

    private SchemaConcept putSchemaConcept() {
        EntityType concept;
        SchemaConcept superConcept = this.use(SUPER_CONCEPT);
        Label label = this.use(LABEL);
        if (superConcept.isEntityType()) {
            concept = this.executor.tx().putEntityType(label);
        } else if (superConcept.isRelationshipType()) {
            concept = this.executor.tx().putRelationshipType(label);
        } else if (superConcept.isRole()) {
            concept = this.executor.tx().putRole(label);
        } else if (superConcept.isAttributeType()) {
            AttributeType attributeType = superConcept.asAttributeType();
            AttributeType.DataType dataType = this.useOrDefault(DATA_TYPE, attributeType.getDataType());
            concept = this.executor.tx().putAttributeType(label, dataType);
        } else if (superConcept.isRule()) {
            concept = this.executor.tx().putRule(label, this.use(WHEN), this.use(THEN));
        } else {
            throw GraqlQueryException.insertMetaType((Label)label, (SchemaConcept)superConcept);
        }
        ConceptBuilder.setSuper((SchemaConcept)concept, superConcept);
        return concept;
    }

    public static void setSuper(SchemaConcept subConcept, SchemaConcept superConcept) {
        if (superConcept.isEntityType()) {
            subConcept.asEntityType().sup(superConcept.asEntityType());
        } else if (superConcept.isRelationshipType()) {
            subConcept.asRelationshipType().sup(superConcept.asRelationshipType());
        } else if (superConcept.isRole()) {
            subConcept.asRole().sup(superConcept.asRole());
        } else if (superConcept.isAttributeType()) {
            subConcept.asAttributeType().sup(superConcept.asAttributeType());
        } else if (superConcept.isRule()) {
            subConcept.asRule().sup(superConcept.asRule());
        } else {
            throw GraqlQueryException.insertMetaType((Label)subConcept.getLabel(), (SchemaConcept)superConcept);
        }
    }

    public String toString() {
        return "ConceptBuilder{var=" + this.var + ", preProvidedParams=" + this.preProvidedParams + ", usedParams=" + this.usedParams + '}';
    }

    private /* synthetic */ void lambda$tryPutConcept$0(Concept concept, BuilderParam param, Object value) {
        if (!this.usedParams.contains(param)) {
            throw GraqlQueryException.insertUnexpectedProperty((String)param.name(), (Object)value, (Concept)concept);
        }
    }

    private static final class Unit {
        private static Unit INSTANCE = new Unit();

        private Unit() {
        }

        public String toString() {
            return "";
        }
    }

    private static final class BuilderParam<T> {
        private final String name;

        private BuilderParam(String name) {
            this.name = name;
        }

        String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static <T> BuilderParam<T> of(String name) {
            return new BuilderParam<T>(name);
        }
    }
}

