/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknTx;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.GraqlConverter;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.Match;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.InsertQueryAdmin;
import ai.grakn.graql.admin.MatchAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.Queries;
import ai.grakn.graql.internal.query.QueryOperationExecutor;
import ai.grakn.util.CommonUtil;
import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class InsertQueryImpl
implements InsertQueryAdmin {
    private final Optional<MatchAdmin> match;
    private final Optional<GraknTx> tx;
    private final ImmutableCollection<VarPatternAdmin> originalVars;
    private final ImmutableCollection<VarPatternAdmin> vars;

    InsertQueryImpl(ImmutableCollection<VarPatternAdmin> vars, Optional<MatchAdmin> match, Optional<GraknTx> tx) {
        assert (!match.isPresent() || !tx.isPresent());
        if (vars.isEmpty()) {
            throw GraqlQueryException.noPatterns();
        }
        this.match = match;
        this.tx = tx;
        this.originalVars = vars;
        this.vars = (ImmutableCollection)vars.stream().flatMap(v -> v.innerVarPatterns().stream()).collect(CommonUtil.toImmutableList());
        for (VarPatternAdmin var : this.vars) {
            var.getProperties().forEach(property -> ((VarPropertyInternal)property).checkInsertable(var));
        }
    }

    public InsertQuery withTx(GraknTx tx) {
        return (InsertQuery)this.match.map(m -> Queries.insert(this.vars, m.withTx(tx).admin())).orElseGet(() -> new InsertQueryImpl(this.vars, Optional.empty(), Optional.of(tx)));
    }

    public List<Answer> execute() {
        return this.stream().collect(Collectors.toList());
    }

    public <T> Stream<T> results(GraqlConverter<?, T> converter) {
        return this.stream().map(arg_0 -> converter.convert(arg_0));
    }

    public boolean isReadOnly() {
        return false;
    }

    public Stream<Answer> stream() {
        GraknTx theGraph = this.getTx().orElseThrow(GraqlQueryException::noTx);
        return this.match.map(query -> query.stream().map(answer -> QueryOperationExecutor.insertAll(this.vars, theGraph, answer))).orElseGet(() -> Stream.of(QueryOperationExecutor.insertAll(this.vars, theGraph)));
    }

    public InsertQueryAdmin admin() {
        return this;
    }

    public Optional<? extends Match> match() {
        return this.match;
    }

    public Set<SchemaConcept> getSchemaConcepts() {
        GraknTx theGraph = this.getTx().orElseThrow(GraqlQueryException::noTx);
        Set<SchemaConcept> types = this.vars.stream().flatMap(v -> v.innerVarPatterns().stream()).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).map(arg_0 -> ((GraknTx)theGraph).getSchemaConcept(arg_0)).collect(Collectors.toSet());
        this.match.ifPresent(mq -> types.addAll(mq.getSchemaConcepts()));
        return types;
    }

    public Collection<VarPatternAdmin> varPatterns() {
        return this.originalVars;
    }

    public Optional<GraknTx> getTx() {
        return this.match.map(MatchAdmin::tx).orElse(this.tx);
    }

    public String toString() {
        String mq = this.match.map(match -> match + "\n").orElse("");
        return mq + "insert " + this.originalVars.stream().map(v -> v + ";").collect(Collectors.joining("\n")).trim();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertQueryImpl maps = (InsertQueryImpl)o;
        if (!this.match.equals(maps.match)) {
            return false;
        }
        if (!this.tx.equals(maps.tx)) {
            return false;
        }
        return this.originalVars.equals(maps.originalVars);
    }

    public int hashCode() {
        int result = this.match.hashCode();
        result = 31 * result + this.tx.hashCode();
        result = 31 * result + this.originalVars.hashCode();
        return result;
    }
}

