/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.concept.Concept;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.explanation.Explanation;
import ai.grakn.graql.internal.reasoner.explanation.JoinExplanation;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryAnswer
implements Answer {
    private final ImmutableMap<Var, Concept> map;
    private final AnswerExplanation explanation;

    public QueryAnswer() {
        this.map = ImmutableMap.of();
        this.explanation = new Explanation();
    }

    public QueryAnswer(Answer a) {
        this.map = ImmutableMap.builder().putAll((Iterable)a.entrySet()).build();
        this.explanation = a.getExplanation();
    }

    public QueryAnswer(Collection<Map.Entry<Var, Concept>> mappings, AnswerExplanation exp) {
        this.map = ImmutableMap.builder().putAll(mappings).build();
        this.explanation = exp;
    }

    public QueryAnswer(Map<Var, Concept> m, AnswerExplanation exp) {
        this.map = ImmutableMap.copyOf(m);
        this.explanation = exp;
    }

    public QueryAnswer(Map<Var, Concept> m) {
        this(m, (AnswerExplanation)new Explanation());
    }

    public String toString() {
        return this.entrySet().stream().sorted(Comparator.comparing(e -> ((Var)e.getKey()).getValue())).map(e -> "[" + e.getKey() + "/" + ((Concept)e.getValue()).getId() + "]").collect(Collectors.joining());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Answer)) {
            return false;
        }
        QueryAnswer a2 = (QueryAnswer)obj;
        return this.map.equals(a2.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public ImmutableMap<Var, Concept> map() {
        return this.map;
    }

    public Set<Var> vars() {
        return this.map.keySet();
    }

    public Collection<Concept> concepts() {
        return this.map.values();
    }

    public Set<Map.Entry<Var, Concept>> entrySet() {
        return this.map.entrySet();
    }

    public Concept get(String var) {
        return this.get(Graql.var(var));
    }

    public Concept get(Var var) {
        Concept concept = (Concept)this.map.get((Object)var);
        if (concept == null) {
            throw GraqlQueryException.varNotInQuery((Var)var);
        }
        return concept;
    }

    public boolean containsVar(Var var) {
        return this.map.containsKey((Object)var);
    }

    public boolean containsAll(Answer ans) {
        return this.map.entrySet().containsAll((Collection)ans.entrySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public void forEach(BiConsumer<? super Var, ? super Concept> consumer) {
        this.map.forEach(consumer);
    }

    public Answer merge(Answer a2, boolean mergeExplanation) {
        if (a2.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return a2;
        }
        Sets.SetView varUnion = Sets.union(this.vars(), (Set)a2.vars());
        Sets.SetView varIntersection = Sets.intersection(this.vars(), (Set)a2.vars());
        Map<Var, Concept> entryMap = Sets.union(this.entrySet(), (Set)a2.entrySet()).stream().filter(arg_0 -> QueryAnswer.lambda$merge$2((Set)varIntersection, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        varIntersection.forEach((? super T var) -> {
            Concept otherConcept;
            Concept concept = this.get((Var)var);
            if (concept.equals(otherConcept = a2.get(var))) {
                entryMap.put((Var)var, concept);
            } else if (concept.isSchemaConcept() && otherConcept.isSchemaConcept() && !ReasonerUtils.areDisjointTypes(concept.asSchemaConcept(), otherConcept.asSchemaConcept())) {
                entryMap.put((Var)var, (Concept)Iterables.getOnlyElement(ReasonerUtils.topOrMeta(Sets.newHashSet((Object[])new SchemaConcept[]{concept.asSchemaConcept(), otherConcept.asSchemaConcept()}))));
            }
        });
        if (!entryMap.keySet().equals(varUnion)) {
            return new QueryAnswer();
        }
        return new QueryAnswer(entryMap, mergeExplanation ? this.mergeExplanation(a2) : this.getExplanation());
    }

    public AnswerExplanation mergeExplanation(Answer toMerge) {
        HashSet<Answer> partialAnswers = new HashSet<Answer>();
        if (this.getExplanation().isJoinExplanation()) {
            this.getExplanation().getAnswers().forEach(partialAnswers::add);
        } else {
            partialAnswers.add(this);
        }
        if (toMerge.getExplanation().isJoinExplanation()) {
            toMerge.getExplanation().getAnswers().forEach(partialAnswers::add);
        } else {
            partialAnswers.add(toMerge);
        }
        return new JoinExplanation(partialAnswers);
    }

    public Answer merge(Answer a2) {
        return this.merge(a2, false);
    }

    public Answer explain(AnswerExplanation exp) {
        return new QueryAnswer(this.entrySet(), exp.childOf((Answer)this));
    }

    public Answer project(Set<Var> vars) {
        return new QueryAnswer(this.entrySet().stream().filter(e -> vars.contains(e.getKey())).collect(Collectors.toSet()), this.getExplanation());
    }

    public Answer unify(Unifier unifier) {
        if (unifier.isEmpty()) {
            return this;
        }
        HashMap<Var, Concept> unified = new HashMap<Var, Concept>();
        for (Map.Entry<Var, Concept> e : this.entrySet()) {
            Var var = e.getKey();
            Concept con = e.getValue();
            Collection uvars = unifier.get(var);
            if (uvars.isEmpty() && !unifier.values().contains(var)) {
                Concept put = unified.put(var, con);
                if (put == null || put.equals(con)) continue;
                return new QueryAnswer();
            }
            for (Var uv : uvars) {
                Concept put = unified.put(uv, con);
                if (put == null || put.equals(con)) continue;
                return new QueryAnswer();
            }
        }
        return new QueryAnswer(unified, this.getExplanation());
    }

    public Stream<Answer> unify(MultiUnifier multiUnifier) {
        return multiUnifier.stream().map(this::unify);
    }

    public Stream<Answer> expandHierarchies(Set<Var> toExpand) {
        if (toExpand.isEmpty()) {
            return Stream.of(this);
        }
        List entryOptions = this.entrySet().stream().map(e -> {
            Concept c;
            Var var = (Var)e.getKey();
            if (toExpand.contains(var) && (c = this.get(var)).isSchemaConcept()) {
                return ReasonerUtils.upstreamHierarchy(c.asSchemaConcept()).stream().map(r -> new Pair<Var, SchemaConcept>(var, (SchemaConcept)r)).collect(Collectors.toSet());
            }
            return Collections.singleton(new Pair<Var, Concept>(var, this.get(var)));
        }).collect(Collectors.toList());
        return Sets.cartesianProduct(entryOptions).stream().map(mappingList -> new QueryAnswer(mappingList.stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue)), this.getExplanation())).map(ans -> ans.explain(this.getExplanation()));
    }

    public AnswerExplanation getExplanation() {
        return this.explanation;
    }

    public Set<Answer> getExplicitPath() {
        return this.getPartialAnswers().stream().filter(ans -> ans.getExplanation().isLookupExplanation()).collect(Collectors.toSet());
    }

    public Set<Answer> getPartialAnswers() {
        HashSet answers = Sets.newHashSet((Object[])new Answer[]{this});
        this.getExplanation().getAnswers().forEach(ans -> ans.getPartialAnswers().forEach(answers::add));
        return answers;
    }

    public Set<AnswerExplanation> getExplanations() {
        HashSet explanations = Sets.newHashSet((Object[])new AnswerExplanation[]{this.getExplanation()});
        this.getExplanation().getAnswers().forEach(ans -> ans.getExplanations().forEach(explanations::add));
        return explanations;
    }

    public Set<Atomic> toPredicates(ReasonerQuery parent) {
        Set varNames = parent.getVarNames();
        return this.entrySet().stream().filter(e -> varNames.contains(e.getKey())).map(e -> new IdPredicate((Var)e.getKey(), (Concept)e.getValue(), parent)).collect(Collectors.toSet());
    }

    private static /* synthetic */ boolean lambda$merge$2(Set varIntersection, Map.Entry e) {
        return !varIntersection.contains(e.getKey());
    }
}

