/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknTx;
import ai.grakn.graql.ComputeQueryBuilder;
import ai.grakn.graql.DefineQuery;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.Match;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.QueryParser;
import ai.grakn.graql.UndefineQuery;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.parser.QueryParserImpl;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.query.DefineQueryImpl;
import ai.grakn.graql.internal.query.InsertQueryImpl;
import ai.grakn.graql.internal.query.UndefineQueryImpl;
import ai.grakn.graql.internal.query.analytics.ComputeQueryBuilderImpl;
import ai.grakn.graql.internal.query.match.MatchBase;
import ai.grakn.graql.internal.util.AdminConverter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public class QueryBuilderImpl
implements QueryBuilder {
    private final Optional<GraknTx> tx;
    private final QueryParser queryParser = QueryParserImpl.create(this);
    private boolean infer = true;
    private boolean materialise = false;

    public QueryBuilderImpl() {
        this.tx = Optional.empty();
    }

    public QueryBuilderImpl(GraknTx tx) {
        this.tx = Optional.of(tx);
    }

    public QueryBuilder infer(boolean infer) {
        this.infer = infer;
        return this;
    }

    public QueryBuilder materialise(boolean materialise) {
        this.materialise = materialise;
        return this;
    }

    public Match match(Pattern ... patterns) {
        return this.match(Arrays.asList(patterns));
    }

    public Match match(Collection<? extends Pattern> patterns) {
        Conjunction conjunction = Patterns.conjunction(Sets.newHashSet(AdminConverter.getPatternAdmins(patterns)));
        MatchBase base = new MatchBase(conjunction);
        MatchBase match = this.infer ? base.infer(this.materialise).admin() : base;
        return this.tx.map(arg_0 -> ((Match)match).withTx(arg_0)).orElse((Match)match);
    }

    public InsertQuery insert(VarPattern ... vars) {
        return this.insert(Arrays.asList(vars));
    }

    public InsertQuery insert(Collection<? extends VarPattern> vars) {
        ImmutableList varAdmins = ImmutableList.copyOf(AdminConverter.getVarAdmins(vars));
        return new InsertQueryImpl((ImmutableCollection<VarPatternAdmin>)varAdmins, Optional.empty(), this.tx);
    }

    public DefineQuery define(VarPattern ... varPatterns) {
        return this.define(Arrays.asList(varPatterns));
    }

    public DefineQuery define(Collection<? extends VarPattern> varPatterns) {
        ImmutableList admins = ImmutableList.copyOf(AdminConverter.getVarAdmins(varPatterns));
        return DefineQueryImpl.of((ImmutableList<VarPatternAdmin>)admins, this.tx.orElse(null));
    }

    public UndefineQuery undefine(VarPattern ... varPatterns) {
        return this.undefine(Arrays.asList(varPatterns));
    }

    public UndefineQuery undefine(Collection<? extends VarPattern> varPatterns) {
        ImmutableList admins = ImmutableList.copyOf(AdminConverter.getVarAdmins(varPatterns));
        return UndefineQueryImpl.of((ImmutableList<VarPatternAdmin>)admins, this.tx.orElse(null));
    }

    public ComputeQueryBuilder compute() {
        return new ComputeQueryBuilderImpl(this.tx);
    }

    public QueryParser parser() {
        return this.queryParser;
    }

    public <T extends Query<?>> T parse(String queryString) {
        return (T)this.queryParser.parseQuery(queryString);
    }
}

