/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.graql.Aggregate;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import ai.grakn.graql.internal.query.aggregate.Aggregates;
import ai.grakn.graql.internal.query.aggregate.CountAggregate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MeanAggregate
extends AbstractAggregate<Answer, Optional<Double>> {
    private final Var varName;
    private final CountAggregate countAggregate;
    private final Aggregate<Answer, Number> sumAggregate;

    MeanAggregate(Var varName) {
        this.varName = varName;
        this.countAggregate = new CountAggregate();
        this.sumAggregate = Aggregates.sum(varName);
    }

    public Optional<Double> apply(Stream<? extends Answer> stream) {
        List list = stream.collect(Collectors.toList());
        long count = (Long)this.countAggregate.apply(list.stream());
        if (count == 0L) {
            return Optional.empty();
        }
        Number sum = (Number)this.sumAggregate.apply(list.stream());
        return Optional.of(sum.doubleValue() / (double)count);
    }

    public String toString() {
        return "mean " + this.varName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeanAggregate that = (MeanAggregate)o;
        return this.varName.equals((Object)that.varName);
    }

    public int hashCode() {
        return this.varName.hashCode();
    }
}

