/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.concept.Label;
import ai.grakn.graql.ComputeQuery;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;

abstract class AbstractCentralityQuery<V extends ComputeQuery<Map<Long, Set<String>>>>
extends AbstractComputeQuery<Map<Long, Set<String>>, V> {
    private boolean ofTypeLabelsSet = false;
    Set<Label> ofLabels = new HashSet<Label>();

    AbstractCentralityQuery() {
    }

    @Override
    void initSubGraph() {
        this.includeAttribute = true;
    }

    public V of(String ... ofTypeLabels) {
        return this.of(Arrays.stream(ofTypeLabels).map(Label::of).collect(Collectors.toSet()));
    }

    public V of(Collection<Label> ofLabels) {
        if (!ofLabels.isEmpty()) {
            this.ofTypeLabelsSet = true;
            this.ofLabels = Sets.newHashSet(ofLabels);
        }
        return (V)this;
    }

    abstract CentralityMeasure getMethod();

    @Override
    String graqlString() {
        String string = "centrality";
        if (this.ofTypeLabelsSet) {
            string = string + " of " + this.ofLabels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(", "));
        }
        string = string + this.subtypeString() + " using " + this.getMethod().getName();
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractCentralityQuery that = (AbstractCentralityQuery)o;
        return this.ofTypeLabelsSet == that.ofTypeLabelsSet && this.ofLabels.equals(that.ofLabels) && this.getMethod() == that.getMethod();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ofTypeLabelsSet ? 1 : 0);
        result = 31 * result + this.ofLabels.hashCode();
        result = 31 * result + this.getMethod().hashCode();
        return result;
    }

    static enum CentralityMeasure {
        DEGREE("degree"),
        K_CORE("k-core");

        private final String name;

        private CentralityMeasure(String name) {
            this.name = name;
        }

        @CheckReturnValue
        public String getName() {
            return this.name;
        }
    }
}

