/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknComputer;
import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.ComputeQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.GraqlConverter;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Printer;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.kb.admin.GraknAdmin;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractComputeQuery<T, V extends ComputeQuery<T>>
implements ComputeQuery<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(ComputeQuery.class);
    Optional<GraknTx> tx = Optional.empty();
    private GraknComputer graknComputer = null;
    boolean includeAttribute = false;
    Set<Label> subLabels = new HashSet<Label>();
    Set<Type> subTypes = new HashSet<Type>();

    AbstractComputeQuery() {
    }

    public V withTx(GraknTx tx) {
        this.tx = Optional.of(tx);
        return (V)this;
    }

    public V in(String ... subTypeLabels) {
        this.subLabels = Arrays.stream(subTypeLabels).map(Label::of).collect(Collectors.toSet());
        return (V)this;
    }

    public V in(Collection<Label> subLabels) {
        this.subLabels = Sets.newHashSet(subLabels);
        return (V)this;
    }

    public ComputeQuery<T> includeAttribute() {
        this.includeAttribute = true;
        return this;
    }

    public void kill() {
        if (this.graknComputer != null) {
            this.graknComputer.killJobs();
        }
    }

    public Stream<String> resultsString(Printer printer) {
        Object computeResult = this.execute();
        if (computeResult instanceof Map) {
            if (((Map)computeResult).isEmpty()) {
                return Stream.of("There are no instances of the selected type(s).");
            }
            if (((Map)computeResult).values().iterator().next() instanceof Set) {
                Map map = (Map)computeResult;
                return map.entrySet().stream().map(entry -> {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object s : (Iterable)entry.getValue()) {
                        stringBuilder.append(entry.getKey()).append("\t").append(s).append("\n");
                    }
                    return stringBuilder.toString();
                });
            }
        }
        return Stream.of(printer.graqlString(computeResult));
    }

    public <S> Stream<S> results(GraqlConverter<?, S> converter) {
        return Stream.of(converter.convert(this.execute()));
    }

    void initSubGraph() {
        if (this.isStatisticsQuery()) {
            this.includeAttribute = true;
        }
    }

    void getAllSubTypes() {
        GraknTx graknTx = this.tx.get();
        if (this.subLabels.isEmpty()) {
            if (this.includeAttribute) {
                graknTx.admin().getMetaConcept().subs().forEach(this.subTypes::add);
            } else {
                graknTx.admin().getMetaEntityType().subs().forEach(this.subTypes::add);
                graknTx.admin().getMetaRelationType().subs().filter(relationshipType -> relationshipType.isImplicit() == false).forEach(this.subTypes::add);
            }
        } else {
            this.subTypes = this.subLabels.stream().map(label -> {
                SchemaConcept type = graknTx.getSchemaConcept(label);
                if (type == null) {
                    throw GraqlQueryException.labelNotFound((Label)label);
                }
                if (!type.isType()) {
                    throw GraqlQueryException.cannotGetInstancesOfNonType((Label)type.getLabel());
                }
                if (!this.includeAttribute && (type.isAttributeType() || type.isImplicit().booleanValue())) {
                    this.includeAttribute = true;
                }
                return type.asType();
            }).collect(Collectors.toSet());
            this.subTypes = this.includeAttribute ? this.subTypes.stream().flatMap(Type::subs).collect(Collectors.toSet()) : this.subTypes.stream().flatMap(Type::subs).filter(relationshipType -> relationshipType.isImplicit() == false).collect(Collectors.toSet());
        }
        this.subLabels = this.subTypes.stream().map(SchemaConcept::getLabel).collect(Collectors.toSet());
    }

    GraknComputer getGraphComputer() {
        if (this.graknComputer == null) {
            if (this.tx.isPresent()) {
                this.graknComputer = this.tx.get().session().getGraphComputer();
            } else {
                throw new IllegalStateException("Transaction has not been provided. Cannot initialise graph computer");
            }
        }
        return this.graknComputer;
    }

    boolean selectedTypesHaveInstance() {
        if (this.subLabels.isEmpty()) {
            LOGGER.info("No types found while looking for instances");
            return false;
        }
        List checkSubtypes = this.subLabels.stream().map(type -> Graql.var("x").isa(Graql.label(type))).collect(Collectors.toList());
        return this.tx.get().graql().infer(false).match(new Pattern[]{Graql.or(checkSubtypes)}).iterator().hasNext();
    }

    boolean verticesExistInSubgraph(ConceptId ... ids) {
        for (ConceptId id : ids) {
            Thing thing = (Thing)this.tx.get().getConcept(id);
            if (thing != null && this.subLabels.contains(thing.type().getLabel())) continue;
            return false;
        }
        return true;
    }

    abstract String graqlString();

    final String subtypeString() {
        return this.subLabels.isEmpty() ? ";" : " in " + this.subLabels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(", ")) + ";";
    }

    public String toString() {
        return "compute " + this.graqlString();
    }

    Set<LabelId> getRolePlayerLabelIds() {
        return this.subTypes.stream().filter(Concept::isRelationshipType).map(Concept::asRelationshipType).filter(SchemaConcept::isImplicit).flatMap(RelationshipType::relates).flatMap(Role::playedByTypes).map(type -> this.tx.get().admin().convertToId(type.getLabel())).filter(LabelId::isValid).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractComputeQuery that = (AbstractComputeQuery)o;
        return this.tx.equals(that.tx) && this.includeAttribute == that.includeAttribute && this.subLabels.equals(that.subLabels);
    }

    public int hashCode() {
        int result = this.tx.hashCode();
        result = 31 * result + Boolean.hashCode(this.includeAttribute);
        result = 31 * result + this.subLabels.hashCode();
        return result;
    }

    Set<LabelId> convertLabelsToIds(Set<Label> labelSet) {
        return labelSet.stream().map(arg_0 -> ((GraknAdmin)this.tx.get().admin()).convertToId(arg_0)).filter(LabelId::isValid).collect(Collectors.toSet());
    }

    static Set<Label> getHasResourceRelationLabels(Set<Type> subTypes) {
        return subTypes.stream().filter(Concept::isAttributeType).map(resourceType -> Schema.ImplicitType.HAS.getLabel(resourceType.getLabel())).collect(Collectors.toSet());
    }
}

