/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.LabelId;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.analytics.ClusterQuery;
import ai.grakn.graql.internal.analytics.ClusterMemberMapReduce;
import ai.grakn.graql.internal.analytics.ClusterSizeMapReduce;
import ai.grakn.graql.internal.analytics.ConnectedComponentVertexProgram;
import ai.grakn.graql.internal.analytics.ConnectedComponentsVertexProgram;
import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class ClusterQueryImpl<T>
extends AbstractComputeQuery<T, ClusterQuery<T>>
implements ClusterQuery<T> {
    private boolean members = false;
    private boolean anySize = true;
    private Optional<ConceptId> sourceId = Optional.empty();
    private long clusterSize = -1L;

    ClusterQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public T execute() {
        GraknVertexProgram vertexProgram;
        LOGGER.info("ConnectedComponentsVertexProgram is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        this.getAllSubTypes();
        if (!this.selectedTypesHaveInstance()) {
            LOGGER.info("Selected types don't have instances");
            return (T)Collections.emptyMap();
        }
        Set<LabelId> subLabelIds = this.convertLabelsToIds(this.subLabels);
        if (this.sourceId.isPresent()) {
            ConceptId conceptId = this.sourceId.get();
            if (!this.verticesExistInSubgraph(conceptId)) {
                throw GraqlQueryException.instanceDoesNotExist();
            }
            vertexProgram = new ConnectedComponentVertexProgram(conceptId);
        } else {
            vertexProgram = new ConnectedComponentsVertexProgram();
        }
        GraknMapReduce mapReduce = this.members ? (this.anySize ? new ClusterMemberMapReduce("connectedComponentVertexProgram.clusterLabel") : new ClusterMemberMapReduce("connectedComponentVertexProgram.clusterLabel", this.clusterSize)) : (this.anySize ? new ClusterSizeMapReduce("connectedComponentVertexProgram.clusterLabel") : new ClusterSizeMapReduce("connectedComponentVertexProgram.clusterLabel", this.clusterSize));
        Memory memory = this.getGraphComputer().compute((VertexProgram)vertexProgram, (MapReduce)mapReduce, subLabelIds).memory();
        LOGGER.info("ConnectedComponentsVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return (T)memory.get(this.members ? ClusterMemberMapReduce.class.getName() : ClusterSizeMapReduce.class.getName());
    }

    @Override
    public ClusterQuery<T> includeAttribute() {
        return (ClusterQuery)super.includeAttribute();
    }

    public ClusterQuery<Map<String, Set<String>>> members() {
        this.members = true;
        return this;
    }

    public ClusterQuery<T> of(ConceptId conceptId) {
        this.sourceId = Optional.ofNullable(conceptId);
        return this;
    }

    public ClusterQuery<T> clusterSize(long clusterSize) {
        this.anySize = false;
        this.clusterSize = clusterSize;
        return this;
    }

    @Override
    String graqlString() {
        String string = "cluster" + this.subtypeString();
        if (this.sourceId.isPresent()) {
            string = string + " of " + this.sourceId.get().getValue() + ";";
        }
        if (this.members) {
            string = string + " members;";
        }
        if (!this.anySize) {
            string = string + " size " + this.clusterSize + ";";
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterQueryImpl that = (ClusterQueryImpl)o;
        return this.sourceId.equals(that.sourceId) && this.members == that.members && this.anySize == that.anySize && this.clusterSize == that.clusterSize;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sourceId.hashCode();
        result = 31 * result + (this.members ? 1 : 0);
        result = 31 * result + (this.anySize ? 1 : 0);
        result = 31 * result + (int)(this.clusterSize ^ this.clusterSize >>> 32);
        return result;
    }
}

