/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.analytics.CorenessQuery;
import ai.grakn.graql.internal.analytics.CorenessVertexProgram;
import ai.grakn.graql.internal.analytics.DegreeDistributionMapReduce;
import ai.grakn.graql.internal.analytics.NoResultException;
import ai.grakn.graql.internal.query.analytics.AbstractCentralityQuery;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class CorenessQueryImpl
extends AbstractCentralityQuery<CorenessQuery>
implements CorenessQuery {
    private long k = 2L;

    CorenessQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Map<Long, Set<String>> execute() {
        ComputerResult result;
        LOGGER.info("Coreness query started");
        long startTime = System.currentTimeMillis();
        if (this.k < 2L) {
            throw GraqlQueryException.kValueSmallerThanTwo();
        }
        this.initSubGraph();
        this.getAllSubTypes();
        if (this.ofLabels.isEmpty()) {
            this.ofLabels.addAll(this.subLabels);
        } else {
            this.ofLabels = this.ofLabels.stream().flatMap(typeLabel -> {
                Type type = (Type)((GraknTx)this.tx.get()).getSchemaConcept(typeLabel);
                if (type == null) {
                    throw GraqlQueryException.labelNotFound((Label)typeLabel);
                }
                if (type.isRelationshipType()) {
                    throw GraqlQueryException.kCoreOnRelationshipType((Label)typeLabel);
                }
                return type.subs();
            }).map(SchemaConcept::getLabel).collect(Collectors.toSet());
            this.subLabels.addAll(this.ofLabels);
        }
        if (!this.selectedTypesHaveInstance()) {
            LOGGER.info("Coreness query finished in " + (System.currentTimeMillis() - startTime) + " ms");
            return Collections.emptyMap();
        }
        Set<LabelId> subLabelIds = this.convertLabelsToIds(this.subLabels);
        Set<LabelId> ofLabelIds = this.convertLabelsToIds(this.ofLabels);
        try {
            result = this.getGraphComputer().compute((VertexProgram)new CorenessVertexProgram(this.k), (MapReduce)new DegreeDistributionMapReduce(ofLabelIds, "corenessVertexProgram.coreness"), subLabelIds);
        }
        catch (NoResultException e) {
            LOGGER.info("Coreness query finished in " + (System.currentTimeMillis() - startTime) + " ms");
            return Collections.emptyMap();
        }
        LOGGER.info("Coreness query finished in " + (System.currentTimeMillis() - startTime) + " ms");
        return (Map)result.memory().get(DegreeDistributionMapReduce.class.getName());
    }

    public CorenessQuery minK(long k) {
        this.k = k;
        return this;
    }

    @Override
    AbstractCentralityQuery.CentralityMeasure getMethod() {
        return AbstractCentralityQuery.CentralityMeasure.K_CORE;
    }

    @Override
    String graqlString() {
        return super.graqlString() + " where k = " + this.k + ";";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CorenessQueryImpl that = (CorenessQueryImpl)o;
        return this.k == that.k;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.k);
        return result;
    }
}

