/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.CountQuery;
import ai.grakn.graql.internal.analytics.CountMapReduceWithAttribute;
import ai.grakn.graql.internal.analytics.CountVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class CountQueryImpl
extends AbstractComputeQuery<Long, CountQuery>
implements CountQuery {
    CountQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Long execute() {
        LOGGER.info("Count query started");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        this.getAllSubTypes();
        if (!this.selectedTypesHaveInstance()) {
            LOGGER.debug("Count = 0");
            LOGGER.info("Count query finished in " + (System.currentTimeMillis() - startTime) + " ms");
            return 0L;
        }
        Set<LabelId> typeLabelIds = this.convertLabelsToIds(this.subLabels);
        Set<LabelId> rolePlayerLabelIds = this.getRolePlayerLabelIds();
        rolePlayerLabelIds.addAll(typeLabelIds);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new CountVertexProgram(), (MapReduce)new CountMapReduceWithAttribute(), rolePlayerLabelIds, Boolean.valueOf(false));
        Map count = (Map)result.memory().get(CountMapReduceWithAttribute.class.getName());
        long finalCount = count.keySet().stream().filter(id -> typeLabelIds.contains(LabelId.of((Integer)id))).mapToLong(count::get).sum();
        if (count.containsKey(-10)) {
            finalCount += ((Long)count.get(-10)).longValue();
        }
        LOGGER.debug("Count = " + finalCount);
        LOGGER.info("Count query finished in " + (System.currentTimeMillis() - startTime) + " ms");
        return finalCount;
    }

    @Override
    String graqlString() {
        return "count" + this.subtypeString();
    }
}

