/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.analytics.DegreeQuery;
import ai.grakn.graql.internal.analytics.DegreeDistributionMapReduce;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractCentralityQuery;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class DegreeQueryImpl
extends AbstractCentralityQuery<DegreeQuery>
implements DegreeQuery {
    DegreeQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Map<Long, Set<String>> execute() {
        LOGGER.info("Degree query started");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        this.getAllSubTypes();
        if (this.ofLabels.isEmpty()) {
            this.ofLabels.addAll(this.subLabels);
        } else {
            this.ofLabels = this.ofLabels.stream().flatMap(typeLabel -> {
                Type type = (Type)((GraknTx)this.tx.get()).getSchemaConcept(typeLabel);
                if (type == null) {
                    throw GraqlQueryException.labelNotFound((Label)typeLabel);
                }
                return type.subs();
            }).map(SchemaConcept::getLabel).collect(Collectors.toSet());
            this.subLabels.addAll(this.ofLabels);
        }
        if (!this.selectedTypesHaveInstance()) {
            LOGGER.info("Degree query finished in " + (System.currentTimeMillis() - startTime) + " ms");
            return Collections.emptyMap();
        }
        Set<LabelId> subLabelIds = this.convertLabelsToIds(this.subLabels);
        Set<LabelId> ofLabelIds = this.convertLabelsToIds(this.ofLabels);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeVertexProgram(ofLabelIds), (MapReduce)new DegreeDistributionMapReduce(ofLabelIds, "degreeVertexProgram.degree"), subLabelIds);
        LOGGER.info("Degree query finished in " + (System.currentTimeMillis() - startTime) + " ms");
        return (Map)result.memory().get(DegreeDistributionMapReduce.class.getName());
    }

    @Override
    AbstractCentralityQuery.CentralityMeasure getMethod() {
        return AbstractCentralityQuery.CentralityMeasure.DEGREE;
    }

    @Override
    String graqlString() {
        return super.graqlString() + ";";
    }
}

