/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.LabelId;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.analytics.KCoreQuery;
import ai.grakn.graql.internal.analytics.ClusterMemberMapReduce;
import ai.grakn.graql.internal.analytics.KCoreVertexProgram;
import ai.grakn.graql.internal.analytics.NoResultException;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class KCoreQueryImpl
extends AbstractComputeQuery<Map<String, Set<String>>, KCoreQuery>
implements KCoreQuery {
    private long k = -1L;

    KCoreQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Map<String, Set<String>> execute() {
        ComputerResult result;
        LOGGER.info("KCore query is started");
        long startTime = System.currentTimeMillis();
        if (this.k < 2L) {
            throw GraqlQueryException.kValueSmallerThanTwo();
        }
        this.includeAttribute = true;
        this.initSubGraph();
        this.getAllSubTypes();
        if (!this.selectedTypesHaveInstance()) {
            LOGGER.info("KCore query is finished in " + (System.currentTimeMillis() - startTime) + " ms");
            return Collections.emptyMap();
        }
        Set<LabelId> subLabelIds = this.convertLabelsToIds(this.subLabels);
        try {
            result = this.getGraphComputer().compute((VertexProgram)new KCoreVertexProgram(this.k), (MapReduce)new ClusterMemberMapReduce("kCoreVertexProgram.kCoreLabel"), subLabelIds);
        }
        catch (NoResultException e) {
            LOGGER.info("KCore query is finished in " + (System.currentTimeMillis() - startTime) + " ms");
            return Collections.emptyMap();
        }
        LOGGER.info("KCore query is finished in " + (System.currentTimeMillis() - startTime) + " ms");
        return (Map)result.memory().get(ClusterMemberMapReduce.class.getName());
    }

    public KCoreQuery kValue(long kValue) {
        this.k = kValue;
        return this;
    }

    @Override
    String graqlString() {
        String string = "kcore ";
        string = string + this.k;
        string = string + this.subtypeString();
        return string;
    }

    public KCoreQuery includeAttribute() {
        return (KCoreQuery)super.includeAttribute();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KCoreQueryImpl that = (KCoreQueryImpl)o;
        return this.k == that.k;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.k);
        return result;
    }
}

