/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.MinQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.MinMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MinQueryImpl
extends AbstractStatisticsQuery<Optional<Number>, MinQuery>
implements MinQuery {
    MinQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MinMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        this.getAllSubTypes();
        AttributeType.DataType dataType = this.getDataTypeOfSelectedResourceTypes();
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceLabels)) {
            return Optional.empty();
        }
        Set<LabelId> allSubLabelIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<LabelId> statisticsResourceLabelIds = this.convertLabelsToIds(this.statisticsResourceLabels);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(statisticsResourceLabelIds), (MapReduce)new MinMapReduce(statisticsResourceLabelIds, dataType, "degreeVertexProgram.degree"), allSubLabelIds);
        Map min = (Map)result.memory().get(MinMapReduce.class.getName());
        LOGGER.debug("Min = " + min.get(MapReduce.NullObject.instance()));
        LOGGER.info("MinMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(min.get(MapReduce.NullObject.instance()));
    }

    @Override
    String getName() {
        return "min";
    }
}

