/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.graql.analytics.PathQuery;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.query.analytics.PathsQueryImpl;
import ai.grakn.graql.internal.util.StringConverter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

class PathQueryImpl
extends AbstractComputeQuery<Optional<List<Concept>>, PathQuery>
implements PathQuery {
    private ConceptId sourceId = null;
    private ConceptId destinationId = null;

    PathQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Optional<List<Concept>> execute() {
        PathsQueryImpl pathsQuery = new PathsQueryImpl(this.tx);
        if (this.includeAttribute) {
            pathsQuery = pathsQuery.includeAttribute();
        }
        return pathsQuery.from(this.sourceId).to(this.destinationId).in((Collection)this.subLabels).execute().stream().findAny();
    }

    public PathQuery from(ConceptId sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public PathQuery to(ConceptId destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    public PathQuery includeAttribute() {
        return (PathQuery)super.includeAttribute();
    }

    @Override
    String graqlString() {
        return "path from " + StringConverter.idToString(this.sourceId) + " to " + StringConverter.idToString(this.destinationId) + this.subtypeString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathQueryImpl pathQuery = (PathQueryImpl)o;
        return this.sourceId.equals(pathQuery.sourceId) && this.destinationId.equals(pathQuery.destinationId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sourceId.hashCode();
        result = 31 * result + this.destinationId.hashCode();
        return result;
    }
}

