/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.analytics.PathsQuery;
import ai.grakn.graql.internal.analytics.NoResultException;
import ai.grakn.graql.internal.analytics.ShortestPathVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class PathsQueryImpl
extends AbstractComputeQuery<List<List<Concept>>, PathsQuery>
implements PathsQuery {
    private ConceptId sourceId = null;
    private ConceptId destinationId = null;

    PathsQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public List<List<Concept>> execute() {
        ComputerResult result;
        LOGGER.info("ShortestPathVertexProgram is called");
        long startTime = System.currentTimeMillis();
        if (this.sourceId == null) {
            throw GraqlQueryException.noPathSource();
        }
        if (this.destinationId == null) {
            throw GraqlQueryException.noPathDestination();
        }
        this.initSubGraph();
        this.getAllSubTypes();
        if (!this.verticesExistInSubgraph(this.sourceId, this.destinationId)) {
            throw GraqlQueryException.instanceDoesNotExist();
        }
        if (this.sourceId.equals(this.destinationId)) {
            return Collections.singletonList(Collections.singletonList(((GraknTx)this.tx.get()).getConcept(this.sourceId)));
        }
        Set<LabelId> subLabelIds = this.convertLabelsToIds(this.subLabels);
        try {
            result = this.getGraphComputer().compute((VertexProgram)new ShortestPathVertexProgram(this.sourceId, this.destinationId), null, subLabelIds);
        }
        catch (NoResultException e) {
            LOGGER.info("ShortestPathVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
            return Collections.emptyList();
        }
        Multimap<Concept, Concept> predecessorMapFromSource = this.getPredecessorMap(result);
        List<List<Concept>> allPaths = this.getAllPaths(predecessorMapFromSource);
        if (this.includeAttribute) {
            return this.getExtendedPaths(allPaths);
        }
        LOGGER.info("Number of paths: " + allPaths.size());
        LOGGER.info("ShortestPathVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return allPaths;
    }

    private List<List<Concept>> getExtendedPaths(List<List<Concept>> allPaths) {
        ArrayList<List<Concept>> extendedPaths = new ArrayList<List<Concept>>();
        for (List<Concept> currentPath : allPaths) {
            boolean hasAttribute = currentPath.stream().anyMatch(Concept::isAttribute);
            if (hasAttribute) continue;
            extendedPaths.add(currentPath);
        }
        int numExtensionAllowed = extendedPaths.isEmpty() ? Integer.MAX_VALUE : 0;
        for (List<Concept> currentPath : allPaths) {
            ArrayList<Object> extendedPath = new ArrayList<Object>();
            int numExtension = 0;
            for (int j = 0; j < currentPath.size() - 1; ++j) {
                extendedPath.add(currentPath.get(j));
                ConceptId resourceRelationId = Utility.getResourceEdgeId((GraknTx)this.tx.get(), currentPath.get(j).getId(), currentPath.get(j + 1).getId());
                if (resourceRelationId == null) continue;
                if (++numExtension > numExtensionAllowed) break;
                extendedPath.add(this.getConcept(resourceRelationId));
            }
            if (numExtension == numExtensionAllowed) {
                extendedPath.add(currentPath.get(currentPath.size() - 1));
                extendedPaths.add(extendedPath);
                continue;
            }
            if (numExtension >= numExtensionAllowed) continue;
            extendedPath.add(currentPath.get(currentPath.size() - 1));
            extendedPaths.clear();
            extendedPaths.add(extendedPath);
            numExtensionAllowed = numExtension;
        }
        return extendedPaths;
    }

    private Multimap<Concept, Concept> getPredecessorMap(ComputerResult result) {
        Map predecessorMapFromSource = (Map)result.memory().get("shortestPathVertexProgram.predecessors.fromSource");
        Map predecessorMapFromDestination = (Map)result.memory().get("shortestPathVertexProgram.predecessors.fromDestination");
        HashMultimap predecessors = HashMultimap.create();
        predecessorMapFromSource.forEach((arg_0, arg_1) -> this.lambda$getPredecessorMap$1((Multimap)predecessors, arg_0, arg_1));
        predecessorMapFromDestination.forEach((arg_0, arg_1) -> this.lambda$getPredecessorMap$3((Multimap)predecessors, arg_0, arg_1));
        return predecessors;
    }

    private List<List<Concept>> getAllPaths(Multimap<Concept, Concept> predecessorMapFromSource) {
        ArrayList<List<Concept>> allPaths = new ArrayList<List<Concept>>();
        ArrayList<Thing> firstPath = new ArrayList<Thing>();
        firstPath.add(this.getConcept(this.sourceId.getValue()));
        ArrayDeque<List> queue = new ArrayDeque<List>();
        queue.addLast(firstPath);
        while (!queue.isEmpty()) {
            List currentPath = (List)queue.pollFirst();
            if (predecessorMapFromSource.containsKey(currentPath.get(currentPath.size() - 1))) {
                Collection successors = predecessorMapFromSource.get(currentPath.get(currentPath.size() - 1));
                Iterator iterator = successors.iterator();
                for (int i = 0; i < successors.size() - 1; ++i) {
                    ArrayList extendedPath = new ArrayList(currentPath);
                    extendedPath.add(iterator.next());
                    queue.addLast(extendedPath);
                }
                currentPath.add(iterator.next());
                queue.addLast(currentPath);
                continue;
            }
            allPaths.add(currentPath);
        }
        return allPaths;
    }

    private Thing getConcept(String conceptId) {
        return (Thing)((GraknTx)this.tx.get()).getConcept(ConceptId.of((String)conceptId));
    }

    private Thing getConcept(ConceptId conceptId) {
        return (Thing)((GraknTx)this.tx.get()).getConcept(conceptId);
    }

    public PathsQuery from(ConceptId sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public PathsQuery to(ConceptId destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    public PathsQuery includeAttribute() {
        return (PathsQuery)super.includeAttribute();
    }

    @Override
    String graqlString() {
        return "paths from " + StringConverter.idToString(this.sourceId) + " to " + StringConverter.idToString(this.destinationId) + this.subtypeString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathsQueryImpl pathQuery = (PathsQueryImpl)o;
        return this.sourceId.equals(pathQuery.sourceId) && this.destinationId.equals(pathQuery.destinationId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sourceId.hashCode();
        result = 31 * result + this.destinationId.hashCode();
        return result;
    }

    private /* synthetic */ void lambda$getPredecessorMap$3(Multimap predecessors, String id, Set idSet) {
        idSet.forEach(id2 -> predecessors.put((Object)this.getConcept((String)id2), (Object)this.getConcept(id)));
    }

    private /* synthetic */ void lambda$getPredecessorMap$1(Multimap predecessors, String id, Set idSet) {
        idSet.forEach(id2 -> predecessors.put((Object)this.getConcept(id), (Object)this.getConcept((String)id2)));
    }
}

