/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Match;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.graql.internal.gremlin.GreedyTraversalPlan;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.query.match.AbstractMatch;
import ai.grakn.graql.internal.query.match.MatchInfer;
import ai.grakn.kb.admin.GraknAdmin;
import ai.grakn.util.CommonUtil;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchBase
extends AbstractMatch {
    protected final Logger LOG = LoggerFactory.getLogger(MatchBase.class);
    private final Conjunction<PatternAdmin> pattern;

    public MatchBase(Conjunction<PatternAdmin> pattern) {
        if (pattern.getPatterns().size() == 0) {
            throw GraqlQueryException.noPatterns();
        }
        this.pattern = pattern;
    }

    @Override
    public Stream<Answer> stream(Optional<GraknTx> optionalGraph) {
        GraknTx graph = optionalGraph.orElseThrow(GraqlQueryException::noTx);
        this.validatePattern(graph);
        GraqlTraversal graqlTraversal = GreedyTraversalPlan.createTraversal(this.pattern, graph);
        this.LOG.trace("Created query plan");
        this.LOG.trace(graqlTraversal.toString());
        return MatchBase.streamWithTraversal(this.getPattern().commonVars(), graph, graqlTraversal);
    }

    public static Stream<Answer> streamWithTraversal(Set<Var> commonVars, GraknTx graph, GraqlTraversal graqlTraversal) {
        Set vars = Sets.filter(commonVars, Var::isUserDefinedName);
        GraphTraversal<Vertex, Map<String, Element>> traversal = graqlTraversal.getGraphTraversal(graph, vars);
        return ((Stream)traversal.toStream().map(elements -> MatchBase.makeResults(vars, graph, elements)).flatMap(CommonUtil::optionalToStream).distinct().sequential()).map(QueryAnswer::new);
    }

    private static Optional<Map<Var, Concept>> makeResults(Set<Var> vars, GraknTx graph, Map<String, Element> elements) {
        HashMap<Var, Concept> map = new HashMap<Var, Concept>();
        for (Var var : vars) {
            Element element = elements.get(var.name());
            if (element == null) {
                throw GraqlQueryException.unexpectedResult((Var)var);
            }
            Concept concept = MatchBase.buildConcept(graph.admin(), element);
            map.put(var, concept);
        }
        return Optional.of(map);
    }

    private static Concept buildConcept(GraknAdmin graph, Element element) {
        if (element instanceof Vertex) {
            return graph.buildConcept((Vertex)element);
        }
        return graph.buildConcept((Edge)element);
    }

    public Set<SchemaConcept> getSchemaConcepts(GraknTx tx) {
        return this.pattern.varPatterns().stream().flatMap(v -> v.innerVarPatterns().stream()).flatMap(v -> v.getTypeLabels().stream()).map(arg_0 -> ((GraknTx)tx).getSchemaConcept(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<SchemaConcept> getSchemaConcepts() {
        throw GraqlQueryException.noTx();
    }

    public Conjunction<PatternAdmin> getPattern() {
        return this.pattern;
    }

    public Optional<GraknTx> tx() {
        return Optional.empty();
    }

    public final Set<Var> getSelectedNames() {
        return this.pattern.commonVars();
    }

    public String toString() {
        return "match " + this.pattern.getPatterns().stream().map(p -> p + ";").collect(Collectors.joining(" "));
    }

    public final Match infer(boolean materialise) {
        return new MatchInfer(this, materialise);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchBase maps = (MatchBase)o;
        return this.pattern.equals(maps.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }
}

