/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.predicate;

import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.predicate.AutoValue_RegexPredicate;
import ai.grakn.graql.internal.query.predicate.EqPredicate;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;

abstract class RegexPredicate
implements ValuePredicate {
    RegexPredicate() {
    }

    abstract String pattern();

    static RegexPredicate of(String pattern) {
        return new AutoValue_RegexPredicate(pattern);
    }

    private P<Object> regexPredicate() {
        BiPredicate<Object, Object> predicate = (value, p) -> Pattern.matches((String)p, (String)value);
        return new P(predicate, (Object)this.pattern());
    }

    public Optional<P<Object>> getPredicate() {
        return Optional.of(this.regexPredicate());
    }

    public Optional<VarPatternAdmin> getInnerVar() {
        return Optional.empty();
    }

    public <S, E> GraphTraversal<S, E> applyPredicate(GraphTraversal<S, E> traversal) {
        return traversal.has(Schema.VertexProperty.VALUE_STRING.name(), this.regexPredicate());
    }

    public String toString() {
        return "/" + this.pattern().replaceAll("/", "\\\\/") + "/";
    }

    public boolean isCompatibleWith(ValuePredicate predicate) {
        if (!(predicate instanceof EqPredicate)) {
            return false;
        }
        EqPredicate p = (EqPredicate)predicate;
        Object pVal = p.equalsValue().orElse(null);
        return pVal == null || this.regexPredicate().test(pVal);
    }
}

