/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner;

import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiUnifierImpl
implements MultiUnifier {
    private final ImmutableSet<Unifier> multiUnifier;

    public MultiUnifierImpl(Set<Unifier> us) {
        this.multiUnifier = ImmutableSet.copyOf(us);
    }

    public MultiUnifierImpl(Unifier u) {
        this.multiUnifier = ImmutableSet.of((Object)u);
    }

    public MultiUnifierImpl() {
        this.multiUnifier = ImmutableSet.of((Object)new UnifierImpl());
    }

    @SafeVarargs
    MultiUnifierImpl(ImmutableMultimap<Var, Var> ... maps) {
        this.multiUnifier = ImmutableSet.builder().addAll(Stream.of(maps).map(UnifierImpl::new).iterator()).build();
    }

    public Stream<Unifier> stream() {
        return this.multiUnifier.stream();
    }

    public Iterator<Unifier> iterator() {
        return this.multiUnifier.iterator();
    }

    public Unifier getUnifier() {
        return (Unifier)Iterables.getOnlyElement(this.multiUnifier);
    }

    public Unifier getAny() {
        UnmodifiableIterator iterator = this.multiUnifier.iterator();
        if (!iterator.hasNext()) {
            throw GraqlQueryException.nonExistentUnifier();
        }
        return (Unifier)iterator.next();
    }

    public ImmutableSet<Unifier> unifiers() {
        return this.multiUnifier;
    }

    public boolean isEmpty() {
        return this.multiUnifier.isEmpty();
    }

    public boolean contains(Unifier u2) {
        return this.unifiers().stream().anyMatch(u -> u.containsAll(u2));
    }

    public boolean containsAll(MultiUnifier mu) {
        return !mu.unifiers().stream().anyMatch(u -> !this.contains((Unifier)u));
    }

    public MultiUnifier inverse() {
        return new MultiUnifierImpl(this.multiUnifier.stream().map(Unifier::inverse).collect(Collectors.toSet()));
    }

    public int size() {
        return this.multiUnifier.size();
    }
}

