/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.iterator.ReasonerQueryIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.state.ResolutionState;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionIterator
extends ReasonerQueryIterator {
    private int iter = 0;
    private long oldAns = 0L;
    private final ReasonerQueryImpl query;
    private final Set<Answer> answers = new HashSet<Answer>();
    private final QueryCache<ReasonerAtomicQuery> cache = new QueryCache();
    private final Stack<ResolutionState> states = new Stack();
    private Answer nextAnswer = null;
    private final boolean reiterationRequired;
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerQueryImpl.class);

    public ResolutionIterator(ReasonerQueryImpl q) {
        this.query = q;
        this.reiterationRequired = q.requiresReiteration();
        this.states.push(this.query.subGoal(new QueryAnswer(), new UnifierImpl(), null, new HashSet<ReasonerAtomicQuery>(), this.cache));
    }

    private Answer findNextAnswer() {
        while (!this.states.isEmpty()) {
            ResolutionState state = this.states.pop();
            if (state.isAnswerState() && state.isTopState()) {
                return state.getSubstitution();
            }
            ResolutionState newState = state.generateSubGoal();
            if (newState == null) continue;
            if (!state.isAnswerState()) {
                this.states.push(state);
            }
            this.states.push(newState);
        }
        return null;
    }

    @Override
    public Answer next() {
        if (this.nextAnswer == null) {
            throw new NoSuchElementException();
        }
        this.answers.add(this.nextAnswer);
        return this.nextAnswer;
    }

    @Override
    public boolean hasNext() {
        long dAns;
        this.nextAnswer = this.findNextAnswer();
        if (this.nextAnswer != null) {
            return true;
        }
        if (this.reiterationRequired && ((dAns = (long)this.answers.size() - this.oldAns) != 0L || this.iter == 0)) {
            LOG.debug("iter: " + this.iter + " answers: " + this.answers.size() + " dAns = " + dAns);
            ++this.iter;
            this.states.push(this.query.subGoal(new QueryAnswer(), new UnifierImpl(), null, new HashSet<ReasonerAtomicQuery>(), this.cache));
            this.oldAns = this.answers.size();
            return this.hasNext();
        }
        return false;
    }
}

