/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner;

import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.UnifierComparison;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;

public enum UnifierType implements UnifierComparison
{
    EXACT{

        public boolean typePlayability(ReasonerQuery query, Var var, Type type) {
            return true;
        }

        public boolean typeCompatibility(Type parent, Type child) {
            return !ReasonerUtils.areDisjointTypes((SchemaConcept)parent, (SchemaConcept)child);
        }

        public boolean atomicCompatibility(Atomic parent, Atomic child) {
            return parent == null || parent.isCompatibleWith((Object)child);
        }
    }
    ,
    RULE{

        public boolean typePlayability(ReasonerQuery query, Var var, Type type) {
            return query.isTypeRoleCompatible(var, type);
        }

        public boolean typeCompatibility(Type parent, Type child) {
            return child == null || !ReasonerUtils.areDisjointTypes((SchemaConcept)parent, (SchemaConcept)child);
        }

        public boolean atomicCompatibility(Atomic parent, Atomic child) {
            return child == null || parent == null || parent.isCompatibleWith((Object)child);
        }
    }
    ,
    STRUCTURAL{

        public boolean typePlayability(ReasonerQuery query, Var var, Type type) {
            return true;
        }

        public boolean typeCompatibility(Type parent, Type child) {
            return child == null || !ReasonerUtils.areDisjointTypes((SchemaConcept)parent, (SchemaConcept)child);
        }

        public boolean atomicCompatibility(Atomic parent, Atomic child) {
            return parent == null == (child == null);
        }
    };

}

