/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.UnifierComparison;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.binary.RelationshipAtom;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.rule.RuleUtils;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class Atom
extends AtomicBase {
    private Set<InferenceRule> applicableRules = null;

    protected Atom(VarPattern pattern, ReasonerQuery par) {
        super(pattern, par);
    }

    protected Atom(Atom a) {
        super(a);
        this.applicableRules = a.applicableRules;
    }

    public RelationshipAtom toRelationshipAtom() {
        throw GraqlQueryException.illegalAtomConversion((Atomic)this);
    }

    public boolean isAtom() {
        return true;
    }

    public boolean isRuleResolvable() {
        return this.getApplicableRules().findFirst().isPresent();
    }

    public boolean isRecursive() {
        if (this.isResource() || this.getSchemaConcept() == null) {
            return false;
        }
        SchemaConcept schemaConcept = this.getSchemaConcept();
        return this.getApplicableRules().filter(rule -> rule.getBody().selectAtoms().stream().filter(at -> Objects.nonNull(at.getSchemaConcept())).anyMatch(at -> ReasonerUtils.typesCompatible(schemaConcept, at.getSchemaConcept()))).anyMatch(this::isRuleApplicable);
    }

    public boolean isGround() {
        Set<Var> varNames = this.getVarNames();
        return Stream.concat(this.getPredicates(), this.getInnerPredicates()).map(AtomicBase::getVarName).allMatch(varNames::contains);
    }

    public abstract Class<? extends VarProperty> getVarPropertyClass();

    @Override
    public Set<String> validateAsRuleHead(Rule rule) {
        SchemaConcept schemaConcept;
        HashSet<String> errors = new HashSet<String>();
        Set parentAtoms = this.getParentQuery().getAtoms(Atomic.class).filter(at -> !at.equals(this)).collect(Collectors.toSet());
        Sets.SetView varNames = Sets.difference(this.getVarNames(), this.getInnerPredicates().map(Atomic::getVarName).collect(Collectors.toSet()));
        boolean unboundVariables = varNames.stream().anyMatch(var -> !parentAtoms.stream().anyMatch(at -> at.getVarNames().contains(var)));
        if (unboundVariables) {
            errors.add(ErrorMessage.VALIDATION_RULE_ILLEGAL_HEAD_ATOM_WITH_UNBOUND_VARIABLE.getMessage(new Object[]{rule.getThen(), rule.getLabel()}));
        }
        if ((schemaConcept = this.getSchemaConcept()) == null) {
            errors.add(ErrorMessage.VALIDATION_RULE_ILLEGAL_HEAD_ATOM_WITH_AMBIGUOUS_SCHEMA_CONCEPT.getMessage(new Object[]{rule.getThen(), rule.getLabel()}));
        } else if (schemaConcept.isImplicit().booleanValue()) {
            errors.add(ErrorMessage.VALIDATION_RULE_ILLEGAL_HEAD_ATOM_WITH_IMPLICIT_SCHEMA_CONCEPT.getMessage(new Object[]{rule.getThen(), rule.getLabel()}));
        }
        return errors;
    }

    public Stream<VarProperty> getVarProperties() {
        return this.getCombinedPattern().admin().varPatterns().stream().flatMap(vp -> vp.getProperties(this.getVarPropertyClass()));
    }

    public Stream<IdPredicate> getPartialSubstitutions() {
        return Stream.empty();
    }

    public Set<Var> getRoleExpansionVariables() {
        return new HashSet<Var>();
    }

    public int computePriority(Set<Var> subbedVars) {
        int priority = 0;
        priority += Sets.intersection(this.getVarNames(), subbedVars).size() * 30;
        priority += this.isRuleResolvable() ? -10 : 0;
        priority += this.isRecursive() ? -5 : 0;
        priority = (int)((long)priority + this.getTypeConstraints().count() * 1L);
        Set otherVars = this.getParentQuery().getAtoms().stream().filter(a -> a != this).flatMap(at -> at.getVarNames().stream()).collect(Collectors.toSet());
        priority += Sets.intersection(this.getVarNames(), otherVars).size() * -2;
        priority = (int)((long)priority + this.getPredicates(NeqPredicate.class).map(Predicate::getPredicate).filter(v -> !subbedVars.contains(v)).count() * -1000L);
        return priority;
    }

    private boolean isRuleApplicable(InferenceRule child) {
        return this.isRuleApplicableViaAtom(child.getRuleConclusionAtom());
    }

    protected abstract boolean isRuleApplicableViaAtom(Atom var1);

    protected Stream<Rule> getPotentialRules() {
        return RuleUtils.getRulesWithType(this.getSchemaConcept(), this.tx());
    }

    public Stream<InferenceRule> getApplicableRules() {
        if (this.applicableRules == null) {
            this.applicableRules = new HashSet<InferenceRule>();
            this.getPotentialRules().map(rule -> new InferenceRule((Rule)rule, this.tx())).filter(this::isRuleApplicable).map(r -> r.rewrite(this)).forEach(this.applicableRules::add);
        }
        return this.applicableRules.stream();
    }

    public boolean requiresMaterialisation() {
        return false;
    }

    public boolean requiresRoleExpansion() {
        return false;
    }

    public abstract SchemaConcept getSchemaConcept();

    public abstract ConceptId getTypeId();

    public abstract Var getPredicateVariable();

    public Stream<Predicate> getPredicates() {
        return this.getPredicates(Predicate.class);
    }

    public <T extends Predicate> Stream<T> getPredicates(Class<T> type) {
        return this.getParentQuery().getAtoms(type).filter(atom -> !Sets.intersection(this.getVarNames(), atom.getVarNames()).isEmpty());
    }

    @Nullable
    public IdPredicate getIdPredicate(Var var) {
        return this.getPredicate(var, IdPredicate.class);
    }

    @Nullable
    public <T extends Predicate> T getPredicate(Var var, Class<T> type) {
        return (T)((Predicate)this.getPredicates(type).filter(p -> p.getVarName().equals((Object)var)).findFirst().orElse(null));
    }

    public abstract Stream<Predicate> getInnerPredicates();

    public <T extends Predicate> Stream<T> getInnerPredicates(Class<T> type) {
        return this.getInnerPredicates().filter(type::isInstance).map(type::cast);
    }

    public Stream<TypeAtom> getTypeConstraints() {
        return this.getParentQuery().getAtoms(TypeAtom.class).filter(atom -> atom != this).filter(atom -> this.containsVar(atom.getVarName()));
    }

    public <T extends Atomic> Stream<T> getNeighbours(Class<T> type) {
        return this.getParentQuery().getAtoms(type).filter(atom -> atom != this).filter(atom -> !Sets.intersection(this.getVarNames(), (Set)atom.getVarNames()).isEmpty());
    }

    public Stream<Atomic> getNonSelectableConstraints() {
        return Stream.concat(this.getPredicates(), this.getTypeConstraints().filter(at -> !at.isSelectable()));
    }

    public Set<TypeAtom> getSpecificTypeConstraints() {
        return new HashSet<TypeAtom>();
    }

    @Override
    public Atom inferTypes() {
        return this.inferTypes(new QueryAnswer());
    }

    @Override
    public Atom inferTypes(Answer sub) {
        return this;
    }

    public List<Atom> atomOptions(Answer sub) {
        return Lists.newArrayList((Object[])new Atom[]{this.inferTypes(sub)});
    }

    public Atom addType(SchemaConcept type) {
        return this;
    }

    public Stream<Answer> materialise() {
        return Stream.empty();
    }

    public abstract Atom rewriteWithTypeVariable();

    protected Atom rewriteWithTypeVariable(Atom parentAtom) {
        if (!parentAtom.getPredicateVariable().isUserDefinedName()) {
            return this;
        }
        return this.rewriteWithTypeVariable();
    }

    public Atom rewriteWithRelationVariable() {
        return this;
    }

    public abstract Atom rewriteToUserDefined(Atom var1);

    public abstract Unifier getUnifier(Atom var1);

    public MultiUnifier getMultiUnifier(Atom parentAtom, UnifierComparison unifierType) {
        return new MultiUnifierImpl(this.getUnifier(parentAtom));
    }
}

