/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.GraknTx;
import ai.grakn.concept.Rule;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;

public abstract class AtomicBase
implements Atomic {
    private final Var varName;
    private final VarPattern atomPattern;
    private Pattern combinedPattern = null;
    private ReasonerQuery parent;

    protected AtomicBase(VarPattern pattern, ReasonerQuery par) {
        this.atomPattern = pattern;
        this.varName = pattern.admin().var();
        this.parent = par;
    }

    protected AtomicBase(AtomicBase a) {
        this.atomPattern = a.atomPattern;
        this.varName = this.atomPattern.admin().var();
        this.parent = a.getParentQuery();
    }

    public abstract Atomic copy();

    public void checkValid() {
    }

    public Set<String> validateAsRuleHead(Rule rule) {
        return Sets.newHashSet((Object[])new String[]{ErrorMessage.VALIDATION_RULE_ILLEGAL_ATOMIC_IN_HEAD.getMessage(new Object[]{rule.getThen(), rule.getLabel()})});
    }

    public String toString() {
        return this.atomPattern.toString();
    }

    public boolean containsVar(Var name) {
        return this.getVarNames().contains(name);
    }

    public boolean isUserDefined() {
        return this.varName.isUserDefinedName();
    }

    public Var getVarName() {
        return this.varName;
    }

    public Set<Var> getVarNames() {
        return this.varName.isUserDefinedName() ? Sets.newHashSet((Object[])new Var[]{this.varName}) : Collections.emptySet();
    }

    public VarPattern getPattern() {
        return this.atomPattern;
    }

    protected Pattern createCombinedPattern() {
        return this.atomPattern;
    }

    public Pattern getCombinedPattern() {
        if (this.combinedPattern == null) {
            this.combinedPattern = this.createCombinedPattern();
        }
        return this.combinedPattern;
    }

    public ReasonerQuery getParentQuery() {
        return this.parent;
    }

    public void setParentQuery(ReasonerQuery q) {
        this.parent = q;
    }

    public Atomic inferTypes() {
        return this.inferTypes(new QueryAnswer());
    }

    public Atomic inferTypes(Answer sub) {
        return this;
    }

    protected GraknTx tx() {
        return this.getParentQuery().tx();
    }
}

