/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.UnifierComparison;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.RelationshipProperty;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.UnifierType;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.binary.type.IsaAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.graql.internal.reasoner.utils.conversion.RoleConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.TypeConverter;
import ai.grakn.kb.internal.concept.RelationshipTypeImpl;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class RelationshipAtom
extends IsaAtom {
    private int hashCode = 0;
    private ImmutableMultimap<Role, Var> roleVarMap = null;
    private ImmutableMultimap<Role, Type> roleTypeMap = null;
    private ImmutableMultimap<Role, String> roleConceptIdMap = null;
    private ImmutableList<Type> possibleRelations = null;
    private final ImmutableList<RelationPlayer> relationPlayers;
    private final ImmutableSet<Label> roleLabels;

    public RelationshipAtom(VarPattern pattern, Var predicateVar, @Nullable IdPredicate predicate, ReasonerQuery par) {
        super(pattern, predicateVar, predicate, par);
        ArrayList rps = new ArrayList();
        this.getPattern().admin().getProperty(RelationshipProperty.class).ifPresent(prop -> rps.addAll(prop.relationPlayers()));
        this.relationPlayers = ImmutableList.copyOf(rps);
        this.roleLabels = ImmutableSet.builder().addAll(this.relationPlayers.stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).iterator()).build();
    }

    private RelationshipAtom(VarPatternAdmin pattern, Var predicateVar, @Nullable IdPredicate predicate, ImmutableList<Type> possibleRelations, ReasonerQuery par) {
        this((VarPattern)pattern, predicateVar, predicate, par);
        this.possibleRelations = possibleRelations;
    }

    private RelationshipAtom(RelationshipAtom a) {
        super(a);
        this.relationPlayers = a.relationPlayers;
        this.roleLabels = a.roleLabels;
        this.roleVarMap = a.roleVarMap;
        this.possibleRelations = a.possibleRelations;
    }

    @Override
    public Class<? extends VarProperty> getVarPropertyClass() {
        return RelationshipProperty.class;
    }

    @Override
    public void checkValid() {
        super.checkValid();
        this.getRoleLabels().stream().filter(label -> this.tx().getRole(label.getValue()) == null).findFirst().ifPresent(label -> {
            throw GraqlQueryException.labelNotFound((Label)label);
        });
    }

    @Override
    public RelationshipAtom toRelationshipAtom() {
        return this;
    }

    @Override
    public String toString() {
        String typeString = this.getSchemaConcept() != null ? this.getSchemaConcept().getLabel().getValue() : "{" + this.inferPossibleTypes(new QueryAnswer()).stream().map(rt -> rt.getLabel().getValue()).collect(Collectors.joining(", ")) + "}";
        String relationString = (this.isUserDefined() ? this.getVarName() + " " : "") + typeString + this.getRelationPlayers().toString();
        return relationString + this.getPredicates(Predicate.class).map(AtomicBase::toString).collect(Collectors.joining(""));
    }

    private ImmutableSet<Label> getRoleLabels() {
        return this.roleLabels;
    }

    private ImmutableList<RelationPlayer> getRelationPlayers() {
        return this.relationPlayers;
    }

    private Set<Var> getRolePlayers() {
        return this.getRelationPlayers().stream().map(c -> c.getRolePlayer().var()).collect(Collectors.toSet());
    }

    private Set<Var> getRoleVariables() {
        return this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).map(VarPatternAdmin::var).filter(Var::isUserDefinedName).collect(Collectors.toSet());
    }

    private Answer getRoleSubstitution() {
        HashMap<Var, Concept> roleSub = new HashMap<Var, Concept>();
        this.getRolePredicates().forEach(p -> roleSub.put(p.getVarName(), this.tx().getConcept((ConceptId)p.getPredicate())));
        return new QueryAnswer(roleSub);
    }

    @Override
    public Atomic copy() {
        return new RelationshipAtom(this);
    }

    @Override
    protected Pattern createCombinedPattern() {
        if (this.getPredicateVariable().isUserDefinedName()) {
            return super.createCombinedPattern();
        }
        return this.getSchemaConcept() != null ? this.relationPattern().isa(this.getSchemaConcept().getLabel().getValue()) : this.relationPattern();
    }

    private VarPattern relationPattern() {
        return this.relationPattern(this.getVarName(), (List<RelationPlayer>)this.getRelationPlayers());
    }

    private VarPattern relationPattern(Var varName, List<RelationPlayer> relationPlayers) {
        Var var = varName;
        for (RelationPlayer rp : relationPlayers) {
            VarPatternAdmin rolePattern = rp.getRole().orElse(null);
            var = rolePattern != null ? var.rel((VarPattern)rolePattern, (VarPattern)rp.getRolePlayer()) : var.rel((VarPattern)rp.getRolePlayer());
        }
        return var.admin();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RelationshipAtom a2 = (RelationshipAtom)obj;
        return Objects.equals(this.getTypeId(), a2.getTypeId()) && this.isUserDefined() == a2.isUserDefined() && this.getVarNames().equals(a2.getVarNames()) && this.getRelationPlayers().equals(a2.getRelationPlayers());
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
            this.hashCode = this.hashCode * 37 + this.getVarNames().hashCode();
            this.hashCode = this.hashCode * 37 + this.getRelationPlayers().hashCode();
        }
        return this.hashCode;
    }

    private boolean isBaseEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RelationshipAtom a2 = (RelationshipAtom)obj;
        return this.isUserDefined() == a2.isUserDefined() && Objects.equals(this.getTypeId(), a2.getTypeId()) && this.getRolePlayers().size() == a2.getRolePlayers().size() && this.getRelationPlayers().size() == a2.getRelationPlayers().size() && this.getRoleLabels().equals(a2.getRoleLabels()) && this.getRoleTypeMap().equals(a2.getRoleTypeMap());
    }

    private int baseHashCode() {
        int baseHashCode = 1;
        baseHashCode = baseHashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        baseHashCode = baseHashCode * 37 + this.getRoleTypeMap().hashCode();
        baseHashCode = baseHashCode * 37 + this.getRoleLabels().hashCode();
        return baseHashCode;
    }

    @Override
    public boolean isAlphaEquivalent(Object obj) {
        if (!this.isBaseEquivalent(obj)) {
            return false;
        }
        RelationshipAtom a2 = (RelationshipAtom)obj;
        return this.getRoleConceptIdMap().equals(a2.getRoleConceptIdMap());
    }

    @Override
    public int alphaEquivalenceHashCode() {
        int equivalenceHashCode = this.baseHashCode();
        equivalenceHashCode = equivalenceHashCode * 37 + this.getRoleConceptIdMap().hashCode();
        return equivalenceHashCode;
    }

    @Override
    public boolean isStructurallyEquivalent(Object obj) {
        if (!this.isBaseEquivalent(obj)) {
            return false;
        }
        RelationshipAtom a2 = (RelationshipAtom)obj;
        return this.getRoleConceptIdMap().keySet().equals(a2.getRoleConceptIdMap().keySet());
    }

    @Override
    public int structuralEquivalenceHashCode() {
        int equivalenceHashCode = this.baseHashCode();
        equivalenceHashCode = equivalenceHashCode * 37 + this.getRoleConceptIdMap().keySet().hashCode();
        return equivalenceHashCode;
    }

    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isType() {
        return this.getSchemaConcept() != null;
    }

    @Override
    public boolean requiresMaterialisation() {
        return this.isUserDefined();
    }

    @Override
    public boolean requiresRoleExpansion() {
        return !this.getRoleVariables().isEmpty();
    }

    @Override
    public Set<String> validateAsRuleHead(Rule rule) {
        return Sets.union(super.validateAsRuleHead(rule), this.validateRelationPlayers(rule));
    }

    private Set<String> validateRelationPlayers(Rule rule) {
        HashSet<String> errors = new HashSet<String>();
        this.getRelationPlayers().forEach(rp -> {
            VarPatternAdmin role = rp.getRole().orElse(null);
            if (role == null) {
                errors.add(ErrorMessage.VALIDATION_RULE_ILLEGAL_HEAD_RELATION_WITH_AMBIGUOUS_ROLE.getMessage(new Object[]{rule.getThen(), rule.getLabel()}));
            } else {
                Label roleLabel = role.getTypeLabel().orElse(null);
                if (roleLabel == null) {
                    errors.add(ErrorMessage.VALIDATION_RULE_ILLEGAL_HEAD_RELATION_WITH_AMBIGUOUS_ROLE.getMessage(new Object[]{rule.getThen(), rule.getLabel()}));
                } else {
                    Role roleType;
                    if (Schema.MetaSchema.isMetaLabel((Label)roleLabel)) {
                        errors.add(ErrorMessage.VALIDATION_RULE_ILLEGAL_HEAD_RELATION_WITH_AMBIGUOUS_ROLE.getMessage(new Object[]{rule.getThen(), rule.getLabel()}));
                    }
                    if ((roleType = this.tx().getRole(roleLabel.getValue())) != null && roleType.isImplicit().booleanValue()) {
                        errors.add(ErrorMessage.VALIDATION_RULE_ILLEGAL_HEAD_RELATION_WITH_IMPLICIT_ROLE.getMessage(new Object[]{rule.getThen(), rule.getLabel()}));
                    }
                }
            }
        });
        return errors;
    }

    public Set<String> validateOntologically() {
        HashSet<String> errors = new HashSet<String>();
        SchemaConcept type = this.getSchemaConcept();
        if (type != null && !type.isRelationshipType()) {
            errors.add(ErrorMessage.VALIDATION_RULE_INVALID_RELATION_TYPE.getMessage(new Object[]{type.getLabel()}));
            return errors;
        }
        ImmutableMap varTypeMap = this.getParentQuery().getVarTypeMap();
        for (Map.Entry e : this.getRoleVarMap().asMap().entrySet()) {
            Role role = (Role)e.getKey();
            if (Schema.MetaSchema.isMetaLabel((Label)role.getLabel())) continue;
            if (type != null && type.asRelationshipType().relates().noneMatch(r -> r.equals(role))) {
                errors.add(ErrorMessage.VALIDATION_RULE_ROLE_CANNOT_BE_PLAYED.getMessage(new Object[]{role.getLabel(), type.getLabel()}));
            }
            for (Var player : (Collection)e.getValue()) {
                Type playerType = (Type)varTypeMap.get(player);
                if (playerType == null || !playerType.plays().noneMatch(plays -> plays.equals(role))) continue;
                errors.add(ErrorMessage.VALIDATION_RULE_TYPE_CANNOT_PLAY_ROLE.getMessage(new Object[]{playerType.getLabel(), role.getLabel(), type == null ? "" : type.getLabel()}));
            }
        }
        return errors;
    }

    @Override
    public int computePriority(Set<Var> subbedVars) {
        int priority = super.computePriority(subbedVars);
        return priority += 2;
    }

    @Override
    public Stream<IdPredicate> getPartialSubstitutions() {
        Set<Var> varNames = this.getVarNames();
        return this.getPredicates(IdPredicate.class).filter(pred -> varNames.contains(pred.getVarName()));
    }

    public Stream<IdPredicate> getRolePredicates() {
        return this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).filter(var -> var.var().isUserDefinedName()).filter(vp -> vp.getTypeLabel().isPresent()).map(vp -> {
            Label label = vp.getTypeLabel().orElse(null);
            return new IdPredicate(vp.var(), (Concept)this.tx().getRole(label.getValue()), this.getParentQuery());
        });
    }

    private Multimap<Role, String> getRoleConceptIdMap() {
        if (this.roleConceptIdMap == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Map<Var, IdPredicate> varSubMap = this.getPartialSubstitutions().collect(Collectors.toMap(Atomic::getVarName, pred -> pred));
            Multimap<Role, Var> roleMap = this.getRoleVarMap();
            roleMap.entries().stream().filter(e -> varSubMap.containsKey(e.getValue())).sorted(Comparator.comparing(e -> ((IdPredicate)varSubMap.get(e.getValue())).getPredicateValue())).forEach(e -> builder.put(e.getKey(), (Object)((IdPredicate)varSubMap.get(e.getValue())).getPredicateValue()));
            this.roleConceptIdMap = builder.build();
        }
        return this.roleConceptIdMap;
    }

    private Multimap<Role, Type> getRoleTypeMap() {
        if (this.roleTypeMap == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Multimap<Role, Var> roleMap = this.getRoleVarMap();
            ImmutableMap varTypeMap = this.getParentQuery().getVarTypeMap();
            roleMap.entries().stream().filter(arg_0 -> RelationshipAtom.lambda$getRoleTypeMap$17((Map)varTypeMap, arg_0)).sorted(Comparator.comparing(arg_0 -> RelationshipAtom.lambda$getRoleTypeMap$18((Map)varTypeMap, arg_0))).forEach(arg_0 -> RelationshipAtom.lambda$getRoleTypeMap$19(builder, (Map)varTypeMap, arg_0));
            this.roleTypeMap = builder.build();
        }
        return this.roleTypeMap;
    }

    private Stream<Role> getExplicitRoles() {
        ReasonerQueryImpl parent = (ReasonerQueryImpl)this.getParentQuery();
        GraknTx graph = parent.tx();
        return this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).map(arg_0 -> ((GraknTx)graph).getSchemaConcept(arg_0));
    }

    @Override
    public boolean isRuleApplicableViaAtom(Atom ruleAtom) {
        if (ruleAtom.isResource()) {
            return this.isRuleApplicableViaAtom(ruleAtom.toRelationshipAtom());
        }
        if (!(ruleAtom instanceof RelationshipAtom)) {
            return false;
        }
        RelationshipAtom headAtom = (RelationshipAtom)ruleAtom;
        RelationshipAtom atomWithType = this.addType(headAtom.getSchemaConcept()).inferRoles(new QueryAnswer());
        return headAtom.getRelationPlayers().size() >= atomWithType.getRelationPlayers().size() && !headAtom.getRelationPlayerMappings(atomWithType).isEmpty();
    }

    @Override
    public RelationshipAtom addType(SchemaConcept type) {
        if (this.getTypeId() != null) {
            return this;
        }
        Pair<VarPattern, IdPredicate> typedPair = this.getTypedPair(type);
        return new RelationshipAtom(typedPair.getKey(), typedPair.getValue().getVarName(), typedPair.getValue(), this.getParentQuery());
    }

    private Set<Type> inferPossibleEntityTypes(Answer sub) {
        return this.inferPossibleRelationConfigurations(sub).asMap().entrySet().stream().flatMap(e -> {
            Set rs = ((RelationshipType)e.getKey()).relates().collect(Collectors.toSet());
            rs.removeAll((Collection)e.getValue());
            return rs.stream().flatMap(Role::playedByTypes);
        }).collect(Collectors.toSet());
    }

    private Multimap<RelationshipType, Role> inferPossibleRelationConfigurations(Answer sub) {
        Set roles = this.getExplicitRoles().filter(r -> !Schema.MetaSchema.isMetaLabel((Label)r.getLabel())).collect(Collectors.toSet());
        ImmutableMap varTypeMap = this.getParentQuery().getVarTypeMap(sub);
        Set types = this.getRolePlayers().stream().filter(((Map)varTypeMap)::containsKey).map(((Map)varTypeMap)::get).collect(Collectors.toSet());
        if (roles.isEmpty() && types.isEmpty()) {
            RelationshipType metaRelationType = this.tx().admin().getMetaRelationType();
            HashMultimap compatibleTypes = HashMultimap.create();
            metaRelationType.subs().filter(rt -> !rt.equals(metaRelationType)).forEach(arg_0 -> RelationshipAtom.lambda$inferPossibleRelationConfigurations$23((Multimap)compatibleTypes, arg_0));
            return compatibleTypes;
        }
        Multimap<RelationshipType, Role> compatibleTypesFromRoles = ReasonerUtils.compatibleRelationTypesWithRoles(roles, new RoleConverter());
        Multimap<RelationshipType, Role> compatibleTypesFromTypes = ReasonerUtils.compatibleRelationTypesWithRoles(types, new TypeConverter());
        Multimap<RelationshipType, Role> compatibleTypes = roles.isEmpty() ? compatibleTypesFromTypes : (compatibleTypesFromRoles.isEmpty() || types.isEmpty() ? compatibleTypesFromRoles : ReasonerUtils.multimapIntersection(compatibleTypesFromTypes, compatibleTypesFromRoles));
        return compatibleTypes;
    }

    public ImmutableList<Type> inferPossibleTypes(Answer sub) {
        if (this.getSchemaConcept() != null) {
            return ImmutableList.of((Object)this.getSchemaConcept().asRelationshipType());
        }
        if (this.possibleRelations == null) {
            Multimap<RelationshipType, Role> compatibleConfigurations = this.inferPossibleRelationConfigurations(sub);
            Sets.SetView untypedRoleplayers = Sets.difference(this.getRolePlayers(), (Set)this.getParentQuery().getVarTypeMap().keySet());
            Set untypedNeighbours = this.getNeighbours(RelationshipAtom.class).filter(arg_0 -> RelationshipAtom.lambda$inferPossibleTypes$24((Set)untypedRoleplayers, arg_0)).collect(Collectors.toSet());
            ImmutableList.Builder builder = ImmutableList.builder();
            compatibleConfigurations.asMap().entrySet().stream().sorted(Comparator.comparing(e -> -((Collection)e.getValue()).size())).sorted(Comparator.comparing(e -> ((RelationshipType)e.getKey()).relates().count() != (long)this.getRelationPlayers().size())).sorted(Comparator.comparing(e -> -this.tx().admin().getShardCount((Type)e.getKey()))).map(e -> {
                if (untypedNeighbours.isEmpty()) {
                    return new Pair(e.getKey(), 0L);
                }
                Iterator neighbourIterator = untypedNeighbours.iterator();
                Sets.SetView typesFromNeighbour = ((RelationshipAtom)neighbourIterator.next()).inferPossibleEntityTypes(sub);
                while (neighbourIterator.hasNext()) {
                    typesFromNeighbour = Sets.intersection(typesFromNeighbour, ((RelationshipAtom)neighbourIterator.next()).inferPossibleEntityTypes(sub));
                }
                Set rs = ((RelationshipType)e.getKey()).relates().collect(Collectors.toSet());
                rs.removeAll((Collection)e.getValue());
                return new Pair(e.getKey(), rs.stream().flatMap(Role::playedByTypes).filter(((Set)typesFromNeighbour)::contains).count());
            }).sorted(Comparator.comparing(p -> -((Long)p.getValue()).longValue())).sorted(Comparator.comparing(e -> ((RelationshipType)e.getKey()).isImplicit())).map(Pair::getKey).filter(t -> Sets.intersection(ReasonerUtils.supers((SchemaConcept)t), (Set)compatibleConfigurations.keySet()).isEmpty()).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.possibleRelations = builder.build();
        }
        return this.possibleRelations;
    }

    private RelationshipAtom inferRelationshipType(Answer sub) {
        if (this.getTypePredicate() != null) {
            return this;
        }
        if (sub.containsVar(this.getPredicateVariable())) {
            return this.addType((SchemaConcept)sub.get(this.getPredicateVariable()).asType());
        }
        ImmutableList<Type> relationshipTypes = this.inferPossibleTypes(sub);
        if (relationshipTypes.size() == 1) {
            return this.addType((SchemaConcept)Iterables.getOnlyElement(relationshipTypes));
        }
        return this;
    }

    @Override
    public RelationshipAtom inferTypes(Answer sub) {
        return this.inferRelationshipType(sub).inferRoles(sub);
    }

    @Override
    public List<Atom> atomOptions(Answer sub) {
        return this.inferPossibleTypes(sub).stream().map(this::addType).map(at -> at.inferRoles(sub)).sorted(Comparator.comparing(at -> -at.getRoleLabels().size())).sorted(Comparator.comparing(Atom::isRuleResolvable)).collect(Collectors.toList());
    }

    @Override
    public Set<Var> getVarNames() {
        Set<Var> vars = super.getVarNames();
        vars.addAll(this.getRolePlayers());
        vars.addAll(this.getRoleVariables());
        return vars;
    }

    @Override
    public Set<Var> getRoleExpansionVariables() {
        return this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).filter(p -> p.var().isUserDefinedName()).filter(p -> !p.getTypeLabel().isPresent()).map(VarPatternAdmin::var).collect(Collectors.toSet());
    }

    private Set<Var> getSpecificRolePlayers() {
        return this.getRoleVarMap().entries().stream().filter(e -> !Schema.MetaSchema.isMetaLabel((Label)((Role)e.getKey()).getLabel())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Override
    public Set<TypeAtom> getSpecificTypeConstraints() {
        Set<Var> mappedVars = this.getSpecificRolePlayers();
        return this.getTypeConstraints().filter(t -> mappedVars.contains(t.getVarName())).filter(t -> Objects.nonNull(t.getSchemaConcept())).collect(Collectors.toSet());
    }

    @Override
    public Stream<Predicate> getInnerPredicates() {
        return Stream.concat(super.getInnerPredicates(), this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).filter(vp -> vp.var().isUserDefinedName()).map(vp -> new Pair<Var, Object>(vp.var(), vp.getTypeLabel().orElse(null))).filter(p -> Objects.nonNull(p.getValue())).map(p -> new IdPredicate((Var)p.getKey(), (Label)p.getValue(), this.getParentQuery())));
    }

    private RelationshipAtom inferRoles(Answer sub) {
        boolean roleRecomputationViable;
        List explicitRoles = this.getExplicitRoles().collect(Collectors.toList());
        ImmutableMap varTypeMap = this.getParentQuery().getVarTypeMap(sub);
        boolean allRolesMeta = explicitRoles.stream().allMatch(role -> Schema.MetaSchema.isMetaLabel((Label)role.getLabel()));
        boolean bl = roleRecomputationViable = allRolesMeta && (!sub.isEmpty() || !Sets.intersection(varTypeMap.keySet(), this.getRolePlayers()).isEmpty());
        if (explicitRoles.size() == this.getRelationPlayers().size() && !roleRecomputationViable) {
            return this;
        }
        GraknTx graph = this.getParentQuery().tx();
        Role metaRole = graph.admin().getMetaRole();
        ArrayList allocatedRelationPlayers = new ArrayList();
        RelationshipType relType = this.getSchemaConcept() != null ? this.getSchemaConcept().asRelationshipType() : null;
        ArrayList<RelationPlayer> inferredRelationPlayers = new ArrayList<RelationPlayer>();
        this.getRelationPlayers().forEach(rp -> {
            Label roleLabel;
            Var varName = rp.getRolePlayer().var();
            VarPatternAdmin rolePattern = rp.getRole().orElse(null);
            if (!(rolePattern == null || (roleLabel = (Label)rolePattern.getTypeLabel().orElse(null)) != null && Schema.MetaSchema.isMetaLabel((Label)roleLabel))) {
                inferredRelationPlayers.add(RelationPlayer.of((VarPatternAdmin)rolePattern, (VarPatternAdmin)varName.admin()));
                allocatedRelationPlayers.add(rp);
            }
        });
        Set possibleRoles = relType != null ? relType.relates().collect(Collectors.toSet()) : this.inferPossibleTypes(sub).stream().filter(Concept::isRelationshipType).map(Concept::asRelationshipType).flatMap(RelationshipType::relates).collect(Collectors.toSet());
        HashMap mappings = new HashMap();
        this.getRelationPlayers().stream().filter(rp -> !allocatedRelationPlayers.contains(rp)).forEach(arg_0 -> RelationshipAtom.lambda$inferRoles$46((Map)varTypeMap, mappings, possibleRoles, arg_0));
        mappings.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() == 1).forEach(entry -> {
            RelationPlayer rp = (RelationPlayer)entry.getKey();
            Var varName = rp.getRolePlayer().var();
            Role role = (Role)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()));
            VarPatternAdmin rolePattern = Graql.var().label(role.getLabel()).admin();
            inferredRelationPlayers.add(RelationPlayer.of((VarPatternAdmin)rolePattern, (VarPatternAdmin)varName.admin()));
            allocatedRelationPlayers.add(rp);
        });
        this.getRelationPlayers().stream().filter(rp -> !allocatedRelationPlayers.contains(rp)).forEach(rp -> {
            Var varName = rp.getRolePlayer().var();
            VarPatternAdmin rolePattern = rp.getRole().orElse(null);
            rolePattern = rolePattern != null ? rolePattern.var().label(metaRole.getLabel()).admin() : Graql.var().label(metaRole.getLabel()).admin();
            inferredRelationPlayers.add(RelationPlayer.of((VarPatternAdmin)rolePattern, (VarPatternAdmin)varName.admin()));
        });
        VarPatternAdmin newPattern = this.relationPattern(this.getVarName(), inferredRelationPlayers).isa((VarPattern)this.getPredicateVariable()).admin();
        return new RelationshipAtom(newPattern, this.getPredicateVariable(), this.getTypePredicate(), this.possibleRelations, this.getParentQuery());
    }

    public Multimap<Role, Var> getRoleVarMap() {
        if (this.roleVarMap == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            GraknTx graph = this.getParentQuery().tx();
            this.getRelationPlayers().forEach(c -> {
                Var varName = c.getRolePlayer().var();
                VarPatternAdmin rolePattern = c.getRole().orElse(null);
                if (rolePattern != null) {
                    IdPredicate rolePredicate;
                    Role role;
                    Label typeLabel = rolePattern.getTypeLabel().orElse(null);
                    Role role2 = role = typeLabel != null ? graph.getRole(typeLabel.getValue()) : null;
                    if (role == null && rolePattern.var().isUserDefinedName() && (rolePredicate = this.getIdPredicate(rolePattern.var())) != null) {
                        Role r = (Role)graph.getConcept((ConceptId)rolePredicate.getPredicate());
                        if (r == null) {
                            throw GraqlQueryException.idNotFound((ConceptId)((ConceptId)rolePredicate.getPredicate()));
                        }
                        role = r;
                    }
                    if (role != null) {
                        builder.put((Object)role, (Object)varName);
                    }
                }
            });
            this.roleVarMap = builder.build();
        }
        return this.roleVarMap;
    }

    private Multimap<Role, RelationPlayer> getRoleRelationPlayerMap() {
        ArrayListMultimap roleRelationPlayerMap = ArrayListMultimap.create();
        Multimap<Role, Var> roleVarMap = this.getRoleVarMap();
        ImmutableList<RelationPlayer> relationPlayers = this.getRelationPlayers();
        roleVarMap.asMap().forEach((arg_0, arg_1) -> RelationshipAtom.lambda$getRoleRelationPlayerMap$54(relationPlayers, (Multimap)roleRelationPlayerMap, arg_0, arg_1));
        return roleRelationPlayerMap;
    }

    private Set<List<Pair<RelationPlayer, RelationPlayer>>> getRelationPlayerMappings(RelationshipAtom parentAtom) {
        return this.getRelationPlayerMappings(parentAtom, UnifierType.RULE);
    }

    private Set<List<Pair<RelationPlayer, RelationPlayer>>> getRelationPlayerMappings(RelationshipAtom parentAtom, UnifierComparison matchType) {
        Multimap<Role, RelationPlayer> childRoleRPMap = this.getRoleRelationPlayerMap();
        ImmutableMap childVarTypeMap = this.getParentQuery().getVarTypeMap();
        ImmutableMap parentVarTypeMap = parentAtom.getParentQuery().getVarTypeMap();
        ArrayList compatibleMappingsPerParentRP = new ArrayList();
        ReasonerQueryImpl childQuery = (ReasonerQueryImpl)this.getParentQuery();
        Set childRoles = childRoleRPMap.keySet();
        parentAtom.getRelationPlayers().stream().filter(prp -> prp.getRole().isPresent()).forEach(arg_0 -> this.lambda$getRelationPlayerMappings$62((Map)parentVarTypeMap, childRoles, childRoleRPMap, (Map)childVarTypeMap, matchType, childQuery, parentAtom, compatibleMappingsPerParentRP, arg_0));
        return Sets.cartesianProduct(compatibleMappingsPerParentRP).stream().filter(list -> !list.isEmpty()).filter(list -> {
            List listChildRps = list.stream().map(Pair::getKey).collect(Collectors.toList());
            return ReasonerUtils.subtract(listChildRps, this.getRelationPlayers()).isEmpty();
        }).filter(list -> {
            List listParentRps = list.stream().map(Pair::getValue).collect(Collectors.toList());
            return listParentRps.containsAll((Collection<?>)parentAtom.getRelationPlayers());
        }).collect(Collectors.toSet());
    }

    @Override
    public Unifier getUnifier(Atom pAtom) {
        return this.getMultiUnifier(pAtom, UnifierType.EXACT).getUnifier();
    }

    @Override
    public MultiUnifier getMultiUnifier(Atom pAtom, UnifierComparison unifierType) {
        Unifier baseUnifier = super.getUnifier(pAtom);
        HashSet<Unifier> unifiers = new HashSet<Unifier>();
        if (pAtom.isRelation()) {
            assert (pAtom instanceof RelationshipAtom);
            RelationshipAtom parentAtom = (RelationshipAtom)pAtom;
            if (this.equals(parentAtom) && this.getPartialSubstitutions().collect(Collectors.toSet()).equals(parentAtom.getPartialSubstitutions().collect(Collectors.toSet())) && this.getTypeConstraints().collect(Collectors.toSet()).equals(parentAtom.getTypeConstraints().collect(Collectors.toSet()))) {
                return new MultiUnifierImpl();
            }
            boolean unifyRoleVariables = parentAtom.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).anyMatch(rp -> rp.var().isUserDefinedName());
            this.getRelationPlayerMappings(parentAtom, unifierType).forEach(mappingList -> {
                HashMultimap varMappings = HashMultimap.create();
                mappingList.forEach(arg_0 -> RelationshipAtom.lambda$null$67((Multimap)varMappings, unifyRoleVariables, arg_0));
                unifiers.add(baseUnifier.merge((Unifier)new UnifierImpl((Multimap<Var, Var>)varMappings)));
            });
        } else {
            unifiers.add(baseUnifier);
        }
        return new MultiUnifierImpl(unifiers);
    }

    @Override
    public Stream<Answer> materialise() {
        RelationshipType relationType = this.getSchemaConcept().asRelationshipType();
        Multimap<Role, Var> roleVarMap = this.getRoleVarMap();
        Answer substitution = this.getParentQuery().getSubstitution();
        Relationship relationship = RelationshipTypeImpl.from((RelationshipType)relationType).addRelationshipInferred();
        roleVarMap.asMap().forEach((key, value) -> value.forEach(var -> relationship.addRolePlayer(key, substitution.get(var).asThing())));
        Answer relationSub = this.getRoleSubstitution().merge((Answer)(this.getVarName().isUserDefinedName() ? new QueryAnswer((Map<Var, Concept>)ImmutableMap.of((Object)this.getVarName(), (Object)relationship)) : new QueryAnswer()));
        return Stream.of(substitution.merge(relationSub));
    }

    private RelationshipAtom rewriteWithVariableRoles(Atom parentAtom) {
        if (!parentAtom.requiresRoleExpansion()) {
            return this;
        }
        VarPattern relVar = this.getPattern().admin().getProperty(IsaProperty.class).map(prop -> this.getVarName().isa((VarPattern)prop.type())).orElse((VarPattern)this.getVarName());
        for (RelationPlayer rp : this.getRelationPlayers()) {
            VarPatternAdmin rolePattern = rp.getRole().orElse(null);
            if (rolePattern != null) {
                Var roleVar = rolePattern.var();
                Label roleLabel = rolePattern.getTypeLabel().orElse(null);
                relVar = relVar.rel(roleVar.asUserDefined().label(roleLabel), (VarPattern)rp.getRolePlayer());
                continue;
            }
            relVar = relVar.rel((VarPattern)rp.getRolePlayer());
        }
        return new RelationshipAtom((VarPattern)relVar.admin(), this.getPredicateVariable(), this.getTypePredicate(), this.getParentQuery());
    }

    private RelationshipAtom rewriteWithRelationVariable(Atom parentAtom) {
        if (!parentAtom.getVarName().isUserDefinedName()) {
            return this;
        }
        return this.rewriteWithRelationVariable();
    }

    @Override
    public RelationshipAtom rewriteWithRelationVariable() {
        Var newVar = Graql.var().asUserDefined();
        VarPattern relVar = this.getPattern().admin().getProperty(IsaProperty.class).map(arg_0 -> RelationshipAtom.lambda$rewriteWithRelationVariable$72((VarPattern)newVar, arg_0)).orElse((VarPattern)newVar);
        for (RelationPlayer c : this.getRelationPlayers()) {
            VarPatternAdmin roleType = c.getRole().orElse(null);
            if (roleType != null) {
                relVar = relVar.rel((VarPattern)roleType, (VarPattern)c.getRolePlayer());
                continue;
            }
            relVar = relVar.rel((VarPattern)c.getRolePlayer());
        }
        return new RelationshipAtom((VarPattern)relVar.admin(), this.getPredicateVariable(), this.getTypePredicate(), this.getParentQuery());
    }

    @Override
    public RelationshipAtom rewriteWithTypeVariable() {
        return new RelationshipAtom(this.getPattern(), this.getPredicateVariable().asUserDefined(), this.getTypePredicate(), this.getParentQuery());
    }

    @Override
    public Atom rewriteToUserDefined(Atom parentAtom) {
        return this.rewriteWithRelationVariable(parentAtom).rewriteWithVariableRoles(parentAtom).rewriteWithTypeVariable(parentAtom);
    }

    private static /* synthetic */ VarPattern lambda$rewriteWithRelationVariable$72(VarPattern newVar, IsaProperty prop) {
        return newVar.isa((VarPattern)prop.type());
    }

    private static /* synthetic */ void lambda$null$67(Multimap varMappings, boolean unifyRoleVariables, Pair rpm) {
        varMappings.put((Object)((RelationPlayer)rpm.getKey()).getRolePlayer().var(), (Object)((RelationPlayer)rpm.getValue()).getRolePlayer().var());
        VarPattern childRolePattern = ((RelationPlayer)rpm.getKey()).getRole().orElse(null);
        VarPattern parentRolePattern = ((RelationPlayer)rpm.getValue()).getRole().orElse(null);
        if (parentRolePattern != null && childRolePattern != null && unifyRoleVariables) {
            varMappings.put((Object)childRolePattern.admin().var(), (Object)parentRolePattern.admin().var());
        }
    }

    private /* synthetic */ void lambda$getRelationPlayerMappings$62(Map parentVarTypeMap, Set childRoles, Multimap childRoleRPMap, Map childVarTypeMap, UnifierComparison matchType, ReasonerQueryImpl childQuery, RelationshipAtom parentAtom, List compatibleMappingsPerParentRP, RelationPlayer prp) {
        VarPatternAdmin parentRolePattern = prp.getRole().orElse(null);
        if (parentRolePattern == null) {
            throw GraqlQueryException.rolePatternAbsent((Atomic)this);
        }
        Label parentRoleLabel = parentRolePattern.getTypeLabel().orElse(null);
        if (parentRoleLabel != null) {
            Var parentRolePlayer = prp.getRolePlayer().var();
            Type parentType = (Type)parentVarTypeMap.get(parentRolePlayer);
            Set<Role> compatibleRoles = ReasonerUtils.compatibleRoles((Role)this.tx().getSchemaConcept(parentRoleLabel), parentType, childRoles);
            ArrayList compatibleRelationPlayers = new ArrayList();
            compatibleRoles.stream().filter(arg_0 -> ((Multimap)childRoleRPMap).containsKey(arg_0)).forEach(role -> childRoleRPMap.get(role).stream().filter(crp -> {
                Var childVar = crp.getRolePlayer().var();
                Type childType = (Type)childVarTypeMap.get(childVar);
                return matchType.typePlayability((ReasonerQuery)childQuery, childVar, parentType) && matchType.typeCompatibility(parentType, childType);
            }).filter(crp -> {
                IdPredicate parentId = parentAtom.getIdPredicate(prp.getRolePlayer().var());
                IdPredicate childId = this.getIdPredicate(crp.getRolePlayer().var());
                return matchType.atomicCompatibility((Atomic)parentId, (Atomic)childId);
            }).filter(crp -> {
                ValuePredicate parentVP = parentAtom.getPredicate(prp.getRolePlayer().var(), ValuePredicate.class);
                ValuePredicate childVP = this.getPredicate(crp.getRolePlayer().var(), ValuePredicate.class);
                return matchType.atomicCompatibility((Atomic)parentVP, (Atomic)childVP);
            }).forEach(compatibleRelationPlayers::add));
            if (!compatibleRelationPlayers.isEmpty()) {
                compatibleMappingsPerParentRP.add(compatibleRelationPlayers.stream().map(crp -> new Pair<RelationPlayer, RelationPlayer>((RelationPlayer)crp, prp)).collect(Collectors.toSet()));
            }
        } else {
            compatibleMappingsPerParentRP.add(this.getRelationPlayers().stream().map(crp -> new Pair<RelationPlayer, RelationPlayer>((RelationPlayer)crp, prp)).collect(Collectors.toSet()));
        }
    }

    private static /* synthetic */ void lambda$getRoleRelationPlayerMap$54(List relationPlayers, Multimap roleRelationPlayerMap, Role role, Collection value) {
        Label roleLabel = role.getLabel();
        relationPlayers.stream().filter(rp -> rp.getRole().isPresent()).forEach(rp -> {
            Label rl;
            VarPatternAdmin roleTypeVar = rp.getRole().orElse(null);
            Label label = rl = roleTypeVar != null ? (Label)roleTypeVar.getTypeLabel().orElse(null) : null;
            if (roleLabel != null && roleLabel.equals(rl)) {
                roleRelationPlayerMap.put((Object)role, rp);
            }
        });
    }

    private static /* synthetic */ void lambda$inferRoles$46(Map varTypeMap, Map mappings, Set possibleRoles, RelationPlayer rp) {
        Var varName = rp.getRolePlayer().var();
        Type type = (Type)varTypeMap.get(varName);
        mappings.put(rp, ReasonerUtils.top(type != null ? ReasonerUtils.compatibleRoles(type, possibleRoles) : possibleRoles));
    }

    private static /* synthetic */ boolean lambda$inferPossibleTypes$24(Set untypedRoleplayers, RelationshipAtom at) {
        return !Sets.intersection(at.getVarNames(), (Set)untypedRoleplayers).isEmpty();
    }

    private static /* synthetic */ void lambda$inferPossibleRelationConfigurations$23(Multimap compatibleTypes, RelationshipType rt) {
        compatibleTypes.putAll((Object)rt, (Iterable)rt.relates().collect(Collectors.toSet()));
    }

    private static /* synthetic */ void lambda$getRoleTypeMap$19(ImmutableMultimap.Builder builder, Map varTypeMap, Map.Entry e) {
        builder.put(e.getKey(), varTypeMap.get(e.getValue()));
    }

    private static /* synthetic */ Label lambda$getRoleTypeMap$18(Map varTypeMap, Map.Entry e) {
        return ((Type)varTypeMap.get(e.getValue())).getLabel();
    }

    private static /* synthetic */ boolean lambda$getRoleTypeMap$17(Map varTypeMap, Map.Entry e) {
        return varTypeMap.containsKey(e.getValue());
    }
}

