/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary.type;

import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.kb.internal.concept.EntityTypeImpl;
import ai.grakn.util.CommonUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IsaAtom
extends TypeAtom {
    public IsaAtom(VarPattern pattern, Var predicateVar, IdPredicate p, ReasonerQuery par) {
        super(pattern, predicateVar, p, par);
    }

    public IsaAtom(Var var, Var predicateVar, SchemaConcept type, ReasonerQuery par) {
        this(var, predicateVar, new IdPredicate(predicateVar, type.getLabel(), par), par);
    }

    private IsaAtom(Var var, Var predicateVar, IdPredicate p, ReasonerQuery par) {
        this((VarPattern)var.isa((VarPattern)predicateVar).admin(), predicateVar, p, par);
    }

    protected IsaAtom(TypeAtom a) {
        super(a);
    }

    @Override
    public Class<? extends VarProperty> getVarPropertyClass() {
        return IsaProperty.class;
    }

    @Override
    public String toString() {
        String typeString = (this.getSchemaConcept() != null ? this.getSchemaConcept().getLabel() : "") + "(" + this.getVarName() + ")";
        return typeString + this.getPredicates().map(AtomicBase::toString).collect(Collectors.joining(""));
    }

    @Override
    public Atomic copy() {
        return new IsaAtom(this);
    }

    @Override
    protected Pattern createCombinedPattern() {
        if (this.getPredicateVariable().isUserDefinedName()) {
            return super.createCombinedPattern();
        }
        return this.getSchemaConcept() != null ? this.getVarName().isa(this.getSchemaConcept().getLabel().getValue()) : this.getVarName().isa((VarPattern)this.getPredicateVariable());
    }

    protected Pair<VarPattern, IdPredicate> getTypedPair(SchemaConcept type) {
        ConceptId typeId = type.getId();
        Var typeVariable = this.getPredicateVariable().getValue().isEmpty() ? Graql.var().asUserDefined() : this.getPredicateVariable();
        IdPredicate newPredicate = new IdPredicate((VarPattern)typeVariable.id(typeId).admin(), this.getParentQuery());
        return new Pair<VarPattern, IdPredicate>(this.getPattern(), newPredicate);
    }

    @Override
    public IsaAtom addType(SchemaConcept type) {
        if (this.getTypeId() != null) {
            return this;
        }
        Pair<VarPattern, IdPredicate> typedPair = this.getTypedPair(type);
        return new IsaAtom(typedPair.getKey(), typedPair.getValue().getVarName(), typedPair.getValue(), this.getParentQuery());
    }

    private IsaAtom inferEntityType(Answer sub) {
        if (this.getTypePredicate() != null) {
            return this;
        }
        if (sub.containsVar(this.getPredicateVariable())) {
            return this.addType((SchemaConcept)sub.get(this.getPredicateVariable()).asType());
        }
        return this;
    }

    private ImmutableList<Type> inferPossibleEntityTypes(Answer sub) {
        if (this.getSchemaConcept() != null) {
            return ImmutableList.of((Object)this.getSchemaConcept().asType());
        }
        if (sub.containsVar(this.getPredicateVariable())) {
            return ImmutableList.of((Object)sub.get(this.getPredicateVariable()).asType());
        }
        return (ImmutableList)this.tx().admin().getMetaConcept().subs().collect(CommonUtil.toImmutableList());
    }

    @Override
    public IsaAtom inferTypes(Answer sub) {
        return this.inferEntityType(sub);
    }

    @Override
    public List<Atom> atomOptions(Answer sub) {
        return this.inferPossibleEntityTypes(sub).stream().map(this::addType).sorted(Comparator.comparing(Atom::isRuleResolvable)).collect(Collectors.toList());
    }

    @Override
    public Stream<Answer> materialise() {
        EntityType entityType = this.getSchemaConcept().asEntityType();
        return Stream.of(this.getParentQuery().getSubstitution().merge((Answer)new QueryAnswer((Map<Var, Concept>)ImmutableMap.of((Object)this.getVarName(), (Object)EntityTypeImpl.from((EntityType)entityType).addEntityInferred()))));
    }

    @Override
    public Set<TypeAtom> unify(Unifier u) {
        Collection vars = u.get(this.getVarName());
        return vars.isEmpty() ? Collections.singleton(this) : vars.stream().map(v -> new IsaAtom((Var)v, this.getPredicateVariable(), this.getTypePredicate(), this.getParentQuery())).collect(Collectors.toSet());
    }

    @Override
    public Atom rewriteWithTypeVariable() {
        return new IsaAtom(this.getPattern(), this.getPredicateVariable().asUserDefined(), this.getTypePredicate(), this.getParentQuery());
    }

    @Override
    public Atom rewriteToUserDefined(Atom parentAtom) {
        return parentAtom.getPredicateVariable().isUserDefinedName() ? this.rewriteWithTypeVariable() : this;
    }
}

