/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.predicate;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;

public class IdPredicate
extends Predicate<ConceptId> {
    public IdPredicate(VarPattern pattern, ReasonerQuery par) {
        super(pattern, par);
    }

    public IdPredicate(Var varName, Label label, ReasonerQuery par) {
        super(IdPredicate.createIdVar(varName.asUserDefined(), label, par.tx()), par);
    }

    public IdPredicate(Var varName, ConceptId id, ReasonerQuery par) {
        super(IdPredicate.createIdVar(varName.asUserDefined(), id), par);
    }

    public IdPredicate(Var varName, Concept con, ReasonerQuery par) {
        super(IdPredicate.createIdVar(varName.asUserDefined(), con.getId()), par);
    }

    private IdPredicate(IdPredicate a) {
        super(a);
    }

    @Override
    public void checkValid() {
        ConceptId conceptId = (ConceptId)this.getPredicate();
        if (this.tx().getConcept(conceptId) == null) {
            throw GraqlQueryException.idNotFound((ConceptId)conceptId);
        }
    }

    @Override
    public String toString() {
        return "[" + this.getVarName() + "/" + this.getPredicateValue() + "]";
    }

    @Override
    public Atomic copy() {
        return new IdPredicate(this);
    }

    @Override
    public String getPredicateValue() {
        return ((ConceptId)this.getPredicate()).getValue();
    }

    @Override
    protected ConceptId extractPredicate(VarPattern var) {
        return var.admin().getProperty(IdProperty.class).map(IdProperty::id).orElse(null);
    }

    private static VarPattern createIdVar(Var varName, ConceptId typeId) {
        return varName.id(typeId);
    }

    private static VarPattern createIdVar(Var varName, Label label, GraknTx graph) {
        SchemaConcept schemaConcept = graph.getSchemaConcept(label);
        if (schemaConcept == null) {
            throw GraqlQueryException.labelNotFound((Label)label);
        }
        return varName.id(schemaConcept.getId());
    }
}

