/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.cache;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.cache.CacheEntry;
import ai.grakn.graql.internal.reasoner.explanation.LookupExplanation;
import ai.grakn.graql.internal.reasoner.iterator.LazyAnswerIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LazyQueryCache<Q extends ReasonerQueryImpl>
extends Cache<Q, LazyAnswerIterator> {
    @Override
    public LazyAnswerIterator record(Q query, LazyAnswerIterator answers) {
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            Q equivalentQuery = match.query();
            Stream<Answer> unifiedStream = answers.unify(((ReasonerQueryImpl)query).getMultiUnifier((ReasonerQuery)equivalentQuery)).stream();
            this.putEntry(match.query(), ((LazyAnswerIterator)match.cachedElement()).merge(unifiedStream));
            return this.getAnswerIterator(query);
        }
        this.putEntry(query, answers);
        return answers;
    }

    @Override
    public Stream<Answer> record(Q query, Stream<Answer> answers) {
        return this.recordRetrieveLazy(query, answers).stream();
    }

    public LazyAnswerIterator recordRetrieveLazy(Q query, Stream<Answer> answers) {
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            Q equivalentQuery = match.query();
            MultiUnifier multiUnifier = ((ReasonerQueryImpl)query).getMultiUnifier((ReasonerQuery)equivalentQuery);
            Stream<Answer> unifiedStream = answers.flatMap(a -> a.unify(multiUnifier));
            this.putEntry(match.query(), ((LazyAnswerIterator)match.cachedElement()).merge(unifiedStream));
            return this.getAnswerIterator(query);
        }
        LazyAnswerIterator liter = new LazyAnswerIterator(answers);
        this.putEntry(query, liter);
        return liter;
    }

    @Override
    public LazyAnswerIterator getAnswers(Q query) {
        return this.getAnswersWithUnifier(query).getKey();
    }

    @Override
    public Pair<LazyAnswerIterator, MultiUnifier> getAnswersWithUnifier(Q query) {
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            Q equivalentQuery = match.query();
            MultiUnifier multiUnifier = ((ReasonerQueryImpl)equivalentQuery).getMultiUnifier((ReasonerQuery)query);
            LazyAnswerIterator unified = ((LazyAnswerIterator)match.cachedElement()).unify(multiUnifier);
            return new Pair<LazyAnswerIterator, MultiUnifier>(unified, multiUnifier);
        }
        Stream<Answer> answerStream = this.record(query, ((ReasonerQueryImpl)query).getQuery().stream().map(a -> a.explain((AnswerExplanation)new LookupExplanation((ReasonerQuery)query))));
        return new Pair<LazyAnswerIterator, MultiUnifier>(new LazyAnswerIterator(answerStream), new MultiUnifierImpl());
    }

    @Override
    public Stream<Answer> getAnswerStream(Q query) {
        return this.getAnswerStreamWithUnifier(query).getKey();
    }

    @Override
    public Pair<Stream<Answer>, MultiUnifier> getAnswerStreamWithUnifier(Q query) {
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            Q equivalentQuery = match.query();
            MultiUnifier multiUnifier = ((ReasonerQueryImpl)equivalentQuery).getMultiUnifier((ReasonerQuery)query);
            Stream unified = ((LazyAnswerIterator)match.cachedElement()).stream().flatMap(a -> a.unify(multiUnifier));
            return new Pair<Stream<Answer>, MultiUnifier>(unified, multiUnifier);
        }
        Stream<Answer> answerStream = this.record(query, ((ReasonerQueryImpl)query).getQuery().stream().map(a -> a.explain((AnswerExplanation)new LookupExplanation((ReasonerQuery)query))));
        return new Pair<Stream<Answer>, MultiUnifier>(answerStream, new MultiUnifierImpl());
    }

    public LazyAnswerIterator getAnswerIterator(Q query) {
        return this.getAnswers((ReasonerQueryImpl)query);
    }

    public long answerSize(Set<Q> queries) {
        return this.entries().stream().filter(p -> queries.contains(p.query())).map(v -> ((LazyAnswerIterator)v.cachedElement()).size()).mapToLong(Long::longValue).sum();
    }

    @Override
    public void remove(Cache<Q, LazyAnswerIterator> c2, Set<Q> queries) {
        c2.getQueries().stream().filter(queries::contains).filter(this::contains).forEach(q -> {
            CacheEntry match = this.getEntry(q);
            Set s = ((LazyAnswerIterator)match.cachedElement()).stream().collect(Collectors.toSet());
            s.removeAll(c2.getAnswerStream(q).collect(Collectors.toSet()));
            this.putEntry(match.query(), new LazyAnswerIterator(s.stream()));
        });
    }

    public void reload() {
        HashMap newCache = new HashMap();
        this.entries().forEach(entry -> newCache.put(entry.query(), new CacheEntry(entry.query(), new LazyAnswerIterator(((LazyAnswerIterator)entry.cachedElement()).stream().collect(Collectors.toSet()).stream()))));
        this.clear();
        this.putAll(newCache);
    }
}

