/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.cache;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.cache.CacheEntry;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryCache<Q extends ReasonerQueryImpl>
extends Cache<Q, QueryAnswers> {
    @Override
    public QueryAnswers record(Q query, QueryAnswers answers) {
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            Q equivalentQuery = match.query();
            QueryAnswers unifiedAnswers = answers.unify(((ReasonerQueryImpl)query).getMultiUnifier((ReasonerQuery)equivalentQuery));
            ((QueryAnswers)this.getEntry(query).cachedElement()).addAll(unifiedAnswers);
            return this.getAnswers((ReasonerQueryImpl)query);
        }
        this.putEntry(query, answers);
        return answers;
    }

    @Override
    public Stream<Answer> record(Q query, Stream<Answer> answerStream) {
        QueryAnswers newAnswers = new QueryAnswers(answerStream.collect(Collectors.toSet()));
        return this.record(query, newAnswers).stream();
    }

    public Answer recordAnswer(Q query, Answer answer) {
        if (answer.isEmpty()) {
            return answer;
        }
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            Q equivalentQuery = match.query();
            QueryAnswers answers = (QueryAnswers)match.cachedElement();
            MultiUnifier multiUnifier = ((ReasonerQueryImpl)query).getMultiUnifier((ReasonerQuery)equivalentQuery);
            answer.unify(multiUnifier).forEach(answers::add);
        } else {
            this.putEntry(query, new QueryAnswers(answer));
        }
        return answer;
    }

    public Answer recordAnswerWithUnifier(Q query, Answer answer, MultiUnifier unifier) {
        if (answer.isEmpty()) {
            return answer;
        }
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            QueryAnswers answers = (QueryAnswers)match.cachedElement();
            answer.unify(unifier).forEach(answers::add);
        } else {
            this.putEntry(query, new QueryAnswers(answer));
        }
        return answer;
    }

    @Override
    public QueryAnswers getAnswers(Q query) {
        return this.getAnswersWithUnifier(query).getKey();
    }

    @Override
    public Stream<Answer> getAnswerStream(Q query) {
        return this.getAnswerStreamWithUnifier(query).getKey();
    }

    @Override
    public Pair<QueryAnswers, MultiUnifier> getAnswersWithUnifier(Q query) {
        Pair<Stream<Answer>, MultiUnifier> answerStreamWithUnifier = this.getAnswerStreamWithUnifier(query);
        return new Pair<QueryAnswers, MultiUnifier>(new QueryAnswers(answerStreamWithUnifier.getKey().collect(Collectors.toSet())), answerStreamWithUnifier.getValue());
    }

    @Override
    public Pair<Stream<Answer>, MultiUnifier> getAnswerStreamWithUnifier(Q query) {
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            Q equivalentQuery = match.query();
            QueryAnswers answers = (QueryAnswers)match.cachedElement();
            MultiUnifier multiUnifier = ((ReasonerQueryImpl)equivalentQuery).getMultiUnifier((ReasonerQuery)query);
            return new Pair<Stream<Answer>, MultiUnifier>(answers.unify(multiUnifier).stream(), multiUnifier);
        }
        return new Pair<Stream<Answer>, MultiUnifier>(this.structuralCache().get(query), new MultiUnifierImpl());
    }

    public Answer getAnswer(Q query, Answer ans) {
        List answers;
        if (ans.isEmpty()) {
            return ans;
        }
        CacheEntry match = this.getEntry(query);
        if (match != null) {
            Q equivalentQuery = match.query();
            MultiUnifier multiUnifier = ((ReasonerQueryImpl)equivalentQuery).getMultiUnifier((ReasonerQuery)query);
            Answer answer = ((QueryAnswers)match.cachedElement()).stream().flatMap(a -> a.unify(multiUnifier)).filter(a -> a.containsAll(ans)).findFirst().orElse(null);
            if (answer != null) {
                return answer;
            }
        }
        return (answers = (List)ReasonerQueries.create(query, ans).getQuery().execute()).isEmpty() ? new QueryAnswer() : (Answer)answers.iterator().next();
    }

    @Override
    public void remove(Cache<Q, QueryAnswers> c2, Set<Q> queries) {
        c2.getQueries().stream().filter(queries::contains).filter(this::contains).forEach(q -> ((QueryAnswers)this.getEntry(q).cachedElement()).removeAll((QueryAnswers)c2.getAnswers(q)));
    }
}

