/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.cache;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.graql.internal.gremlin.GreedyTraversalPlan;
import ai.grakn.graql.internal.query.match.MatchBase;
import ai.grakn.graql.internal.reasoner.UnifierType;
import ai.grakn.graql.internal.reasoner.cache.CacheEntry;
import ai.grakn.graql.internal.reasoner.explanation.LookupExplanation;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryEquivalence;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import com.google.common.base.Equivalence;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

class StructuralCache<Q extends ReasonerQueryImpl> {
    private final Equivalence<ReasonerQuery> equivalence = ReasonerQueryEquivalence.StructuralEquivalence;
    private final Map<Equivalence.Wrapper<Q>, CacheEntry<Q, GraqlTraversal>> structCache = new HashMap<Equivalence.Wrapper<Q>, CacheEntry<Q, GraqlTraversal>>();

    StructuralCache() {
    }

    public Stream<Answer> get(Q query) {
        Equivalence.Wrapper structQuery = this.equivalence.wrap(query);
        GraknTx tx = ((ReasonerQueryImpl)query).tx();
        CacheEntry<Q, GraqlTraversal> match = this.structCache.get(structQuery);
        if (match != null) {
            Q equivalentQuery = match.query();
            GraqlTraversal traversal = match.cachedElement();
            Unifier unifier = ((ReasonerQueryImpl)equivalentQuery).getMultiUnifier((ReasonerQuery)query, UnifierType.STRUCTURAL).getAny();
            Map<Var, ConceptId> idTransform = ((ReasonerQueryImpl)equivalentQuery).idTransform((ReasonerQueryImpl)query, unifier);
            ReasonerQueryImpl transformedQuery = ((ReasonerQueryImpl)equivalentQuery).transformIds(idTransform);
            return MatchBase.streamWithTraversal(transformedQuery.getPattern().commonVars(), tx, traversal.transform(idTransform)).map(ans -> ans.unify(unifier)).map(a -> a.explain((AnswerExplanation)new LookupExplanation((ReasonerQuery)query)));
        }
        GraqlTraversal traversal = GreedyTraversalPlan.createTraversal(((ReasonerQueryImpl)query).getPattern(), tx);
        this.structCache.put(structQuery, new CacheEntry<Q, GraqlTraversal>(query, traversal));
        return MatchBase.streamWithTraversal(((ReasonerQueryImpl)query).getPattern().commonVars(), tx, traversal).map(a -> a.explain((AnswerExplanation)new LookupExplanation((ReasonerQuery)query)));
    }
}

