/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.plan;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.graql.internal.gremlin.GreedyTraversalPlan;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.binary.OntologicalAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraqlTraversalPlanner {
    public static ImmutableList<Atom> refinedPlan(ReasonerQueryImpl query) {
        List<Atom> startCandidates = query.getAtoms(Atom.class).filter(Atomic::isSelectable).collect(Collectors.toList());
        Set<IdPredicate> subs = query.getAtoms(IdPredicate.class).collect(Collectors.toSet());
        return ImmutableList.copyOf(GraqlTraversalPlanner.refinedPlan(query, startCandidates, subs));
    }

    private static Atom optimalCandidate(List<Atom> candidates) {
        return candidates.stream().sorted(Comparator.comparing(at -> !at.isGround())).sorted(Comparator.comparing(at -> -at.getPredicates().count())).findFirst().orElse(null);
    }

    private static List<Atom> refinedPlan(ReasonerQueryImpl query, List<Atom> atoms, Set<IdPredicate> subs) {
        ImmutableList<Atom> initialPlan;
        List<Atom> candidates = subs.isEmpty() ? atoms : atoms.stream().filter(at -> at.getPredicates(IdPredicate.class).findFirst().isPresent()).collect(Collectors.toList());
        if (candidates.contains((initialPlan = GraqlTraversalPlanner.planFromTraversal(atoms, GraqlTraversalPlanner.atomsToPattern(atoms, subs), query.tx())).get(0)) || candidates.isEmpty()) {
            return initialPlan;
        }
        Atom first = GraqlTraversalPlanner.optimalCandidate(candidates);
        ArrayList<Atom> atomsToPlan = new ArrayList<Atom>(atoms);
        atomsToPlan.remove(first);
        Set extraSubs = first.getVarNames().stream().filter(v -> subs.stream().noneMatch(s -> s.getVarName().equals(v))).map(v -> new IdPredicate((Var)v, ConceptId.of((String)"placeholderId"), (ReasonerQuery)query)).collect(Collectors.toSet());
        return Stream.concat(Stream.of(first), GraqlTraversalPlanner.refinedPlan(query, atomsToPlan, (Set<IdPredicate>)Sets.union(subs, extraSubs)).stream()).collect(Collectors.toList());
    }

    private static Conjunction<PatternAdmin> atomsToPattern(List<Atom> atoms, Set<IdPredicate> subs) {
        return Patterns.conjunction(Stream.concat(atoms.stream().flatMap(at -> Stream.concat(Stream.of(at), at.getNonSelectableConstraints())), subs.stream()).map(Atomic::getCombinedPattern).flatMap(p -> p.admin().varPatterns().stream()).collect(Collectors.toSet()));
    }

    static ImmutableList<Atom> planFromTraversal(List<Atom> atoms, PatternAdmin queryPattern, GraknTx tx) {
        HashMultimap propertyMap = HashMultimap.create();
        atoms.stream().filter(at -> !(at instanceof OntologicalAtom)).forEach(arg_0 -> GraqlTraversalPlanner.lambda$planFromTraversal$10((Multimap)propertyMap, arg_0));
        Set properties = propertyMap.keySet();
        GraqlTraversal graqlTraversal = GreedyTraversalPlan.createTraversal(queryPattern, tx);
        ImmutableList fragments = (ImmutableList)graqlTraversal.fragments().iterator().next();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(atoms.stream().filter(at -> at instanceof OntologicalAtom).iterator());
        builder.addAll(fragments.stream().map(Fragment::varProperty).filter(Objects::nonNull).filter(properties::contains).distinct().flatMap(arg_0 -> GraqlTraversalPlanner.lambda$planFromTraversal$12((Multimap)propertyMap, arg_0)).distinct().iterator());
        return builder.build();
    }

    private static /* synthetic */ Stream lambda$planFromTraversal$12(Multimap propertyMap, VarProperty p) {
        return propertyMap.get((Object)p).stream();
    }

    private static /* synthetic */ void lambda$planFromTraversal$10(Multimap propertyMap, Atom at) {
        at.getVarProperties().forEach(p -> propertyMap.put(p, (Object)at));
    }
}

