/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.plan;

import ai.grakn.GraknTx;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.plan.GraqlTraversalPlanner;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;

public final class ResolutionPlan {
    private final ImmutableList<Atom> plan;
    private final GraknTx tx;

    public ResolutionPlan(ReasonerQueryImpl query) {
        this.tx = query.tx();
        this.plan = GraqlTraversalPlanner.refinedPlan(query);
        if (!this.isValid()) {
            throw GraqlQueryException.nonGroundNeqPredicate((ReasonerQuery)query);
        }
    }

    public String toString() {
        return this.plan.stream().map(AtomicBase::toString).collect(Collectors.joining("\n"));
    }

    public ImmutableList<Atom> plan() {
        return this.plan;
    }

    private boolean isValid() {
        HashSet nonGroundPredicates = new HashSet();
        HashSet<Var> mappedVars = new HashSet<Var>();
        for (Atom atom : this.plan) {
            mappedVars.addAll(atom.getVarNames());
            atom.getPredicates(NeqPredicate.class).forEach(neq -> {
                if (!mappedVars.containsAll(neq.getVarNames()) && !atom.getVarNames().containsAll(neq.getVarNames())) {
                    nonGroundPredicates.add(neq);
                } else if (nonGroundPredicates.contains(neq)) {
                    nonGroundPredicates.remove(neq);
                }
            });
        }
        return nonGroundPredicates.isEmpty();
    }

    public LinkedList<ReasonerQueryImpl> queryPlan() {
        LinkedList<ReasonerQueryImpl> queries = new LinkedList<ReasonerQueryImpl>();
        LinkedList<Atom> atoms = new LinkedList<Atom>((Collection<Atom>)this.plan);
        ArrayList<Atom> nonResolvableAtoms = new ArrayList<Atom>();
        while (!atoms.isEmpty()) {
            Atom top = atoms.remove();
            if (top.isRuleResolvable()) {
                if (!nonResolvableAtoms.isEmpty()) {
                    queries.add(ReasonerQueries.create(nonResolvableAtoms, this.tx));
                    nonResolvableAtoms.clear();
                }
                queries.add(ReasonerQueries.atomic(top));
                continue;
            }
            nonResolvableAtoms.add(top);
            if (!atoms.isEmpty()) continue;
            queries.add(ReasonerQueries.create(nonResolvableAtoms, this.tx));
        }
        return queries;
    }
}

