/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.concept.Concept;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.iterator.LazyAnswerIterator;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class QueryAnswerStream {
    static boolean knownFilterWithInverse(Answer answer, Map<Pair<Var, Concept>, Set<Answer>> stream2InverseMap) {
        Iterator eit = answer.entrySet().iterator();
        Map.Entry entry = (Map.Entry)eit.next();
        Sets.SetView matchAnswers = QueryAnswerStream.findMatchingAnswers((Var)entry.getKey(), (Concept)entry.getValue(), stream2InverseMap);
        while (eit.hasNext()) {
            entry = (Map.Entry)eit.next();
            matchAnswers = Sets.intersection(matchAnswers, QueryAnswerStream.findMatchingAnswers((Var)entry.getKey(), (Concept)entry.getValue(), stream2InverseMap));
        }
        for (Answer knownAnswer : matchAnswers) {
            if (!knownAnswer.entrySet().containsAll(answer.entrySet())) continue;
            return false;
        }
        return true;
    }

    static boolean nonEqualsFilter(Answer answer, Set<NeqPredicate> atoms) {
        if (atoms.isEmpty()) {
            return true;
        }
        for (NeqPredicate atom : atoms) {
            if (NeqPredicate.notEqualsOperator(answer, atom)) continue;
            return false;
        }
        return true;
    }

    static boolean entityTypeFilter(Answer answer, Set<TypeAtom> types) {
        if (types.isEmpty()) {
            return true;
        }
        for (TypeAtom type : types) {
            Var var = type.getVarName();
            SchemaConcept t = type.getSchemaConcept();
            if (!t.subs().noneMatch(sub -> sub.equals(answer.get(var).asThing().type()))) continue;
            return false;
        }
        return true;
    }

    private static Set<Answer> findMatchingAnswers(Var var, Concept con, Map<Pair<Var, Concept>, Set<Answer>> inverseMap) {
        Pair<Var, Concept> key = new Pair<Var, Concept>(var, con);
        return inverseMap.containsKey(key) ? inverseMap.get(key) : new HashSet();
    }

    private static Set<Answer> findMatchingAnswers(Answer answer, Map<Pair<Var, Concept>, Set<Answer>> inverseMap, Var joinVar) {
        Pair<Var, Concept> key = new Pair<Var, Concept>(joinVar, answer.get(joinVar));
        return inverseMap.containsKey(key) ? inverseMap.get(key) : new HashSet();
    }

    public static Stream<Answer> join(Stream<Answer> stream, Stream<Answer> stream2, ImmutableSet<Var> joinVars) {
        LazyAnswerIterator l2 = new LazyAnswerIterator(stream2);
        return stream.flatMap(a1 -> {
            Stream<Object> answerStream = l2.stream();
            answerStream = answerStream.filter(ans -> {
                for (Var v : joinVars) {
                    if (ans.get(v).equals(a1.get(v))) continue;
                    return false;
                }
                return true;
            });
            return answerStream.map(a -> a.merge(a1));
        });
    }

    static Stream<Answer> joinWithInverse(Stream<Answer> stream, Stream<Answer> stream2, Map<Pair<Var, Concept>, Set<Answer>> stream2InverseMap, ImmutableSet<Var> joinVars) {
        if (joinVars.isEmpty()) {
            LazyAnswerIterator l2 = new LazyAnswerIterator(stream2);
            return stream.flatMap(a1 -> l2.stream().map(a -> a.merge(a1)));
        }
        return stream.flatMap(a1 -> {
            UnmodifiableIterator vit = joinVars.iterator();
            Sets.SetView matchAnswers = QueryAnswerStream.findMatchingAnswers(a1, stream2InverseMap, (Var)vit.next());
            while (vit.hasNext()) {
                matchAnswers = Sets.intersection(matchAnswers, QueryAnswerStream.findMatchingAnswers(a1, stream2InverseMap, (Var)vit.next()));
            }
            return matchAnswers.stream().map(a -> a.merge(a1));
        });
    }
}

