/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.UnifierComparison;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.cache.LazyQueryCache;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.explanation.RuleExplanation;
import ai.grakn.graql.internal.reasoner.iterator.ReasonerQueryIterator;
import ai.grakn.graql.internal.reasoner.query.QueryAnswerStream;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.state.AnswerState;
import ai.grakn.graql.internal.reasoner.state.AtomicStateProducer;
import ai.grakn.graql.internal.reasoner.state.QueryStateBase;
import ai.grakn.graql.internal.reasoner.state.ResolutionState;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class ReasonerAtomicQuery
extends ReasonerQueryImpl {
    private final Atom atom = this.selectAtoms().stream().findFirst().orElse(null);
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerAtomicQuery.class);

    ReasonerAtomicQuery(Conjunction<VarPatternAdmin> pattern, GraknTx tx) {
        super(pattern, tx);
    }

    ReasonerAtomicQuery(ReasonerQueryImpl query) {
        super(query);
    }

    ReasonerAtomicQuery(Atom at) {
        super(at);
    }

    ReasonerAtomicQuery(Set<Atomic> atoms, GraknTx tx) {
        super(atoms, tx);
    }

    @Override
    public ReasonerQuery copy() {
        return new ReasonerAtomicQuery(this);
    }

    @Override
    public ReasonerAtomicQuery withSubstitution(Answer sub) {
        return new ReasonerAtomicQuery((Set<Atomic>)Sets.union(this.getAtoms(), (Set)sub.toPredicates((ReasonerQuery)this)), this.tx());
    }

    @Override
    public ReasonerAtomicQuery inferTypes() {
        return new ReasonerAtomicQuery(this.getAtoms().stream().map(Atomic::inferTypes).collect(Collectors.toSet()), this.tx());
    }

    @Override
    public ReasonerAtomicQuery positive() {
        return new ReasonerAtomicQuery(this.getAtoms().stream().filter(at -> !(at instanceof NeqPredicate)).collect(Collectors.toSet()), this.tx());
    }

    @Override
    public String toString() {
        return this.getAtoms(Atom.class).map(Object::toString).collect(Collectors.joining(", "));
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    public Atom getAtom() {
        return this.atom;
    }

    @Override
    public Set<Atom> selectAtoms() {
        Set<Atom> selectedAtoms = super.selectAtoms();
        if (selectedAtoms.size() != 1) {
            throw GraqlQueryException.nonAtomicQuery((ReasonerQuery)this);
        }
        return selectedAtoms;
    }

    @Override
    public MultiUnifier getMultiUnifier(ReasonerQuery p, UnifierComparison unifierType) {
        if (p == this) {
            return new MultiUnifierImpl();
        }
        Preconditions.checkArgument((boolean)(p instanceof ReasonerAtomicQuery));
        ReasonerAtomicQuery parent = (ReasonerAtomicQuery)p;
        MultiUnifier multiUnifier = this.getAtom().getMultiUnifier(parent.getAtom(), unifierType);
        Set<TypeAtom> childTypes = this.getAtom().getTypeConstraints().collect(Collectors.toSet());
        if (childTypes.isEmpty()) {
            return multiUnifier;
        }
        Set<TypeAtom> parentTypes = parent.getAtom().getTypeConstraints().collect(Collectors.toSet());
        if (multiUnifier.isEmpty()) {
            return new MultiUnifierImpl(ReasonerUtils.typeUnifier(childTypes, parentTypes, new UnifierImpl()));
        }
        Set<Unifier> unifiers = multiUnifier.unifiers().stream().map(unifier -> ReasonerUtils.typeUnifier(childTypes, parentTypes, unifier)).collect(Collectors.toSet());
        return new MultiUnifierImpl(unifiers);
    }

    public Stream<Answer> materialise(Answer answer) {
        return this.withSubstitution(answer).getAtom().materialise().map(ans -> ans.explain(answer.getExplanation()));
    }

    private Stream<Answer> getIdPredicateAnswerStream(Stream<Answer> stream) {
        Answer idPredicateAnswer = this.getSubstitution().merge(this.getRoleSubstitution());
        return stream.map(answer -> {
            AnswerExplanation exp = answer.getExplanation();
            return answer.merge(idPredicateAnswer).explain(exp);
        });
    }

    private Stream<Answer> getFilteredRuleAnswerStream(Stream<Answer> answers) {
        Set<Var> vars = this.getVarNames();
        Set<Var> roleExpansionVariables = this.getAtom().getRoleExpansionVariables();
        Set<TypeAtom> mappedTypeConstraints = this.atom.getSpecificTypeConstraints();
        return this.getIdPredicateAnswerStream(answers).filter(a -> QueryAnswerStream.entityTypeFilter(a, mappedTypeConstraints)).map(a -> a.project(vars)).flatMap(a -> a.expandHierarchies(roleExpansionVariables));
    }

    private Stream<Answer> resolveViaRule(InferenceRule rule, Unifier ruleUnifier, Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean differentialJoin) {
        LOG.trace("Applying rule " + rule.getRuleId());
        ReasonerQueryImpl ruleBody = rule.getBody();
        ReasonerAtomicQuery ruleHead = rule.getHead();
        Set<Var> varsToRetain = rule.hasDisconnectedHead() ? ruleBody.getVarNames() : ruleHead.getVarNames();
        subGoals.add(this);
        Stream<Object> answers = ruleBody.computeJoin(subGoals, cache, dCache, differentialJoin).map(a -> a.project(varsToRetain)).distinct().map(ans -> ans.explain((AnswerExplanation)new RuleExplanation((ReasonerQuery)this, rule)));
        if (!cache.contains(ruleHead)) {
            dCache.record(ruleHead, cache.getAnswerStream(ruleHead));
        }
        Map<Pair<Var, Concept>, Set<Answer>> known = cache.getInverseAnswerMap(ruleHead);
        Map<Pair<Var, Concept>, Set<Answer>> dknown = dCache.getInverseAnswerMap(ruleHead);
        answers = answers.filter(a -> QueryAnswerStream.knownFilterWithInverse(a, known)).filter(a -> QueryAnswerStream.knownFilterWithInverse(a, dknown)).flatMap(ruleHead::materialise);
        answers = dCache.record(ruleHead, answers);
        boolean isHeadEquivalent = this.isEquivalent(ruleHead);
        Set<Var> queryVars = this.getVarNames().size() < ruleHead.getVarNames().size() ? ruleUnifier.keySet() : ruleHead.getVarNames();
        answers = answers.map(a -> a.project(queryVars)).map(a -> a.unify(ruleUnifier)).filter(a -> !a.isEmpty());
        return isHeadEquivalent ? dCache.record(this, answers) : dCache.record(this, this.getFilteredRuleAnswerStream(answers));
    }

    Stream<Answer> answerStream(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean differentialJoin) {
        Stream<Answer> answerStream;
        boolean queryAdmissible = !subGoals.contains(this);
        LOG.trace("AQ: " + this);
        Stream<Answer> stream = answerStream = cache.contains(this) ? Stream.empty() : dCache.record(this, cache.getAnswerStream(this));
        if (queryAdmissible) {
            Iterator ruleIterator = this.getRuleStream().iterator();
            while (ruleIterator.hasNext()) {
                Pair ruleContext = (Pair)ruleIterator.next();
                Unifier unifier = (Unifier)ruleContext.getValue();
                Unifier unifierInverse = unifier.inverse();
                Answer sub = this.getSubstitution().unify(unifierInverse);
                InferenceRule rule = ((InferenceRule)ruleContext.getKey()).propagateConstraints(this.getAtom(), unifierInverse).withSubstitution(sub);
                Stream<Answer> localStream = this.resolveViaRule(rule, unifier, subGoals, cache, dCache, differentialJoin);
                answerStream = Stream.concat(answerStream, localStream);
            }
        }
        return dCache.record(this, answerStream);
    }

    @Override
    public Stream<Answer> resolveAndMaterialise(LazyQueryCache<ReasonerAtomicQuery> cache, LazyQueryCache<ReasonerAtomicQuery> dCache) {
        if (!this.getAtom().isRuleResolvable()) {
            return this.getQuery().stream().map(QueryAnswer::new);
        }
        return new QueryAnswerIterator(cache, dCache).hasStream();
    }

    @Override
    public ResolutionState subGoal(Answer sub, Unifier u, QueryStateBase parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        return new AtomicStateProducer(this, sub, u, parent, subGoals, cache);
    }

    @Override
    protected Stream<ReasonerQueryImpl> getQueryStream(Answer sub) {
        Atom atom = this.getAtom();
        return atom.getSchemaConcept() == null ? atom.atomOptions(sub).stream().map(ReasonerAtomicQuery::new) : Stream.of(this);
    }

    @Override
    public Pair<Iterator<ResolutionState>, MultiUnifier> queryStateIterator(QueryStateBase parent, Set<ReasonerAtomicQuery> visitedSubGoals, QueryCache<ReasonerAtomicQuery> cache) {
        Iterator subGoalIterator;
        Pair<Stream<Answer>, MultiUnifier> cacheEntry = cache.getAnswerStreamWithUnifier(this);
        MultiUnifier cacheUnifier = cacheEntry.getValue().inverse();
        Iterator dbIterator = cacheEntry.getKey().map(a -> a.explain(a.getExplanation().setQuery((ReasonerQuery)this))).map(ans -> new AnswerState((Answer)ans, parent.getUnifier(), parent)).iterator();
        if (visitedSubGoals.contains(this) || this.isGround() && dbIterator.hasNext()) {
            subGoalIterator = Collections.emptyIterator();
        } else {
            visitedSubGoals.add(this);
            subGoalIterator = this.getRuleStream().map(rulePair -> ((InferenceRule)rulePair.getKey()).subGoal(this.getAtom(), (Unifier)rulePair.getValue(), parent, visitedSubGoals, cache)).iterator();
        }
        return new Pair<Iterator<ResolutionState>, MultiUnifier>(Iterators.concat(dbIterator, subGoalIterator), cacheUnifier);
    }

    private Stream<Pair<InferenceRule, Unifier>> getRuleStream() {
        return this.getAtom().getApplicableRules().flatMap(r -> r.getMultiUnifier(this.getAtom()).stream().map(unifier -> new Pair<InferenceRule, Unifier>((InferenceRule)r, (Unifier)unifier))).sorted(Comparator.comparing(rt -> -((InferenceRule)rt.getKey()).resolutionPriority()));
    }

    private class QueryAnswerIterator
    extends ReasonerQueryIterator {
        private int iter = 0;
        private final Set<Answer> answers = new HashSet<Answer>();
        private final Set<ReasonerAtomicQuery> subGoals = new HashSet<ReasonerAtomicQuery>();
        private final LazyQueryCache<ReasonerAtomicQuery> cache;
        private final LazyQueryCache<ReasonerAtomicQuery> dCache;
        private Iterator<Answer> answerIterator;

        QueryAnswerIterator(LazyQueryCache<ReasonerAtomicQuery> cache, LazyQueryCache<ReasonerAtomicQuery> dCache) {
            this.cache = cache;
            this.dCache = dCache;
            this.answerIterator = this.query().answerStream(this.subGoals, cache, dCache, this.iter != 0).iterator();
        }

        private ReasonerAtomicQuery query() {
            return ReasonerAtomicQuery.this;
        }

        @Override
        public Stream<Answer> hasStream() {
            Iterable iterable = () -> this;
            return StreamSupport.stream(iterable.spliterator(), false).distinct();
        }

        private void computeNext() {
            ++this.iter;
            this.subGoals.clear();
            this.answerIterator = this.query().answerStream(this.subGoals, this.cache, this.dCache, this.iter != 0).iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.answerIterator.hasNext()) {
                return true;
            }
            this.updateCache();
            long dAns = this.differentialAnswerSize();
            if (dAns != 0L || this.iter == 0) {
                LOG.debug("Atom: " + this.query().getAtom() + " iter: " + this.iter + " answers: " + this.answers.size() + " dAns = " + dAns);
                this.computeNext();
                return this.answerIterator.hasNext();
            }
            return false;
        }

        private void updateCache() {
            this.dCache.remove(this.cache);
            this.cache.add(this.dCache);
            this.cache.reload();
        }

        @Override
        public Answer next() {
            Answer next = this.answerIterator.next();
            this.answers.add(next);
            return next;
        }

        private long differentialAnswerSize() {
            return this.dCache.answerSize(this.subGoals);
        }
    }
}

