/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import com.google.common.base.Equivalence;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class ReasonerQueryEquivalence
extends Equivalence<ReasonerQuery> {
    public static final Equivalence<ReasonerQuery> AlphaEquivalence = new ReasonerQueryEquivalence(){

        protected boolean doEquivalent(ReasonerQuery q1, ReasonerQuery q2) {
            return ReasonerQueryEquivalence.equivalence(q1, q2, Atomic::isAlphaEquivalent);
        }

        protected int doHash(ReasonerQuery q) {
            return ReasonerQueryEquivalence.equivalenceHash(q, Atomic.class, Atomic::alphaEquivalenceHashCode);
        }
    };
    public static final Equivalence<ReasonerQuery> StructuralEquivalence = new ReasonerQueryEquivalence(){

        protected boolean doEquivalent(ReasonerQuery q1, ReasonerQuery q2) {
            return ReasonerQueryEquivalence.equivalence(q1, q2, Atomic::isStructurallyEquivalent);
        }

        protected int doHash(ReasonerQuery q) {
            return ReasonerQueryEquivalence.equivalenceHash(q, Atom.class, Atomic::structuralEquivalenceHashCode);
        }
    };

    private static boolean equivalence(ReasonerQuery q1, ReasonerQuery q2, BiFunction<Atom, Atom, Boolean> equivalenceFunction) {
        return q1.getAtoms().size() == q2.getAtoms().size() && q1.getAtoms(Atom.class).allMatch(atom -> ReasonerQueryEquivalence.containsEquivalentAtom(q2, atom, equivalenceFunction));
    }

    private static <T extends Atomic> int equivalenceHash(ReasonerQuery q, Class<T> atomType, Function<Atomic, Integer> hashFunction) {
        int hashCode = 1;
        TreeSet hashes = new TreeSet();
        q.getAtoms(atomType).forEach(atom -> hashes.add(hashFunction.apply((Atomic)atom)));
        for (Integer hash : hashes) {
            hashCode = hashCode * 37 + hash;
        }
        return hashCode;
    }

    public static boolean containsEquivalentAtom(ReasonerQuery query, Atom atom, BiFunction<Atom, Atom, Boolean> equivalenceFunction) {
        return query.getAtoms(Atom.class).anyMatch(atom2 -> (Boolean)equivalenceFunction.apply(atom, (Atom)atom2));
    }
}

