/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.UnifierComparison;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.ResolutionIterator;
import ai.grakn.graql.internal.reasoner.UnifierType;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.binary.RelationshipAtom;
import ai.grakn.graql.internal.reasoner.atom.binary.type.IsaAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.cache.LazyQueryCache;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.explanation.JoinExplanation;
import ai.grakn.graql.internal.reasoner.plan.ResolutionPlan;
import ai.grakn.graql.internal.reasoner.query.QueryAnswerStream;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryEquivalence;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.rule.RuleUtils;
import ai.grakn.graql.internal.reasoner.state.AnswerState;
import ai.grakn.graql.internal.reasoner.state.ConjunctiveState;
import ai.grakn.graql.internal.reasoner.state.CumulativeState;
import ai.grakn.graql.internal.reasoner.state.QueryStateBase;
import ai.grakn.graql.internal.reasoner.state.ResolutionState;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReasonerQueryImpl
implements ReasonerQuery {
    private final GraknTx tx;
    private final ImmutableSet<Atomic> atomSet;
    private Answer substitution = null;
    private ImmutableMap<Var, Type> varTypeMap = null;
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerQueryImpl.class);

    ReasonerQueryImpl(Conjunction<VarPatternAdmin> pattern, GraknTx tx) {
        this.tx = tx;
        this.atomSet = ImmutableSet.builder().addAll(AtomicFactory.createAtoms(pattern, this).iterator()).build();
    }

    ReasonerQueryImpl(Set<Atomic> atoms, GraknTx tx) {
        this.tx = tx;
        this.atomSet = ImmutableSet.builder().addAll(atoms.stream().map(at -> AtomicFactory.create(at, this)).iterator()).build();
    }

    ReasonerQueryImpl(List<Atom> atoms, GraknTx tx) {
        this.tx = tx;
        this.atomSet = ImmutableSet.builder().addAll(atoms.stream().flatMap(at -> Stream.concat(Stream.of(at), at.getNonSelectableConstraints())).map(at -> AtomicFactory.create(at, this)).iterator()).build();
    }

    ReasonerQueryImpl(Atom atom) {
        this(Collections.singletonList(atom), atom.getParentQuery().tx());
    }

    ReasonerQueryImpl(ReasonerQueryImpl q) {
        this.tx = q.tx;
        this.atomSet = ImmutableSet.builder().addAll(q.getAtoms().stream().map(at -> AtomicFactory.create(at, this)).iterator()).build();
    }

    public ReasonerQuery conjunction(ReasonerQuery q) {
        return new ReasonerQueryImpl((Set<Atomic>)Sets.union(this.getAtoms(), (Set)q.getAtoms()), this.tx());
    }

    public ReasonerQueryImpl withSubstitution(Answer sub) {
        return new ReasonerQueryImpl((Set<Atomic>)Sets.union(this.getAtoms(), (Set)sub.toPredicates((ReasonerQuery)this)), this.tx());
    }

    public ReasonerQueryImpl inferTypes() {
        return new ReasonerQueryImpl(this.getAtoms().stream().map(Atomic::inferTypes).collect(Collectors.toSet()), this.tx());
    }

    public ReasonerQueryImpl positive() {
        return new ReasonerQueryImpl(this.getAtoms().stream().filter(at -> !(at instanceof NeqPredicate)).collect(Collectors.toSet()), this.tx());
    }

    public ReasonerQueryImpl transformIds(Map<Var, ConceptId> transform) {
        Set<Atomic> atoms = this.getAtoms(IdPredicate.class).map(p -> {
            ConceptId conceptId = (ConceptId)transform.get(p.getVarName());
            if (conceptId != null) {
                return new IdPredicate(p.getVarName(), conceptId, p.getParentQuery());
            }
            return p;
        }).collect(Collectors.toSet());
        this.getAtoms().stream().filter(at -> !(at instanceof IdPredicate)).forEach(atoms::add);
        return new ReasonerQueryImpl(atoms, this.tx());
    }

    public String toString() {
        return "{\n\t" + this.getAtoms(Atom.class).map(Object::toString).collect(Collectors.joining(";\n\t")) + "\n}\n";
    }

    public ReasonerQuery copy() {
        return new ReasonerQueryImpl(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ReasonerQueryImpl q2 = (ReasonerQueryImpl)obj;
        return this.isEquivalent(q2);
    }

    public int hashCode() {
        return ReasonerQueryEquivalence.AlphaEquivalence.hash((Object)this);
    }

    public boolean isEquivalent(ReasonerQueryImpl q) {
        return ReasonerQueryEquivalence.AlphaEquivalence.equivalent((Object)this, (Object)q);
    }

    public GraknTx tx() {
        return this.tx;
    }

    public void checkValid() {
        this.getAtoms().forEach(Atomic::checkValid);
    }

    public Conjunction<PatternAdmin> getPattern() {
        return Patterns.conjunction(this.getAtoms().stream().map(Atomic::getCombinedPattern).flatMap(p -> p.admin().varPatterns().stream()).collect(Collectors.toSet()));
    }

    public Set<String> validateOntologically() {
        return this.getAtoms().stream().flatMap(at -> at.validateOntologically().stream()).collect(Collectors.toSet());
    }

    public boolean isRuleResolvable() {
        return this.selectAtoms().stream().anyMatch(Atom::isRuleResolvable);
    }

    private boolean isTransitive() {
        return this.getAtoms(Atom.class).filter(at -> ReasonerQueryEquivalence.containsEquivalentAtom(this, at, Atomic::isAlphaEquivalent)).count() == 2L;
    }

    boolean isAtomic() {
        return this.atomSet.stream().filter(Atomic::isSelectable).count() == 1L;
    }

    public boolean isTypeRoleCompatible(Var typedVar, Type parentType) {
        if (parentType == null || Schema.MetaSchema.isMetaLabel((Label)parentType.getLabel())) {
            return true;
        }
        Set parentTypes = parentType.subs().collect(Collectors.toSet());
        return this.getAtoms(RelationshipAtom.class).filter(ra -> ra.getVarNames().contains(typedVar)).noneMatch(ra -> ra.getRoleVarMap().entries().stream().filter(e -> ((Var)e.getValue()).equals((Object)typedVar)).filter(e -> !Schema.MetaSchema.isMetaLabel((Label)((Role)e.getKey()).getLabel())).anyMatch(e -> ((Role)e.getKey()).playedByTypes().noneMatch(parentTypes::contains)));
    }

    public Set<Atomic> getAtoms() {
        return this.atomSet;
    }

    public <T extends Atomic> Stream<T> getAtoms(Class<T> type) {
        return this.getAtoms().stream().filter(type::isInstance).map(type::cast);
    }

    public Set<Var> getVarNames() {
        HashSet<Var> vars = new HashSet<Var>();
        this.getAtoms().forEach(atom -> vars.addAll(atom.getVarNames()));
        return vars;
    }

    public MultiUnifier getMultiUnifier(ReasonerQuery parent) {
        return this.getMultiUnifier(parent, UnifierType.EXACT);
    }

    public MultiUnifier getMultiUnifier(ReasonerQuery parent, UnifierComparison unifierType) {
        throw GraqlQueryException.getUnifierOfNonAtomicQuery();
    }

    public GetQuery getQuery() {
        return this.tx.graql().infer(false).match(new Pattern[]{this.getPattern()}).get();
    }

    private Stream<IsaAtom> inferEntityTypes(Answer sub) {
        Set typedVars = this.getAtoms(IsaAtom.class).map(AtomicBase::getVarName).collect(Collectors.toSet());
        return Stream.concat(this.getAtoms(IdPredicate.class), sub.toPredicates((ReasonerQuery)this).stream().map(IdPredicate.class::cast)).filter(p -> !typedVars.contains(p.getVarName())).map(p -> new Pair<IdPredicate, Concept>((IdPredicate)p, this.tx().getConcept((ConceptId)p.getPredicate()))).filter(p -> Objects.nonNull(p.getValue())).filter(p -> ((Concept)p.getValue()).isEntity()).map(p -> new IsaAtom(((IdPredicate)p.getKey()).getVarName(), Graql.var(), (SchemaConcept)((Concept)p.getValue()).asEntity().type(), (ReasonerQuery)this));
    }

    private Map<Var, Type> getVarTypeMap(Stream<IsaAtom> isas) {
        HashMap<Var, Type> map = new HashMap<Var, Type>();
        isas.map(at -> new Pair<Var, SchemaConcept>(at.getVarName(), at.getSchemaConcept())).filter(p -> Objects.nonNull(p.getValue())).filter(p -> ((SchemaConcept)p.getValue()).isType()).forEach(p -> {
            Var var = (Var)p.getKey();
            Type newType = ((SchemaConcept)p.getValue()).asType();
            Type type = (Type)map.get(var);
            if (type == null) {
                map.put(var, newType);
            } else {
                boolean isSubType = type.subs().anyMatch(t -> t.equals(newType));
                if (isSubType) {
                    map.put(var, newType);
                }
            }
        });
        return map;
    }

    public ImmutableMap<Var, Type> getVarTypeMap() {
        if (this.varTypeMap == null) {
            this.varTypeMap = this.getVarTypeMap(new QueryAnswer());
        }
        return this.varTypeMap;
    }

    public ImmutableMap<Var, Type> getVarTypeMap(Answer sub) {
        return ImmutableMap.copyOf(this.getVarTypeMap(Stream.concat(this.getAtoms(IsaAtom.class), this.inferEntityTypes(sub))));
    }

    @Nullable
    private IdPredicate getIdPredicate(Var var) {
        return this.getAtoms(IdPredicate.class).filter(sub -> sub.getVarName().equals((Object)var)).findFirst().orElse(null);
    }

    public Map<Var, ConceptId> idTransform(ReasonerQueryImpl query, Unifier unifier) {
        HashMap<Var, ConceptId> transform = new HashMap<Var, ConceptId>();
        this.getAtoms(IdPredicate.class).forEach(thisP -> {
            Collection vars = unifier.get(thisP.getVarName());
            Var var = !vars.isEmpty() ? (Var)Iterators.getOnlyElement(vars.iterator()) : thisP.getVarName();
            IdPredicate p2 = query.getIdPredicate(var);
            if (p2 != null) {
                transform.put(thisP.getVarName(), (ConceptId)p2.getPredicate());
            }
        });
        return transform;
    }

    public Set<Atom> selectAtoms() {
        Set<Atom> atomsToSelect = this.getAtoms(Atom.class).filter(Atomic::isSelectable).collect(Collectors.toSet());
        if (atomsToSelect.size() <= 2) {
            return atomsToSelect;
        }
        LinkedHashSet<Atom> orderedSelection = new LinkedHashSet<Atom>();
        Atom atom = atomsToSelect.stream().filter(at -> at.getNeighbours(Atom.class).findFirst().isPresent()).findFirst().orElse(null);
        while (!atomsToSelect.isEmpty() && atom != null) {
            orderedSelection.add(atom);
            atomsToSelect.remove(atom);
            atom = atom.getNeighbours(Atom.class).filter(atomsToSelect::contains).findFirst().orElse(null);
        }
        if (!atomsToSelect.isEmpty()) {
            orderedSelection.addAll(atomsToSelect);
        }
        if (orderedSelection.isEmpty()) {
            throw GraqlQueryException.noAtomsSelected((ReasonerQuery)this);
        }
        return orderedSelection;
    }

    public Answer getSubstitution() {
        if (this.substitution == null) {
            Set<Var> varNames = this.getVarNames();
            Set<IdPredicate> predicates = this.getAtoms(IsaAtom.class).map(Binary::getTypePredicate).filter(Objects::nonNull).filter(p -> varNames.contains(p.getVarName())).collect(Collectors.toSet());
            this.getAtoms(IdPredicate.class).forEach(predicates::add);
            HashMap<Var, Concept> answerMap = new HashMap<Var, Concept>();
            predicates.forEach(p -> {
                Concept concept = this.tx().getConcept((ConceptId)p.getPredicate());
                if (concept == null) {
                    throw GraqlQueryException.idNotFound((ConceptId)((ConceptId)p.getPredicate()));
                }
                answerMap.put(p.getVarName(), concept);
            });
            this.substitution = new QueryAnswer(answerMap);
        }
        return this.substitution;
    }

    public Answer getRoleSubstitution() {
        HashMap<Var, Concept> roleSub = new HashMap<Var, Concept>();
        this.getAtoms(RelationshipAtom.class).flatMap(RelationshipAtom::getRolePredicates).forEach(p -> {
            Concept concept = this.tx().getConcept((ConceptId)p.getPredicate());
            if (concept == null) {
                throw GraqlQueryException.idNotFound((ConceptId)((ConceptId)p.getPredicate()));
            }
            roleSub.put(p.getVarName(), concept);
        });
        return new QueryAnswer(roleSub);
    }

    boolean isGround() {
        return this.getSubstitution().vars().containsAll(this.getVarNames());
    }

    private Stream<Answer> fullJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache) {
        List queries = this.selectAtoms().stream().map(ReasonerAtomicQuery::new).collect(Collectors.toList());
        Iterator qit = queries.iterator();
        ReasonerAtomicQuery childAtomicQuery = (ReasonerAtomicQuery)qit.next();
        Stream<Answer> join = childAtomicQuery.answerStream(subGoals, cache, dCache, false);
        Set<Var> joinedVars = childAtomicQuery.getVarNames();
        while (qit.hasNext()) {
            childAtomicQuery = (ReasonerAtomicQuery)qit.next();
            Sets.SetView joinVars = Sets.intersection(joinedVars, childAtomicQuery.getVarNames());
            Stream<Answer> localSubs = childAtomicQuery.answerStream(subGoals, cache, dCache, false);
            join = QueryAnswerStream.join(join, localSubs, (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars));
            joinedVars.addAll(childAtomicQuery.getVarNames());
        }
        return join;
    }

    private Stream<Answer> differentialJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache) {
        Stream<Answer> join = Stream.empty();
        ArrayList queries = this.selectAtoms().stream().map(ReasonerAtomicQuery::new).collect(Collectors.toList());
        HashSet uniqueQueries = new HashSet(queries);
        ArrayList queriesToJoin = this.isTransitive() ? Lists.newArrayList(uniqueQueries) : queries;
        for (ReasonerAtomicQuery qi : queriesToJoin) {
            Stream<Answer> subs = qi.answerStream(subGoals, cache, dCache, true);
            Set<Var> joinedVars = qi.getVarNames();
            for (ReasonerAtomicQuery qj : queries) {
                if (qj == qi) continue;
                Sets.SetView joinVars = Sets.intersection(joinedVars, qj.getVarNames());
                subs = QueryAnswerStream.joinWithInverse(subs, cache.getAnswerStream(qj), cache.getInverseAnswerMap(qj, (Set<Var>)joinVars), (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars));
                joinedVars.addAll(qj.getVarNames());
            }
            join = Stream.concat(join, subs);
        }
        return join;
    }

    Stream<Answer> computeJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean differentialJoin) {
        Set neqPredicates = this.getAtoms(NeqPredicate.class).collect(Collectors.toSet());
        ReasonerQueryImpl positive = neqPredicates.isEmpty() ? this : this.positive();
        Stream<Answer> join = differentialJoin ? positive.differentialJoin(subGoals, cache, dCache) : positive.fullJoin(subGoals, cache, dCache);
        return join.filter(a -> QueryAnswerStream.nonEqualsFilter(a, neqPredicates));
    }

    public Stream<Answer> resolve(boolean materialise) {
        if (materialise) {
            return this.resolveAndMaterialise(new LazyQueryCache<ReasonerAtomicQuery>(), new LazyQueryCache<ReasonerAtomicQuery>());
        }
        return new ResolutionIterator(this).hasStream();
    }

    Stream<Answer> resolveAndMaterialise(LazyQueryCache<ReasonerAtomicQuery> cache, LazyQueryCache<ReasonerAtomicQuery> dCache) {
        Set neqPredicates = this.getAtoms(NeqPredicate.class).collect(Collectors.toSet());
        ReasonerQueryImpl positive = neqPredicates.isEmpty() ? this : this.positive();
        Iterator<Atom> atIt = positive.selectAtoms().iterator();
        ReasonerAtomicQuery atomicQuery = new ReasonerAtomicQuery(atIt.next());
        Stream<Answer> answerStream = atomicQuery.resolveAndMaterialise(cache, dCache);
        Set<Var> joinedVars = atomicQuery.getVarNames();
        while (atIt.hasNext()) {
            atomicQuery = new ReasonerAtomicQuery(atIt.next());
            Stream<Answer> subAnswerStream = atomicQuery.resolveAndMaterialise(cache, dCache);
            Sets.SetView joinVars = Sets.intersection(joinedVars, atomicQuery.getVarNames());
            answerStream = QueryAnswerStream.join(answerStream, subAnswerStream, (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars));
            joinedVars.addAll(atomicQuery.getVarNames());
        }
        Set<Var> vars = this.getVarNames();
        return answerStream.filter(a -> QueryAnswerStream.nonEqualsFilter(a, neqPredicates)).map(a -> a.project(vars));
    }

    public ResolutionState subGoal(Answer sub, Unifier u, QueryStateBase parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        return new ConjunctiveState(this, sub, u, parent, subGoals, cache);
    }

    public Stream<ResolutionState> subGoals(Answer sub, Unifier u, QueryStateBase parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        return this.getQueryStream(sub).map(q -> q.subGoal(sub, u, parent, subGoals, cache));
    }

    Stream<ReasonerQueryImpl> getQueryStream(Answer sub) {
        return Stream.of(this);
    }

    public Pair<Iterator<ResolutionState>, MultiUnifier> queryStateIterator(QueryStateBase parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        UnmodifiableIterator subGoalIterator;
        Iterator dbIterator;
        if (!this.isRuleResolvable()) {
            dbIterator = this.getQuery().stream().map(ans -> ans.explain((AnswerExplanation)new JoinExplanation(this, (Answer)ans))).map(ans -> new AnswerState((Answer)ans, parent.getUnifier(), parent)).iterator();
            subGoalIterator = Collections.emptyIterator();
        } else {
            dbIterator = Collections.emptyIterator();
            LinkedList<ReasonerQueryImpl> subQueries = new ResolutionPlan(this).queryPlan();
            LOG.trace("CQ plan:\n" + subQueries.stream().map(sq -> sq.toString() + (sq.isRuleResolvable() ? "*" : "")).collect(Collectors.joining("\n")));
            subGoalIterator = Iterators.singletonIterator((Object)new CumulativeState(subQueries, new QueryAnswer(), parent.getUnifier(), parent, subGoals, cache));
        }
        return new Pair<Iterator<ResolutionState>, MultiUnifier>(Iterators.concat(dbIterator, subGoalIterator), new MultiUnifierImpl());
    }

    public boolean requiresReiteration() {
        Set<InferenceRule> dependentRules = RuleUtils.getDependentRules(this);
        return RuleUtils.subGraphIsCyclical(dependentRules, this.tx()) || RuleUtils.subGraphHasRulesWithHeadSatisfyingBody(dependentRules);
    }
}

