/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.rule;

import ai.grakn.GraknTx;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.util.Schema;
import com.google.common.base.Equivalence;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Stream;

public class RuleUtils {
    public static Stream<Rule> getRules(GraknTx graph) {
        return graph.admin().getMetaRule().subs().filter(sub -> !sub.equals(graph.admin().getMetaRule()));
    }

    public static boolean hasRules(GraknTx graph) {
        VarPattern rule = Graql.label(Schema.MetaSchema.RULE.getLabel());
        return graph.graql().infer(false).match(new Pattern[]{Graql.var("x").sub(rule).neq(rule)}).iterator().hasNext();
    }

    public static Stream<Rule> getRulesWithType(SchemaConcept type, GraknTx graph) {
        return type != null ? type.subs().flatMap(SchemaConcept::getRulesOfConclusion) : RuleUtils.getRules(graph);
    }

    public static boolean subGraphIsCyclical(Set<InferenceRule> rules, GraknTx graph) {
        Iterator ruleIterator = rules.stream().map(r -> (Rule)graph.getConcept(r.getRuleId())).iterator();
        boolean cyclical = false;
        while (ruleIterator.hasNext() && !cyclical) {
            HashSet<Rule> visitedRules = new HashSet<Rule>();
            Stack rulesToVisit = new Stack();
            rulesToVisit.push(ruleIterator.next());
            while (!rulesToVisit.isEmpty() && !cyclical) {
                Rule rule = (Rule)rulesToVisit.pop();
                if (!visitedRules.contains(rule)) {
                    rule.getConclusionTypes().flatMap(SchemaConcept::getRulesOfHypothesis).forEach(rulesToVisit::add);
                    visitedRules.add(rule);
                    continue;
                }
                cyclical = true;
            }
        }
        return cyclical;
    }

    public static boolean subGraphHasRulesWithHeadSatisfyingBody(Set<InferenceRule> rules) {
        return rules.stream().anyMatch(InferenceRule::headSatisfiesBody);
    }

    public static Set<InferenceRule> getDependentRules(ReasonerQueryImpl query) {
        Equivalence<Atom> equivalence = new Equivalence<Atom>(){

            protected boolean doEquivalent(Atom a1, Atom a2) {
                return a1.isAlphaEquivalent(a2);
            }

            protected int doHash(Atom a) {
                return a.alphaEquivalenceHashCode();
            }
        };
        HashSet<InferenceRule> rules = new HashSet<InferenceRule>();
        HashSet<Equivalence.Wrapper> visitedAtoms = new HashSet<Equivalence.Wrapper>();
        Stack atoms = new Stack();
        query.selectAtoms().stream().map(arg_0 -> ((Equivalence)equivalence).wrap(arg_0)).forEach(atoms::push);
        while (!atoms.isEmpty()) {
            Equivalence.Wrapper wrappedAtom = (Equivalence.Wrapper)atoms.pop();
            Atom atom = (Atom)wrappedAtom.get();
            if (visitedAtoms.contains(wrappedAtom) || atom == null) continue;
            atom.getApplicableRules().peek(rules::add).flatMap(rule -> rule.getBody().selectAtoms().stream()).map(arg_0 -> ((Equivalence)equivalence).wrap(arg_0)).filter(at -> !visitedAtoms.contains(at)).filter(at -> !atoms.contains(at)).forEach(atoms::add);
            visitedAtoms.add(wrappedAtom);
        }
        return rules;
    }
}

