/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.state;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.explanation.RuleExplanation;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.state.AnswerState;
import ai.grakn.graql.internal.reasoner.state.QueryState;
import ai.grakn.graql.internal.reasoner.state.QueryStateBase;
import ai.grakn.graql.internal.reasoner.state.ResolutionState;
import ai.grakn.graql.internal.reasoner.state.RoleExpansionState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;

@SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
public class AtomicState
extends QueryState<ReasonerAtomicQuery> {
    public AtomicState(ReasonerAtomicQuery q, Answer sub, Unifier u, QueryStateBase parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        super(ReasonerQueries.atomic(q, sub), sub, u, parent, subGoals, cache);
    }

    @Override
    ResolutionState propagateAnswer(AnswerState state) {
        Answer answer = state.getAnswer();
        ReasonerAtomicQuery query = (ReasonerAtomicQuery)this.getQuery();
        if (answer.isEmpty()) {
            return null;
        }
        if (state.getRule() != null && query.getAtom().requiresRoleExpansion()) {
            return new RoleExpansionState(answer, this.getUnifier(), query.getAtom().getRoleExpansionVariables(), this.getParentState());
        }
        return new AnswerState(answer, this.getUnifier(), this.getParentState());
    }

    @Override
    Answer consumeAnswer(AnswerState state) {
        ReasonerAtomicQuery query = (ReasonerAtomicQuery)this.getQuery();
        Answer baseAnswer = state.getSubstitution();
        InferenceRule rule = state.getRule();
        Unifier unifier = state.getUnifier();
        Answer answer = rule == null ? state.getSubstitution() : (rule.requiresMaterialisation(query.getAtom()) ? this.materialisedAnswer(baseAnswer, rule, unifier) : this.ruleAnswer(baseAnswer, rule, unifier));
        return this.getCache().recordAnswerWithUnifier(query, answer, this.getCacheUnifier());
    }

    private Answer ruleAnswer(Answer baseAnswer, InferenceRule rule, Unifier unifier) {
        ReasonerAtomicQuery query = (ReasonerAtomicQuery)this.getQuery();
        Answer answer = baseAnswer.merge(rule.getHead().getRoleSubstitution()).unify(unifier);
        if (answer.isEmpty()) {
            return answer;
        }
        return answer.merge(query.getSubstitution()).project(query.getVarNames()).explain((AnswerExplanation)new RuleExplanation((ReasonerQuery)query, rule));
    }

    private Answer materialisedAnswer(Answer baseAnswer, InferenceRule rule, Unifier unifier) {
        QueryAnswer queryAnswer;
        Answer answer = baseAnswer;
        ReasonerAtomicQuery query = (ReasonerAtomicQuery)this.getQuery();
        QueryCache<ReasonerAtomicQuery> cache = this.getCache();
        ReasonerAtomicQuery subbedQuery = ReasonerQueries.atomic(query, answer);
        ReasonerAtomicQuery ruleHead = ReasonerQueries.atomic(rule.getHead(), answer);
        Set<Var> queryVars = query.getVarNames().size() < ruleHead.getVarNames().size() ? unifier.keySet() : ruleHead.getVarNames();
        boolean queryEquivalentToHead = subbedQuery.isEquivalent(ruleHead);
        Answer headAnswer = cache.getAnswer(ruleHead, answer).project(queryVars).unify(unifier);
        QueryAnswer queryAnswer2 = queryAnswer = headAnswer.isEmpty() && queryEquivalentToHead ? cache.getAnswer(query, answer) : new QueryAnswer();
        if (headAnswer.isEmpty() && queryAnswer.isEmpty()) {
            Answer materialisedSub = ruleHead.materialise(answer).findFirst().orElse(null);
            if (!queryEquivalentToHead) {
                cache.recordAnswer(ruleHead, materialisedSub);
            }
            answer = materialisedSub.project(queryVars).unify(unifier);
        } else {
            QueryAnswer queryAnswer3 = answer = headAnswer.isEmpty() ? queryAnswer : headAnswer;
        }
        if (answer.isEmpty()) {
            return answer;
        }
        return answer.merge(query.getSubstitution()).explain((AnswerExplanation)new RuleExplanation((ReasonerQuery)query, rule));
    }
}

