/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.state;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.state.AnswerState;
import ai.grakn.graql.internal.reasoner.state.AtomicState;
import ai.grakn.graql.internal.reasoner.state.QueryStateBase;
import ai.grakn.graql.internal.reasoner.state.ResolutionState;
import java.util.Set;
import java.util.stream.Collectors;

public class NeqComplementState
extends AtomicState {
    private final Answer predicateSub;
    private final ResolutionState complementState;
    private boolean visited = false;
    private final Set<NeqPredicate> predicates;

    public NeqComplementState(ReasonerAtomicQuery q, Answer sub, Unifier u, QueryStateBase parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        super(q, sub, u, parent, subGoals, cache);
        ReasonerAtomicQuery complementQuery = ReasonerQueries.atomic(q.positive(), sub);
        this.predicates = q.getAtoms(NeqPredicate.class).collect(Collectors.toSet());
        this.predicateSub = sub.project(this.predicates.stream().flatMap(p -> p.getVarNames().stream()).collect(Collectors.toSet()));
        this.complementState = complementQuery.subGoal(sub, u, this, subGoals, cache);
    }

    @Override
    public ResolutionState propagateAnswer(AnswerState state) {
        Answer fullAnswer = state.getSubstitution().merge(this.predicateSub);
        boolean isNeqSatisfied = !this.predicates.stream().anyMatch(p -> !p.isSatisfied(fullAnswer));
        return isNeqSatisfied ? new AnswerState(state.getSubstitution(), this.getUnifier(), this.getParentState()) : null;
    }

    @Override
    public ResolutionState generateSubGoal() {
        if (!this.visited) {
            this.visited = true;
            return this.complementState;
        }
        return null;
    }
}

