/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.utils;

import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.pattern.property.LabelProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.utils.conversion.RoleConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.SchemaConceptConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.TypeConverter;
import ai.grakn.util.Schema;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ReasonerUtils {
    public static IdPredicate getUserDefinedIdPredicate(Var typeVariable, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        return vars.stream().filter(v -> v.var().equals((Object)typeVariable)).flatMap(v -> v.hasProperty(LabelProperty.class) ? v.getProperties(LabelProperty.class).map(np -> new IdPredicate(typeVariable, np.label(), parent)) : v.getProperties(IdProperty.class).map(np -> new IdPredicate(typeVariable, np.id(), parent))).findFirst().orElse(null);
    }

    @Nullable
    public static IdPredicate getIdPredicate(Var typeVariable, VarPatternAdmin typeVar, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        IdPredicate predicate = null;
        if (typeVar.var().isUserDefinedName()) {
            predicate = ReasonerUtils.getUserDefinedIdPredicate(typeVariable, vars, parent);
        } else {
            LabelProperty nameProp = typeVar.getProperty(LabelProperty.class).orElse(null);
            if (nameProp != null) {
                predicate = new IdPredicate(typeVariable, nameProp.label(), parent);
            }
        }
        return predicate;
    }

    public static Set<ValuePredicate> getValuePredicates(Var valueVariable, VarPatternAdmin valueVar, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        HashSet<ValuePredicate> predicates = new HashSet<ValuePredicate>();
        if (valueVar.var().isUserDefinedName()) {
            vars.stream().filter(v -> v.var().equals((Object)valueVariable)).flatMap(v -> v.getProperties(ValueProperty.class).map(vp -> new ValuePredicate(v.var(), vp.predicate(), parent))).forEach(predicates::add);
        } else {
            valueVar.getProperties(ValueProperty.class).forEach(vp -> predicates.add(new ValuePredicate(ValuePredicate.createValueVar(valueVariable, vp.predicate()), parent)));
        }
        return predicates;
    }

    public static Set<SchemaConcept> supers(SchemaConcept schemaConcept) {
        HashSet<SchemaConcept> superTypes = new HashSet<SchemaConcept>();
        for (SchemaConcept superType = schemaConcept.sup(); superType != null && !Schema.MetaSchema.isMetaLabel((Label)superType.getLabel()); superType = superType.sup()) {
            superTypes.add(superType);
        }
        return superTypes;
    }

    public static Set<SchemaConcept> upstreamHierarchy(SchemaConcept concept) {
        HashSet<SchemaConcept> concepts = new HashSet<SchemaConcept>();
        for (SchemaConcept superType = concept; superType != null; superType = superType.sup()) {
            concepts.add(superType);
        }
        return concepts;
    }

    public static <K, V> Multimap<K, V> multimapIntersection(Multimap<K, V> m1, Multimap<K, V> m2) {
        HashMultimap intersection = HashMultimap.create();
        Sets.SetView keyIntersection = Sets.intersection((Set)m1.keySet(), (Set)m2.keySet());
        Stream.concat(m1.entries().stream(), m2.entries().stream()).filter(e -> keyIntersection.contains(e.getKey())).forEach(arg_0 -> ReasonerUtils.lambda$multimapIntersection$9((Multimap)intersection, arg_0));
        return intersection;
    }

    public static <T extends SchemaConcept> Multimap<RelationshipType, Role> compatibleRelationTypesWithRoles(Set<T> types, SchemaConceptConverter<T> schemaConceptConverter) {
        Multimap<RelationshipType, Role> compatibleTypes = HashMultimap.create();
        if (types.isEmpty()) {
            return compatibleTypes;
        }
        Iterator<T> typeIterator = types.iterator();
        compatibleTypes.putAll(schemaConceptConverter.toRelationshipMultimap((SchemaConcept)typeIterator.next()));
        while (typeIterator.hasNext() && compatibleTypes.size() > 1) {
            compatibleTypes = ReasonerUtils.multimapIntersection(compatibleTypes, schemaConceptConverter.toRelationshipMultimap((SchemaConcept)typeIterator.next()));
        }
        return compatibleTypes;
    }

    public static Set<Role> compatibleRoles(Role parentRole, Type parentType, Set<Role> entryRoles) {
        Set<Object> compatibleRoles;
        Set<Object> set = compatibleRoles = parentRole != null ? Sets.newHashSet((Object[])new Role[]{parentRole}) : Sets.newHashSet();
        if (parentRole != null && !Schema.MetaSchema.isMetaLabel((Label)parentRole.getLabel())) {
            compatibleRoles.addAll((Collection<Object>)Sets.intersection(new RoleConverter().toCompatibleRoles(parentRole).collect(Collectors.toSet()), entryRoles));
        } else {
            compatibleRoles.addAll(entryRoles);
        }
        if (parentType != null && !Schema.MetaSchema.isMetaLabel((Label)parentType.getLabel())) {
            Set compatibleRolesFromTypes = new TypeConverter().toCompatibleRoles(parentType).collect(Collectors.toSet());
            compatibleRoles = compatibleRoles.stream().filter(role -> Schema.MetaSchema.isMetaLabel((Label)role.getLabel()) || compatibleRolesFromTypes.contains(role)).collect(Collectors.toSet());
            if (parentRole != null) {
                compatibleRoles.add(parentRole);
            }
        }
        return compatibleRoles;
    }

    public static Set<Role> compatibleRoles(Type type, Set<Role> relRoles) {
        return ReasonerUtils.compatibleRoles(null, type, relRoles);
    }

    public static <T extends SchemaConcept> Set<T> top(Set<T> schemaConcepts) {
        return schemaConcepts.stream().filter(rt -> Sets.intersection(ReasonerUtils.supers(rt), (Set)schemaConcepts).isEmpty()).collect(Collectors.toSet());
    }

    public static <T extends SchemaConcept> Set<T> topOrMeta(Set<T> schemaConcepts) {
        Set<T> concepts = ReasonerUtils.top(schemaConcepts);
        SchemaConcept meta = concepts.stream().filter(c -> Schema.MetaSchema.isMetaLabel((Label)c.getLabel())).findFirst().orElse(null);
        return meta != null ? Collections.singleton(meta) : concepts;
    }

    public static Unifier typeUnifier(Set<TypeAtom> childTypes, Set<TypeAtom> parentTypes, Unifier childParentUnifier) {
        Unifier unifier = childParentUnifier;
        for (TypeAtom childType : childTypes) {
            Var parentVarName;
            Var childVarName = childType.getVarName();
            Var var = parentVarName = unifier.containsKey(childVarName) ? (Var)Iterables.getOnlyElement((Iterable)childParentUnifier.get(childVarName)) : childVarName;
            TypeAtom parentType = parentTypes.stream().filter(pt -> pt.getVarName().equals((Object)parentVarName)).findFirst().orElse(null);
            if (parentType == null) continue;
            unifier = unifier.merge(childType.getUnifier(parentType));
        }
        return unifier;
    }

    public static boolean typesCompatible(SchemaConcept parent, SchemaConcept child) {
        if (parent == null) {
            return true;
        }
        if (child == null) {
            return false;
        }
        if (Schema.MetaSchema.isMetaLabel((Label)parent.getLabel())) {
            return true;
        }
        for (SchemaConcept superType = child; superType != null && !Schema.MetaSchema.isMetaLabel((Label)superType.getLabel()); superType = superType.sup()) {
            if (!superType.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean areDisjointTypes(SchemaConcept parent, SchemaConcept child) {
        return parent != null && child == null || !ReasonerUtils.typesCompatible(parent, child) && !ReasonerUtils.typesCompatible(child, parent);
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>(a);
        b.forEach(list::remove);
        return list;
    }

    private static /* synthetic */ void lambda$multimapIntersection$9(Multimap intersection, Map.Entry e) {
        intersection.put(e.getKey(), e.getValue());
    }
}

