/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.utils.conversion;

import ai.grakn.concept.Concept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.internal.reasoner.utils.conversion.AttributeConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.EntityConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.RelationshipConverter;
import ai.grakn.util.CommonUtil;

public interface ConceptConverter<T extends Concept> {
    public static Pattern toPattern(Concept concept) {
        if (!concept.isThing()) {
            throw GraqlQueryException.conceptNotAThing((Object)concept);
        }
        if (concept.isEntity()) {
            return new EntityConverter().pattern(concept.asEntity());
        }
        if (concept.isRelationship()) {
            return new RelationshipConverter().pattern(concept.asRelationship());
        }
        if (concept.isAttribute()) {
            return new AttributeConverter().pattern(concept.asAttribute());
        }
        throw CommonUtil.unreachableStatement((String)("Unrecognised concept " + concept));
    }
}

