
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.graql.Var;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_PropertyExecutor extends PropertyExecutor {

  private final ImmutableSet<Var> requiredVars;
  private final ImmutableSet<Var> producedVars;
  private final PropertyExecutor.Method executeMethod;

  private AutoValue_PropertyExecutor(
      ImmutableSet<Var> requiredVars,
      ImmutableSet<Var> producedVars,
      PropertyExecutor.Method executeMethod) {
    this.requiredVars = requiredVars;
    this.producedVars = producedVars;
    this.executeMethod = executeMethod;
  }

  @Override
  public ImmutableSet<Var> requiredVars() {
    return requiredVars;
  }

  @Override
  public ImmutableSet<Var> producedVars() {
    return producedVars;
  }

  @Override
  PropertyExecutor.Method executeMethod() {
    return executeMethod;
  }

  @Override
  public String toString() {
    return "PropertyExecutor{"
        + "requiredVars=" + requiredVars + ", "
        + "producedVars=" + producedVars + ", "
        + "executeMethod=" + executeMethod
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PropertyExecutor) {
      PropertyExecutor that = (PropertyExecutor) o;
      return (this.requiredVars.equals(that.requiredVars()))
           && (this.producedVars.equals(that.producedVars()))
           && (this.executeMethod.equals(that.executeMethod()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.requiredVars.hashCode();
    h *= 1000003;
    h ^= this.producedVars.hashCode();
    h *= 1000003;
    h ^= this.executeMethod.hashCode();
    return h;
  }

  static final class Builder extends PropertyExecutor.Builder {
    private ImmutableSet.Builder<Var> requiredVarsBuilder$;
    private ImmutableSet<Var> requiredVars;
    private ImmutableSet.Builder<Var> producedVarsBuilder$;
    private ImmutableSet<Var> producedVars;
    private PropertyExecutor.Method executeMethod;
    Builder() {
    }
    @Override
    ImmutableSet.Builder<Var> requiredVarsBuilder() {
      if (requiredVarsBuilder$ == null) {
        requiredVarsBuilder$ = ImmutableSet.builder();
      }
      return requiredVarsBuilder$;
    }
    @Override
    ImmutableSet.Builder<Var> producedVarsBuilder() {
      if (producedVarsBuilder$ == null) {
        producedVarsBuilder$ = ImmutableSet.builder();
      }
      return producedVarsBuilder$;
    }
    @Override
    PropertyExecutor.Builder executeMethod(PropertyExecutor.Method executeMethod) {
      if (executeMethod == null) {
        throw new NullPointerException("Null executeMethod");
      }
      this.executeMethod = executeMethod;
      return this;
    }
    @Override
    PropertyExecutor build() {
      if (requiredVarsBuilder$ != null) {
        this.requiredVars = requiredVarsBuilder$.build();
      } else if (this.requiredVars == null) {
        this.requiredVars = ImmutableSet.of();
      }
      if (producedVarsBuilder$ != null) {
        this.producedVars = producedVarsBuilder$.build();
      } else if (this.producedVars == null) {
        this.producedVars = ImmutableSet.of();
      }
      String missing = "";
      if (this.executeMethod == null) {
        missing += " executeMethod";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PropertyExecutor(
          this.requiredVars,
          this.producedVars,
          this.executeMethod);
    }
  }

}
