/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.Keyspace;
import ai.grakn.factory.TxFactory;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.shaded.minlog.Log;

public class FactoryBuilder {
    static final String KB_MODE = "knowledge-base.mode";
    static final String KB_ANALYTICS = "knowledge-base.analytics";
    private static final Map<String, TxFactory<?>> openFactories = new ConcurrentHashMap();
    private static final Map<String, String> factoryMapper = ImmutableMap.of((Object)"in-memory", (Object)"ai.grakn.factory.TxFactoryTinker", (Object)"production", (Object)"ai.grakn.factory.TxFactoryJanus", (Object)"distributed", (Object)"ai.grakn.factory.TxFactoryJanusHadoop");

    private FactoryBuilder() {
        throw new UnsupportedOperationException();
    }

    public static TxFactory<?> getFactory(Keyspace keyspace, String engineUrl, Properties properties) {
        try {
            String factoryType = factoryMapper.get(properties.get(KB_MODE).toString());
            return FactoryBuilder.getFactory(factoryType, keyspace, engineUrl, properties);
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException(ErrorMessage.MISSING_FACTORY_DEFINITION.getMessage(new Object[0]));
        }
    }

    static TxFactory<?> getFactory(String factoryType, Keyspace keyspace, String engineUrl, Properties properties) {
        String key = factoryType + keyspace;
        Log.debug((String)("Get factory for " + key));
        TxFactory<?> factory = openFactories.get(key);
        if (factory != null) {
            return factory;
        }
        return FactoryBuilder.newFactory(key, factoryType, keyspace, engineUrl, properties);
    }

    private static synchronized TxFactory<?> newFactory(String key, String factoryType, Keyspace keyspace, String engineUrl, Properties properties) {
        TxFactory txFactory;
        try {
            txFactory = (TxFactory)Class.forName(factoryType).getDeclaredConstructor(Keyspace.class, String.class, Properties.class).newInstance(keyspace, engineUrl, properties);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(ErrorMessage.INVALID_FACTORY.getMessage(new Object[]{factoryType}), e);
        }
        openFactories.put(key, txFactory);
        Log.debug((String)("New factory created " + txFactory));
        return txFactory;
    }

    public static void refresh() {
        openFactories.clear();
    }
}

