/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknComputer;
import ai.grakn.GraknSession;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.factory.FactoryBuilder;
import ai.grakn.factory.TxFactory;
import ai.grakn.factory.TxFactoryTinker;
import ai.grakn.kb.internal.GraknTxAbstract;
import ai.grakn.kb.internal.computer.GraknComputerImpl;
import ai.grakn.util.EngineCommunicator;
import ai.grakn.util.ErrorMessage;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mjson.Json;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraknSessionImpl
implements GraknSession {
    private static final Logger LOG = LoggerFactory.getLogger(GraknSessionImpl.class);
    private static final int LOG_SUBMISSION_PERIOD = 1;
    private final ScheduledExecutorService commitLogSubmitter;
    private final String engineUri;
    private final Keyspace keyspace;
    private final Properties properties;
    private GraknTxAbstract<?> tx = null;
    private GraknTxAbstract<?> txBatch = null;

    public GraknSessionImpl(Keyspace keyspace, String engineUri) {
        this.engineUri = engineUri;
        this.keyspace = keyspace;
        this.commitLogSubmitter = Executors.newSingleThreadScheduledExecutor();
        this.commitLogSubmitter.scheduleAtFixedRate(() -> {
            this.submitLogs(this.tx);
            this.submitLogs(this.txBatch);
        }, 0L, 1L, TimeUnit.SECONDS);
        this.properties = "in-memory".equals(engineUri) ? GraknSessionImpl.getTxInMemoryProperties() : GraknSessionImpl.getTxRemoteProperties(engineUri, keyspace);
    }

    private static Properties getTxRemoteProperties(String engineUrl, Keyspace keyspace) {
        String restFactoryUri = engineUrl + "/initialise" + "?" + "keyspace" + "=" + keyspace;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)Json.read((String)EngineCommunicator.contactEngine(restFactoryUri, "GET")).asMap());
        return properties;
    }

    private static Properties getTxInMemoryProperties() {
        Properties inMemoryProperties = new Properties();
        inMemoryProperties.put("knowledge-base.sharding-threshold", (Object)100000);
        inMemoryProperties.put("knowledge-base.schema-cache-timeout-ms", (Object)30000);
        inMemoryProperties.put("knowledge-base.mode", TxFactoryTinker.class.getName());
        return inMemoryProperties;
    }

    public GraknTx open(GraknTxType transactionType) {
        TxFactory<?> factory = this.configureTxFactory("default");
        switch (transactionType) {
            case READ: 
            case WRITE: {
                this.tx = factory.open(transactionType);
                return this.tx;
            }
            case BATCH: {
                this.txBatch = factory.open(transactionType);
                return this.txBatch;
            }
        }
        throw GraknTxOperationException.transactionInvalid((Object)transactionType);
    }

    public GraknComputer getGraphComputer() {
        TxFactory<?> configuredFactory = this.configureTxFactory("computer");
        Object graph = configuredFactory.getTinkerPopGraph(false);
        return new GraknComputerImpl((Graph)graph);
    }

    public void close() throws GraknTxOperationException {
        int openTransactions = this.openTransactions(this.tx) + this.openTransactions(this.txBatch);
        if (openTransactions > 0) {
            LOG.warn(ErrorMessage.TXS_OPEN.getMessage(new Object[]{this.keyspace, openTransactions}));
        }
        this.commitLogSubmitter.shutdown();
        this.close(this.tx);
        this.close(this.txBatch);
    }

    private void close(GraknTxAbstract tx) {
        if (tx != null) {
            tx.closeSession();
            this.submitLogs(tx);
        }
    }

    private void submitLogs(GraknTxAbstract tx) {
        if (tx != null) {
            tx.commitLog().submit(this.engineUri, this.keyspace).ifPresent(arg_0 -> ((Logger)LOG).debug(arg_0));
        }
    }

    private int openTransactions(GraknTxAbstract<?> graph) {
        if (graph == null) {
            return 0;
        }
        return graph.numOpenTx();
    }

    TxFactory<?> configureTxFactory(String configType) {
        if ("in-memory".equals(this.engineUri)) {
            return FactoryBuilder.getFactory(TxFactoryTinker.class.getName(), this.keyspace, "in-memory", this.properties);
        }
        return this.configureTxFactoryRemote(configType);
    }

    private TxFactory<?> configureTxFactoryRemote(String configType) {
        if ("default".equals(configType)) {
            return FactoryBuilder.getFactory(this.keyspace, this.engineUri, this.properties);
        }
        if ("computer".equals(configType)) {
            Properties computerProperties = new Properties();
            computerProperties.putAll((Map<?, ?>)this.properties);
            computerProperties.setProperty("knowledge-base.mode", this.properties.get("knowledge-base.analytics").toString());
            return FactoryBuilder.getFactory(this.keyspace, this.engineUri, computerProperties);
        }
        throw new IllegalArgumentException("Config option [" + configType + "] not supported");
    }
}

