/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.factory.TxFactory;
import ai.grakn.kb.internal.GraknTxAbstract;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.CheckReturnValue;
import javax.annotation.meta.When;
import org.apache.tinkerpop.gremlin.structure.Graph;

abstract class TxFactoryAbstract<M extends GraknTxAbstract<G>, G extends Graph>
implements TxFactory<G> {
    protected final Keyspace keyspace;
    protected final String engineUrl;
    protected final Properties properties;
    private M graknTx = null;
    private M graknTxBatchLoading = null;
    G tx = null;
    private G txBatchLoading = null;

    TxFactoryAbstract(Keyspace keyspace, String engineUrl, Properties properties) {
        Objects.requireNonNull(keyspace);
        this.keyspace = keyspace;
        this.engineUrl = engineUrl;
        this.properties = properties;
    }

    abstract M buildGraknGraphFromTinker(G var1);

    abstract G buildTinkerPopGraph(boolean var1);

    public synchronized M open(GraknTxType txType) {
        if (GraknTxType.BATCH.equals((Object)txType)) {
            this.checkOtherGraphOpen((GraknTx)this.graknTx);
            this.graknTxBatchLoading = this.getGraph(this.graknTxBatchLoading, txType);
            return this.graknTxBatchLoading;
        }
        this.checkOtherGraphOpen((GraknTx)this.graknTxBatchLoading);
        this.graknTx = this.getGraph(this.graknTx, txType);
        return this.graknTx;
    }

    private void checkOtherGraphOpen(GraknTx otherGraph) {
        if (otherGraph != null && !otherGraph.isClosed()) {
            throw GraknTxOperationException.transactionOpen((GraknTx)otherGraph);
        }
    }

    private M getGraph(M graknGraph, GraknTxType txType) {
        boolean batchLoading = GraknTxType.BATCH.equals((Object)txType);
        if (graknGraph == null) {
            graknGraph = this.buildGraknGraphFromTinker(this.getTinkerPopGraph(batchLoading));
        } else {
            if (!((GraknTxAbstract)graknGraph).isClosed()) {
                throw GraknTxOperationException.transactionOpen(graknGraph);
            }
            if (((GraknTxAbstract)graknGraph).isSessionClosed()) {
                graknGraph = this.buildGraknGraphFromTinker(this.getTinkerPopGraph(batchLoading));
            }
        }
        ((GraknTxAbstract)graknGraph).openTransaction(txType);
        return graknGraph;
    }

    @Override
    public synchronized G getTinkerPopGraph(boolean batchLoading) {
        if (batchLoading) {
            this.txBatchLoading = this.getTinkerPopGraph(this.txBatchLoading, true);
            return this.txBatchLoading;
        }
        this.tx = this.getTinkerPopGraph(this.tx, false);
        return this.tx;
    }

    G getTinkerPopGraph(G graph, boolean batchLoading) {
        if (graph == null) {
            return this.buildTinkerPopGraph(batchLoading);
        }
        return this.getGraphWithNewTransaction(graph, batchLoading);
    }

    @CheckReturnValue(when=When.NEVER)
    protected abstract G getGraphWithNewTransaction(G var1, boolean var2);
}

