/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal;

import ai.grakn.Keyspace;
import ai.grakn.concept.ConceptId;
import ai.grakn.util.EngineCommunicator;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mjson.Json;

public class CommitLog {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<ConceptId, Long> newInstanceCount = new ConcurrentHashMap<ConceptId, Long>();
    private final Map<String, Set<String>> newAttributes = new ConcurrentHashMap<String, Set<String>>();

    void addNewAttributes(Map<String, ConceptId> attributes) {
        this.lockDataAddition(() -> attributes.forEach((key, value) -> this.newAttributes.merge((String)key, Sets.newHashSet((Object[])new String[]{value.getValue()}), (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        })));
    }

    void addNewInstances(Map<ConceptId, Long> instances) {
        this.lockDataAddition(() -> instances.forEach((key, value) -> this.newInstanceCount.merge((ConceptId)key, (Long)value, (v1, v2) -> v1 + v2)));
    }

    private void lockDataAddition(Runnable dataAdder) {
        try {
            this.lock.readLock().lock();
            dataAdder.run();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void clear() {
        this.newInstanceCount.clear();
        this.newAttributes.clear();
    }

    public Json getFormattedLog() {
        return CommitLog.formatLog(this.newInstanceCount, this.newAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> submit(String engineUri, Keyspace keyspace) {
        if (this.newInstanceCount.isEmpty() && this.newAttributes.isEmpty()) {
            return Optional.empty();
        }
        String endPoint = CommitLog.getCommitLogEndPoint(engineUri, keyspace);
        try {
            this.lock.writeLock().lock();
            String response = EngineCommunicator.contactEngine(endPoint, "POST", this.getFormattedLog().toString());
            this.clear();
            Optional<String> optional = Optional.of("Response from engine [" + response + "]");
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static String getCommitLogEndPoint(String engineUri, Keyspace keyspace) {
        if ("in-memory".equals(engineUri)) {
            return "in-memory";
        }
        return engineUri + "/commit_log" + "?" + "keyspace" + "=" + keyspace;
    }

    static Json formatTxLog(Map<ConceptId, Long> instances, Map<String, ConceptId> attributes) {
        ConcurrentHashMap<String, Set<String>> newAttributes = new ConcurrentHashMap<String, Set<String>>();
        attributes.forEach((key, value) -> newAttributes.put((String)key, Sets.newHashSet((Object[])new String[]{value.getValue()})));
        return CommitLog.formatLog(instances, newAttributes);
    }

    static Json formatLog(Map<ConceptId, Long> instances, Map<String, Set<String>> attributes) {
        Json conceptsForInspection = Json.object();
        conceptsForInspection.set(Schema.BaseType.ATTRIBUTE.name(), Json.make(attributes));
        Json typesWithInstanceChanges = Json.array();
        instances.forEach((key, value) -> {
            Json jsonObject = Json.object();
            jsonObject.set("concept-id", (Object)key.getValue());
            jsonObject.set("sharding-count", value);
            typesWithInstanceChanges.add(jsonObject);
        });
        Json formattedLog = Json.object();
        formattedLog.set("concepts-to-fix", conceptsForInspection);
        formattedLog.set("types-with-new-counts", typesWithInstanceChanges);
        return formattedLog;
    }
}

