/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.exception.PropertyNotUniqueException;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.kb.admin.GraknAdmin;
import ai.grakn.kb.internal.CommitLog;
import ai.grakn.kb.internal.Validator;
import ai.grakn.kb.internal.cache.GlobalCache;
import ai.grakn.kb.internal.cache.TxCache;
import ai.grakn.kb.internal.concept.AttributeImpl;
import ai.grakn.kb.internal.concept.ConceptImpl;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.ElementFactory;
import ai.grakn.kb.internal.concept.RelationshipEdge;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.EngineCommunicator;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraknTxAbstract<G extends Graph>
implements GraknTx,
GraknAdmin {
    final Logger LOG = LoggerFactory.getLogger(GraknTxAbstract.class);
    private static final String QUERY_BUILDER_CLASS_NAME = "ai.grakn.graql.internal.query.QueryBuilderImpl";
    public static final String SHARDING_THRESHOLD = "knowledge-base.sharding-threshold";
    public static final String NORMAL_CACHE_TIMEOUT_MS = "knowledge-base.schema-cache-timeout-ms";
    private final CommitLog commitLog;
    private final Keyspace keyspace;
    private final String engineUri;
    private final Properties properties;
    private final G graph;
    private final ElementFactory elementFactory;
    private final GlobalCache globalCache;
    private static Constructor<?> queryConstructor = null;
    private final ThreadLocal<TxCache> localConceptLog = new ThreadLocal();
    @Nullable
    private GraphTraversalSource graphTraversalSource = null;

    public GraknTxAbstract(G graph, Keyspace keyspace, String engineUri, Properties properties) {
        this.graph = graph;
        this.keyspace = keyspace;
        this.engineUri = engineUri;
        this.properties = properties;
        this.elementFactory = new ElementFactory(this);
        this.commitLog = new CommitLog();
        this.globalCache = new GlobalCache(properties);
        this.txCache().openTx(GraknTxType.WRITE);
        if (this.initialiseMetaConcepts()) {
            this.close(true, false);
        }
    }

    public LabelId convertToId(Label label) {
        if (this.txCache().isLabelCached(label)) {
            return this.txCache().convertLabelToId(label);
        }
        return LabelId.invalid();
    }

    private LabelId getNextId() {
        TypeImpl metaConcept = (TypeImpl)this.getMetaConcept();
        Integer currentValue = (Integer)metaConcept.vertex().property(Schema.VertexProperty.CURRENT_LABEL_ID);
        currentValue = currentValue == null ? Integer.valueOf(Schema.MetaSchema.values().length + 1) : Integer.valueOf(currentValue + 1);
        metaConcept.property(Schema.VertexProperty.CURRENT_LABEL_ID, currentValue);
        return LabelId.of((Integer)currentValue);
    }

    GlobalCache getGlobalCache() {
        return this.globalCache;
    }

    public abstract boolean isConceptModified(Concept var1);

    public abstract int numOpenTx();

    public void openTransaction(GraknTxType txType) {
        this.txCache().openTx(txType);
    }

    public CommitLog commitLog() {
        return this.commitLog;
    }

    public String getEngineUrl() {
        return this.engineUri;
    }

    Properties getProperties() {
        return this.properties;
    }

    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public TxCache txCache() {
        TxCache txCache = this.localConceptLog.get();
        if (txCache == null) {
            txCache = new TxCache(this.getGlobalCache());
            this.localConceptLog.set(txCache);
        }
        if (txCache.isTxOpen() && txCache.schemaNotCached()) {
            txCache.refreshSchemaCache();
        }
        return txCache;
    }

    public boolean isClosed() {
        return !this.txCache().isTxOpen();
    }

    public abstract boolean isSessionClosed();

    public boolean isReadOnly() {
        return GraknTxType.READ.equals((Object)this.txCache().txType());
    }

    public GraknAdmin admin() {
        return this;
    }

    public <T extends Concept> Optional<T> buildConcept(Vertex vertex) {
        return this.factory().buildConcept(vertex);
    }

    public <T extends Concept> Optional<T> buildConcept(Edge edge) {
        return this.factory().buildConcept(edge);
    }

    public boolean isBatchTx() {
        return GraknTxType.BATCH.equals((Object)this.txCache().txType());
    }

    private boolean initialiseMetaConcepts() {
        boolean schemaInitialised = false;
        if (this.isMetaSchemaNotInitialised()) {
            VertexElement type = this.addTypeVertex(Schema.MetaSchema.THING.getId(), Schema.MetaSchema.THING.getLabel(), Schema.BaseType.TYPE);
            VertexElement entityType = this.addTypeVertex(Schema.MetaSchema.ENTITY.getId(), Schema.MetaSchema.ENTITY.getLabel(), Schema.BaseType.ENTITY_TYPE);
            VertexElement relationType = this.addTypeVertex(Schema.MetaSchema.RELATIONSHIP.getId(), Schema.MetaSchema.RELATIONSHIP.getLabel(), Schema.BaseType.RELATIONSHIP_TYPE);
            VertexElement resourceType = this.addTypeVertex(Schema.MetaSchema.ATTRIBUTE.getId(), Schema.MetaSchema.ATTRIBUTE.getLabel(), Schema.BaseType.ATTRIBUTE_TYPE);
            this.addTypeVertex(Schema.MetaSchema.ROLE.getId(), Schema.MetaSchema.ROLE.getLabel(), Schema.BaseType.ROLE);
            this.addTypeVertex(Schema.MetaSchema.RULE.getId(), Schema.MetaSchema.RULE.getLabel(), Schema.BaseType.RULE);
            relationType.property(Schema.VertexProperty.IS_ABSTRACT, true);
            resourceType.property(Schema.VertexProperty.IS_ABSTRACT, true);
            entityType.property(Schema.VertexProperty.IS_ABSTRACT, true);
            relationType.addEdge(type, Schema.EdgeLabel.SUB);
            resourceType.addEdge(type, Schema.EdgeLabel.SUB);
            entityType.addEdge(type, Schema.EdgeLabel.SUB);
            schemaInitialised = true;
        }
        this.copyToCache((SchemaConcept)this.getMetaConcept());
        this.copyToCache((SchemaConcept)this.getMetaRole());
        this.copyToCache((SchemaConcept)this.getMetaRule());
        return schemaInitialised;
    }

    private void copyToCache(SchemaConcept schemaConcept) {
        schemaConcept.subs().forEach(concept -> {
            this.getGlobalCache().cacheLabel(concept.getLabel(), concept.getLabelId());
            this.getGlobalCache().cacheType(concept.getLabel(), (SchemaConcept)concept);
        });
    }

    private boolean isMetaSchemaNotInitialised() {
        return this.getMetaConcept() == null;
    }

    public G getTinkerPopGraph() {
        return this.graph;
    }

    public GraphTraversalSource getTinkerTraversal() {
        this.operateOnOpenGraph(() -> null);
        if (this.graphTraversalSource == null) {
            this.graphTraversalSource = this.getTinkerPopGraph().traversal().withStrategies(new TraversalStrategy[]{ReadOnlyStrategy.instance()});
        }
        return this.graphTraversalSource;
    }

    public QueryBuilder graql() {
        if (queryConstructor == null) {
            throw new RuntimeException("The query builder implementation ai.grakn.graql.internal.query.QueryBuilderImpl must be accessible in the classpath and have a one argument constructor taking a GraknTx");
        }
        try {
            return (QueryBuilder)queryConstructor.newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ElementFactory factory() {
        return this.elementFactory;
    }

    public <T extends Concept> Optional<T> getConcept(Schema.VertexProperty key, Object value) {
        GraphTraversal vertices = this.getTinkerTraversal().V(new Object[0]).has(key.name(), value);
        if (vertices.hasNext()) {
            Vertex vertex = (Vertex)vertices.next();
            if (vertices.hasNext()) {
                this.LOG.warn(ErrorMessage.TOO_MANY_CONCEPTS.getMessage(new Object[]{key.name(), value}));
            }
            return this.factory().buildConcept(vertex);
        }
        return Optional.empty();
    }

    private Set<Concept> getConcepts(Schema.VertexProperty key, Object value) {
        HashSet<Concept> concepts = new HashSet<Concept>();
        this.getTinkerTraversal().V(new Object[0]).has(key.name(), value).forEachRemaining(v -> this.factory().buildConcept((Vertex)v).ifPresent(concepts::add));
        return concepts;
    }

    public void checkSchemaMutationAllowed() {
        this.checkMutationAllowed();
        if (this.isBatchTx()) {
            throw GraknTxOperationException.schemaMutation();
        }
    }

    public void checkMutationAllowed() {
        if (this.isReadOnly()) {
            throw GraknTxOperationException.transactionReadOnly((GraknTx)this);
        }
    }

    public VertexElement addVertexElement(Schema.BaseType baseType, ConceptId ... conceptIds) {
        return this.factory().addVertexElement(baseType, conceptIds);
    }

    private VertexElement addTypeVertex(LabelId id, Label label, Schema.BaseType baseType) {
        VertexElement vertexElement = this.addVertexElement(baseType, new ConceptId[0]);
        vertexElement.property(Schema.VertexProperty.SCHEMA_LABEL, label.getValue());
        vertexElement.property(Schema.VertexProperty.LABEL_ID, id.getValue());
        return vertexElement;
    }

    private <X> X operateOnOpenGraph(Supplier<X> supplier) {
        if (this.isClosed()) {
            throw GraknTxOperationException.transactionClosed((GraknTx)this, (String)this.txCache().getClosedReason());
        }
        return supplier.get();
    }

    public EntityType putEntityType(String label) {
        return this.putEntityType(Label.of((String)label));
    }

    public EntityType putEntityType(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.ENTITY_TYPE, v -> this.factory().buildEntityType((VertexElement)v, this.getMetaEntityType()));
    }

    private <T extends SchemaConcept> T putSchemaConcept(Label label, Schema.BaseType baseType, Function<VertexElement, T> newConceptFactory) {
        this.checkSchemaMutationAllowed();
        SchemaConceptImpl schemaConcept = (SchemaConceptImpl)this.getSchemaConcept(this.convertToId(label));
        if (schemaConcept == null) {
            VertexElement vertexElement = this.addTypeVertex(this.getNextId(), label, baseType);
            schemaConcept = SchemaConceptImpl.from(this.buildSchemaConcept(label, () -> (SchemaConcept)newConceptFactory.apply(vertexElement)));
        } else if (!baseType.equals((Object)schemaConcept.baseType())) {
            throw this.labelTaken(schemaConcept);
        }
        return (T)schemaConcept;
    }

    private GraknTxOperationException labelTaken(SchemaConcept schemaConcept) {
        if (Schema.MetaSchema.isMetaLabel((Label)schemaConcept.getLabel())) {
            return GraknTxOperationException.reservedLabel((Label)schemaConcept.getLabel());
        }
        return PropertyNotUniqueException.cannotCreateProperty((Concept)schemaConcept, (Schema.VertexProperty)Schema.VertexProperty.SCHEMA_LABEL, (Object)schemaConcept.getLabel());
    }

    private <T extends Concept> T validateSchemaConcept(Concept concept, Schema.BaseType baseType, Supplier<T> invalidHandler) {
        if (concept != null && baseType.getClassType().isInstance(concept)) {
            return (T)concept;
        }
        return (T)((Concept)invalidHandler.get());
    }

    private SchemaConcept buildSchemaConcept(Label label, Supplier<SchemaConcept> dbBuilder) {
        if (this.txCache().isTypeCached(label)) {
            return this.txCache().getCachedSchemaConcept(label);
        }
        return dbBuilder.get();
    }

    public RelationshipType putRelationshipType(String label) {
        return this.putRelationshipType(Label.of((String)label));
    }

    public RelationshipType putRelationshipType(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.RELATIONSHIP_TYPE, v -> this.factory().buildRelationType((VertexElement)v, this.getMetaRelationType(), Boolean.FALSE));
    }

    public RelationshipType putRelationTypeImplicit(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.RELATIONSHIP_TYPE, v -> this.factory().buildRelationType((VertexElement)v, this.getMetaRelationType(), Boolean.TRUE));
    }

    public Role putRole(String label) {
        return this.putRole(Label.of((String)label));
    }

    public Role putRole(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.ROLE, v -> this.factory().buildRole((VertexElement)v, this.getMetaRole(), Boolean.FALSE));
    }

    public Role putRoleTypeImplicit(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.ROLE, v -> this.factory().buildRole((VertexElement)v, this.getMetaRole(), Boolean.TRUE));
    }

    public <V> AttributeType<V> putAttributeType(String label, AttributeType.DataType<V> dataType) {
        return this.putAttributeType(Label.of((String)label), dataType);
    }

    public <V> AttributeType<V> putAttributeType(Label label, AttributeType.DataType<V> dataType) {
        AttributeType attributeType = this.putSchemaConcept(label, Schema.BaseType.ATTRIBUTE_TYPE, v -> this.factory().buildResourceType((VertexElement)v, this.getMetaResourceType(), dataType));
        if (Schema.MetaSchema.isMetaLabel((Label)label)) {
            throw GraknTxOperationException.metaTypeImmutable((Label)label);
        }
        if (!dataType.equals((Object)attributeType.getDataType())) {
            throw GraknTxOperationException.immutableProperty((Object)attributeType.getDataType(), dataType, (Enum)Schema.VertexProperty.DATA_TYPE);
        }
        return attributeType;
    }

    public Rule putRule(String label, Pattern when, Pattern then) {
        return this.putRule(Label.of((String)label), when, then);
    }

    public Rule putRule(Label label, Pattern when, Pattern then) {
        return this.putSchemaConcept(label, Schema.BaseType.RULE, v -> this.factory().buildRule((VertexElement)v, this.getMetaRule(), when, then));
    }

    public <T extends Concept> T getConcept(ConceptId id) {
        return (T)this.operateOnOpenGraph(() -> {
            Optional concept;
            if (this.txCache().isConceptCached(id)) {
                return this.txCache().getCachedConcept(id);
            }
            if (id.getValue().startsWith("E") && (concept = this.getConceptEdge(id)).isPresent()) {
                return (Concept)concept.get();
            }
            return this.getConcept(Schema.VertexProperty.ID, id.getValue()).orElse(null);
        });
    }

    private <T extends Concept> Optional<T> getConceptEdge(ConceptId id) {
        String edgeId = id.getValue().substring(1);
        GraphTraversal traversal = this.getTinkerTraversal().E(new Object[]{edgeId});
        if (traversal.hasNext()) {
            return this.factory().buildConcept(this.factory().buildEdgeElement((Edge)traversal.next()));
        }
        return Optional.empty();
    }

    private <T extends SchemaConcept> T getSchemaConcept(Label label, Schema.BaseType baseType) {
        this.operateOnOpenGraph(() -> null);
        SchemaConcept schemaConcept = this.buildSchemaConcept(label, () -> this.getSchemaConcept(this.convertToId(label)));
        return (T)this.validateSchemaConcept((Concept)schemaConcept, baseType, () -> null);
    }

    @Nullable
    public <T extends SchemaConcept> T getSchemaConcept(LabelId id) {
        if (!id.isValid()) {
            return null;
        }
        return (T)((SchemaConcept)this.getConcept(Schema.VertexProperty.LABEL_ID, id.getValue()).orElse(null));
    }

    public <V> Collection<Attribute<V>> getAttributesByValue(V value) {
        if (value == null) {
            return Collections.emptySet();
        }
        if (!AttributeType.DataType.SUPPORTED_TYPES.containsKey((Object)value.getClass().getName())) {
            throw GraknTxOperationException.unsupportedDataType(value);
        }
        HashSet attributes = new HashSet();
        AttributeType.DataType dataType = (AttributeType.DataType)AttributeType.DataType.SUPPORTED_TYPES.get((Object)value.getClass().getTypeName());
        this.getConcepts(dataType.getVertexProperty(), dataType.getPersistenceValue(value)).forEach(concept -> {
            if (concept != null && concept.isAttribute()) {
                attributes.add(concept.asAttribute());
            }
        });
        return attributes;
    }

    public <T extends SchemaConcept> T getSchemaConcept(Label label) {
        return this.getSchemaConcept(label, Schema.BaseType.SCHEMA_CONCEPT);
    }

    public <T extends Type> T getType(Label label) {
        return (T)((Type)this.getSchemaConcept(label, Schema.BaseType.TYPE));
    }

    public EntityType getEntityType(String label) {
        return (EntityType)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.ENTITY_TYPE);
    }

    public RelationshipType getRelationshipType(String label) {
        return (RelationshipType)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.RELATIONSHIP_TYPE);
    }

    public <V> AttributeType<V> getAttributeType(String label) {
        return (AttributeType)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.ATTRIBUTE_TYPE);
    }

    public Role getRole(String label) {
        return (Role)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.ROLE);
    }

    public Rule getRule(String label) {
        return (Rule)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.RULE);
    }

    public Type getMetaConcept() {
        return (Type)this.getSchemaConcept(Schema.MetaSchema.THING.getId());
    }

    public RelationshipType getMetaRelationType() {
        return (RelationshipType)this.getSchemaConcept(Schema.MetaSchema.RELATIONSHIP.getId());
    }

    public Role getMetaRole() {
        return (Role)this.getSchemaConcept(Schema.MetaSchema.ROLE.getId());
    }

    public AttributeType getMetaResourceType() {
        return (AttributeType)this.getSchemaConcept(Schema.MetaSchema.ATTRIBUTE.getId());
    }

    public EntityType getMetaEntityType() {
        return (EntityType)this.getSchemaConcept(Schema.MetaSchema.ENTITY.getId());
    }

    public Rule getMetaRule() {
        return (Rule)this.getSchemaConcept(Schema.MetaSchema.RULE.getId());
    }

    public void putShortcutEdge(Thing toThing, RelationshipReified fromRelation, Role roleType) {
        boolean exists = this.getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)fromRelation.getId().getValue()).outE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).has(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID.name(), (Object)((RelationshipType)fromRelation.type()).getLabelId().getValue()).has(Schema.EdgeProperty.ROLE_LABEL_ID.name(), (Object)roleType.getLabelId().getValue()).inV().has(Schema.VertexProperty.ID.name(), (Object)toThing.getId()).hasNext();
        if (!exists) {
            EdgeElement edge = fromRelation.addEdge(ConceptVertex.from((Concept)toThing), Schema.EdgeLabel.ROLE_PLAYER);
            edge.property(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID, ((RelationshipType)fromRelation.type()).getLabelId().getValue());
            edge.property(Schema.EdgeProperty.ROLE_LABEL_ID, roleType.getLabelId().getValue());
            this.txCache().trackForValidation(this.factory().buildCasting(edge));
        }
    }

    public void delete() {
        this.closeSession();
        this.clearGraph();
        this.txCache().closeTx(ErrorMessage.CLOSED_CLEAR.getMessage(new Object[0]));
        EngineCommunicator.contactEngine(this.getDeleteKeyspaceEndpoint(), "DELETE");
    }

    protected void clearGraph() {
        this.getTinkerPopGraph().traversal().V(new Object[0]).drop().iterate();
    }

    public void closeSession() {
        try {
            this.txCache().closeTx(ErrorMessage.SESSION_CLOSED.getMessage(new Object[]{this.getKeyspace()}));
            this.getTinkerPopGraph().close();
        }
        catch (Exception e) {
            throw GraknTxOperationException.closingFailed((GraknTx)this, (Exception)e);
        }
    }

    public void close() {
        this.close(false, false);
    }

    public void abort() {
        this.close();
    }

    public void commit() throws InvalidKBException {
        this.close(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> close(boolean commitRequired, boolean trackLogs) {
        Optional<String> logs = Optional.empty();
        if (this.isClosed()) {
            return logs;
        }
        String closeMessage = ErrorMessage.TX_CLOSED_ON_ACTION.getMessage(new Object[]{"closed", this.getKeyspace()});
        try {
            if (commitRequired) {
                closeMessage = ErrorMessage.TX_CLOSED_ON_ACTION.getMessage(new Object[]{"committed", this.getKeyspace()});
                logs = this.commitWithLogs(trackLogs);
                this.txCache().writeToGraphCache(true);
            } else {
                this.txCache().writeToGraphCache(this.isReadOnly());
            }
        }
        finally {
            this.closeTransaction(closeMessage);
        }
        return logs;
    }

    private void closeTransaction(String closedReason) {
        try {
            this.graph.tx().close();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        finally {
            this.txCache().closeTx(closedReason);
        }
    }

    public Optional<String> commitNoLogs() throws InvalidKBException {
        return this.close(true, false);
    }

    private Optional<String> commitWithLogs(boolean trackingNeeded) throws InvalidKBException {
        this.validateGraph();
        Map<ConceptId, Long> newInstances = this.txCache().getShardingCount();
        Map<String, ConceptId> newAttributes = this.txCache().getNewAttributes();
        boolean logsExist = !newInstances.isEmpty() || !newAttributes.isEmpty();
        this.LOG.trace("Graph is valid. Committing graph . . . ");
        this.commitTransactionInternal();
        this.LOG.trace("Graph committed.");
        if (logsExist) {
            if (trackingNeeded) {
                this.commitLog().addNewInstances(newInstances);
                this.commitLog().addNewAttributes(newAttributes);
            } else {
                return Optional.of(CommitLog.formatTxLog(newInstances, newAttributes).toString());
            }
        }
        return Optional.empty();
    }

    void commitTransactionInternal() {
        try {
            this.getTinkerPopGraph().tx().commit();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void validateGraph() throws InvalidKBException {
        List<String> errors;
        Validator validator = new Validator(this);
        if (!validator.validate() && !(errors = validator.getErrorsFound()).isEmpty()) {
            throw InvalidKBException.validationErrors(errors);
        }
    }

    private String getDeleteKeyspaceEndpoint() {
        if ("in-memory".equals(this.engineUri)) {
            return "in-memory";
        }
        return this.engineUri + "/deleteKeyspace" + "?" + "keyspace" + "=" + this.keyspace;
    }

    public boolean validElement(Element element) {
        return element != null;
    }

    private <X extends ConceptImpl> Set<X> getDuplicates(X mainConcept, Set<ConceptId> conceptIds) {
        Set duplicated = conceptIds.stream().map(this::getConcept).filter(Objects::nonNull).collect(Collectors.toSet());
        duplicated.remove(mainConcept);
        return duplicated;
    }

    public boolean duplicateResourcesExist(String index, Set<ConceptId> resourceVertexIds) {
        Optional<AttributeImpl> mainResource = this.getConcept(Schema.VertexProperty.INDEX, index);
        return mainResource.filter(attribute -> this.getDuplicates(attribute, resourceVertexIds).size() > 0).isPresent();
    }

    public boolean fixDuplicateResources(String index, Set<ConceptId> resourceVertexIds) {
        Optional mainResourceOp = this.getConcept(Schema.VertexProperty.INDEX, index);
        if (!mainResourceOp.isPresent()) {
            this.LOG.debug(String.format("Could not post process concept with index {%s} due to not finding the concept", index));
            return false;
        }
        AttributeImpl mainResource = (AttributeImpl)mainResourceOp.get();
        Set<AttributeImpl> duplicates = this.getDuplicates(mainResource, resourceVertexIds);
        if (duplicates.size() > 0) {
            for (Attribute attribute : duplicates) {
                Stream otherRelations = attribute.relationships(new Role[0]);
                otherRelations.forEach(otherRelation -> this.copyRelation(mainResource, otherAttribute, (Relationship)otherRelation));
                AttributeImpl.from(attribute).deleteNode();
            }
            String newIndex = mainResource.getIndex();
            ((Vertex)mainResource.vertex().element()).property(Schema.VertexProperty.INDEX.name(), (Object)newIndex);
            return true;
        }
        return false;
    }

    private void copyRelation(Attribute main, Attribute other, Relationship otherRelationship) {
        Optional<RelationshipReified> reifiedRelation = ((RelationshipImpl)otherRelationship).reified();
        if (reifiedRelation.isPresent()) {
            this.copyRelation(main, other, otherRelationship, reifiedRelation.get());
        } else {
            this.copyRelation(main, other, otherRelationship, (RelationshipEdge)RelationshipImpl.from(otherRelationship).structure());
        }
    }

    private void copyRelation(Attribute main, Attribute other, Relationship otherRelationship, RelationshipReified reifiedRelation) {
        Optional optional;
        String newIndex = reifiedRelation.getIndex().replaceAll(other.getId().getValue(), main.getId().getValue());
        Relationship foundRelationship = this.txCache().getCachedRelation(newIndex);
        if (foundRelationship == null && (optional = this.getConcept(Schema.VertexProperty.INDEX, newIndex)).isPresent()) {
            foundRelationship = (Relationship)optional.get();
        }
        if (foundRelationship != null) {
            reifiedRelation.deleteNode();
        } else {
            foundRelationship = otherRelationship;
            otherRelationship.allRolePlayers().forEach((roleType, instances) -> {
                Optional<RelationshipReified> relationReified = RelationshipImpl.from(otherRelationship).reified();
                if (instances.contains(other) && relationReified.isPresent()) {
                    this.putShortcutEdge((Thing)main, relationReified.get(), (Role)roleType);
                }
            });
        }
        this.txCache().getRelationIndexCache().put(newIndex, foundRelationship);
    }

    private void copyRelation(Attribute main, Attribute other, Relationship otherRelationship, RelationshipEdge relationEdge) {
        ConceptVertex newValue;
        ConceptVertex newOwner;
        if (relationEdge.owner().equals(other)) {
            newOwner = ConceptVertex.from((Concept)main);
            newValue = ConceptVertex.from((Concept)relationEdge.value());
        } else {
            newOwner = ConceptVertex.from((Concept)relationEdge.owner());
            newValue = ConceptVertex.from((Concept)main);
        }
        EdgeElement edge = newOwner.vertex().putEdge(newValue.vertex(), Schema.EdgeLabel.ATTRIBUTE);
        this.factory().buildRelation(edge, relationEdge.type(), relationEdge.ownerRole(), relationEdge.valueRole());
    }

    public void updateConceptCounts(Map<ConceptId, Long> typeCounts) {
        typeCounts.forEach((key, value) -> {
            if (value != 0L) {
                ConceptImpl concept = (ConceptImpl)this.getConcept((ConceptId)key);
                concept.setShardCount(concept.getShardCount() + value);
            }
        });
    }

    public void shard(ConceptId conceptId) {
        ConceptImpl type = (ConceptImpl)this.getConcept(conceptId);
        if (type == null) {
            this.LOG.warn("Cannot shard concept [" + conceptId + "] due to it not existing in the graph");
        } else {
            type.createShard();
        }
    }

    static {
        try {
            queryConstructor = Class.forName(QUERY_BUILDER_CLASS_NAME).getConstructor(GraknTx.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            queryConstructor = null;
        }
    }
}

